/*
 * Decompiled with CFR 0.152.
 */
package core.support.annotation.template.service;

import core.support.annotation.helper.FileCreatorHelper;
import core.support.annotation.helper.Logger;
import core.support.annotation.helper.PackageHelper;
import java.io.BufferedWriter;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.tools.JavaFileObject;
import org.apache.commons.lang3.StringUtils;

public class ServiceRunner {
    public static JavaFileObject CSV_File_Object = null;
    public static String SERVICE_ROOT = "serviceManager";
    public static String SERVICE_RUNNER_CLASS = "ServiceRunner";

    public static void writeServiceClass(Map<String, List<Element>> serviceMap) {
        try {
            ServiceRunner.writeServiceClassImplementation(serviceMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void writeServiceClassImplementation(Map<String, List<Element>> serviceMap) throws Exception {
        ServiceRunner.writeServiceRunner(serviceMap);
    }

    private static void writeServiceRunner(Map<String, List<Element>> serviceMap) throws Exception {
        String serviceClassName = StringUtils.capitalize((String)SERVICE_RUNNER_CLASS);
        Logger.debug("<<<<< start generating service class " + serviceClassName + " >>>>");
        String filePath = PackageHelper.SERVICE_PATH + "." + serviceClassName;
        JavaFileObject fileObject = FileCreatorHelper.createFileAbsolutePath(filePath);
        BufferedWriter bw = new BufferedWriter(fileObject.openWriter());
        Date currentDate = new Date();
        bw.append("/**Auto generated code,don't modify it.\n");
        bw.append("* Author             ---- > Auto Generated.\n");
        bw.append("* Date  And Time     ---- > " + currentDate.toString() + "\n");
        bw.append("*");
        bw.append("**/\n\n\n\n");
        bw.append("package " + SERVICE_ROOT + ";\n");
        bw.newLine();
        bw.newLine();
        bw.append("import core.support.logger.TestLog;\n");
        bw.append("import core.apiCore.helpers.CsvReader;\n");
        bw.newLine();
        bw.append("import java.util.HashMap;\n");
        bw.append("import java.util.List;\n");
        bw.append("import java.util.Map;\n");
        bw.newLine();
        bw.append("import core.support.objects.ServiceObject;\n");
        bw.append("import core.uiCore.drivers.AbstractDriverTestNG;\n");
        bw.append("import core.apiCore.ServiceManager;\n");
        for (Map.Entry<String, List<Element>> entry : serviceMap.entrySet()) {
            for (Element element : entry.getValue()) {
                String servicelPath = element.asType().toString();
                bw.append("import " + servicelPath + ";\n");
            }
        }
        bw.newLine();
        bw.newLine();
        bw.append("public class " + serviceClassName + " {\n");
        bw.newLine();
        bw.newLine();
        bw.append("public static void TestRunner(String TestSuite, String TestCaseID, String RunFlag, String Description, \n");
        bw.append("\t\tString InterfaceType, String UriPath, String ContentType, String Method, String Option, \n");
        bw.append("\t\tString RequestHeaders, String TemplateFile, String RequestBody, String OutputParams, String RespCodeExp, \n");
        bw.append("\t\tString ExpectedResponse, String TcComments, \n");
        bw.append("\t\tString tcName, String tcIndex, String testType, Object... serviceSteps) throws Exception { \n");
        bw.newLine();
        bw.append("\t\t// add parameters to ServiceObject \n");
        bw.append("\t\tServiceObject serviceObject = new ServiceObject().setServiceObject(TestSuite, TestCaseID, RunFlag, Description, InterfaceType, \n");
        bw.append("\t\tUriPath, ContentType, Method, Option, RequestHeaders, TemplateFile, RequestBody, OutputParams, \n");
        bw.append("\t\tRespCodeExp, ExpectedResponse, TcComments, tcName, \n");
        bw.append("\t\ttcIndex, testType, serviceSteps); \n");
        bw.newLine();
        bw.append("\t\t// set parent object \n");
        bw.append("\t\tServiceManager.setupParentObject(serviceObject); \n");
        bw.newLine();
        bw.append("\t\t// set test base override \n");
        bw.append("\t\tServiceManager.setTestBaseOverride(serviceObject); \n");
        bw.newLine();
        bw.append("\t\t// run before each test file \n");
        bw.append("\t\tServiceManager.runBeforeCsv(serviceObject); \n");
        bw.newLine();
        bw.append("\t\t// setup api driver \n");
        bw.append("\t\tnew AbstractDriverTestNG().setupApiDriver(serviceObject); \n");
        bw.append("\t\trunServiceTests(serviceObject); \n");
        bw.newLine();
        bw.append("\t\t// run after each test file \n");
        bw.append("\t\tServiceManager.runAfterCsv(serviceObject); \n");
        bw.append("} \n");
        bw.newLine();
        bw.newLine();
        bw.append(" @SuppressWarnings(\"unchecked\") \n");
        bw.append("\tpublic static void runServiceTests(ServiceObject serviceObject) throws Exception { \n");
        bw.append("\t\tif(serviceObject.getServiceSteps() instanceof HashMap) { \n");
        bw.append("\t\t\tMap<String, List<Object[]>> testStepMap = (Map<String, List<Object[]>>) serviceObject.getServiceSteps(); \n");
        bw.append("\t\t\tList<Object[]> teststeps = testStepMap.get(CsvReader.getTestname(serviceObject.getTestCaseID())); \n");
        bw.append("\t\t\tfor(int i = 0; i < teststeps.size(); i ++) { \n");
        bw.append("\t\t\t\tTestLog.logPass(\"******** Starting Step \" +  (i+1) + \" **********\"); \n");
        bw.append("\t\t\t\tServiceObject stepObject = CsvReader.mapToServiceObject(teststeps.get(i));  \n");
        bw.append("\t\t\t\trunInterface(stepObject); \n");
        bw.append("\t\t\t} \n");
        bw.append("\t\t}else \n");
        bw.append("\t\t\trunInterface(serviceObject); \n");
        bw.append("\t} \n");
        bw.newLine();
        bw.newLine();
        bw.append("public static void runInterface(ServiceObject serviceObject) throws Exception { \n");
        bw.newLine();
        bw.newLine();
        bw.append("\t\tswitch (serviceObject.getInterfaceType()) {");
        for (Map.Entry<String, List<Element>> entry : serviceMap.entrySet()) {
            for (Element element : entry.getValue()) {
                String serviceName = element.getSimpleName().toString();
                String lowerCaseServiceName = Character.toLowerCase(serviceName.charAt(0)) + serviceName.substring(1);
                bw.newLine();
                bw.append("\t\tcase \"" + serviceName + "\": \n");
                bw.append("  \t\t  new " + serviceName + "()." + lowerCaseServiceName + "(serviceObject); \n");
                bw.append("\t\t\t\tbreak; \n");
            }
        }
        bw.append("\t\tdefault: \n");
        bw.append("\t\t\t\tServiceManager.runInterface(serviceObject); \n");
        bw.append("\t\t\t\tbreak; \n");
        bw.append("\t\t} \n");
        bw.append("} \n");
        bw.append("} \n");
        bw.flush();
        bw.close();
        Logger.debug("<<<< completed generating service class: " + serviceClassName + ">>>>");
    }
}

