/*
 * Decompiled with CFR 0.152.
 */
package core.support.annotation.template.config;

import core.support.annotation.helper.DataObjectHelper;
import core.support.annotation.helper.FileCreatorHelper;
import core.support.annotation.helper.Logger;
import core.support.annotation.helper.PackageHelper;
import core.support.annotation.processor.MainGenerator;
import core.support.configReader.Config;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.tools.JavaFileObject;

public class ConfigVariableGenerator {
    public static String CONFIG_VARIABLE = "ConfigVariable";

    public static void writeConfigVariableClass() {
        try {
            ConfigVariableGenerator.writeConfigVariableClassImplementation();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void writeConfigVariableClassImplementation() throws IOException {
        JavaFileObject fileObject;
        Logger.debug("start generating config variable class");
        if (FileCreatorHelper.CONFIG_VARIABLE_FILE_OBJECT != null) {
            return;
        }
        FileCreatorHelper.CONFIG_VARIABLE_FILE_OBJECT = fileObject = MainGenerator.PROCESS_ENV.getFiler().createSourceFile(PackageHelper.CONFIG_MANAGER_PATH + "." + CONFIG_VARIABLE, new Element[0]);
        BufferedWriter bw = new BufferedWriter(fileObject.openWriter());
        Date currentDate = new Date();
        bw.append("/**Auto generated code,don't modify it.\n");
        bw.append("* Author             ---- > Auto Generated.\n");
        bw.append("* Date  And Time     ---- > " + currentDate.toString() + "\n");
        bw.append("*");
        bw.append("**/\n\n\n\n");
        bw.append("package " + PackageHelper.CONFIG_MANAGER_PATH + ";\n");
        bw.newLine();
        bw.newLine();
        bw.append("import core.support.configReader.Config;\n");
        bw.newLine();
        bw.newLine();
        bw.append("public class ConfigVariable {\n");
        bw.newLine();
        Map<String, Object> config = Config.loadConfigProperties();
        for (Map.Entry<String, Object> entry : config.entrySet()) {
            String splChrs = "-/@#$%^&_+=()";
            boolean containsSpecialCharacters = entry.getKey().matches("[" + splChrs + "]+");
            if (containsSpecialCharacters) continue;
            bw.append("\tpublic static ConfigManager " + DataObjectHelper.normalizeMethod(entry.getKey()) + "() {\n");
            bw.append("\t\tString value = Config.getValue(\"" + entry.getKey() + "\");\n");
            bw.append("\t\treturn new ConfigManager(\"" + entry.getKey() + "\", value);\n");
            bw.append("\t}\n");
            bw.newLine();
        }
        bw.append("\tpublic static void setValue(String key, Object value) {\n");
        bw.append("\t\tConfig.putValue(key, value.toString());\n");
        bw.append("\t}\n");
        bw.append("\tpublic static String getStringValue(String key) {\n");
        bw.append("\t\tString value = Config.getValue(key);\n");
        bw.append("\t\treturn value;\n");
        bw.append("\t}\n");
        bw.append("\tpublic static boolean getBooleanValue(String key) {\n");
        bw.append("\t\tboolean value = Config.getBooleanValue(key);\n");
        bw.append("\t\treturn value;\n");
        bw.append("\t}\n");
        bw.append("\tpublic static int getIntegerValue(String key) {\n");
        bw.append("\t\tint value = Config.getIntValue(key);\n");
        bw.append("\t\treturn value;\n");
        bw.append("\t}\n");
        bw.append("}\n");
        bw.flush();
        bw.close();
        Logger.debug("complete generating config variable class");
    }
}

