/*
 * Decompiled with CFR 0.152.
 */
package core.support.annotation.helper.annotationMap;

import core.support.annotation.Service;
import core.support.annotation.helper.Logger;
import core.support.annotation.helper.PackageHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;

public class ServiceMapHelper {
    public static Map<String, List<File>> getServiceModuleMap(List<File> files) {
        HashMap<String, List<File>> serviceMap = new HashMap<String, List<File>>();
        for (File file : files) {
            List<File> dataFiles = new ArrayList<File>();
            String module = PackageHelper.getModuleFromFullPath(file);
            if (serviceMap.get(module) != null) {
                dataFiles = (List)serviceMap.get(module);
                dataFiles.add(file);
            } else {
                dataFiles.add(file);
            }
            serviceMap.put(module, dataFiles);
        }
        return serviceMap;
    }

    public static Map<String, List<Element>> getServiceObjectMap(RoundEnvironment roundEnv) {
        return ServiceMapHelper.addElementsToServiceMap(roundEnv);
    }

    public static Map<String, List<Element>> addElementsToServiceMap(RoundEnvironment roundEnv) {
        Map<String, List<Element>> serviceMap = ServiceMapHelper.initializeServiceMap(roundEnv);
        String serviceName = "";
        for (Map.Entry<String, List<Element>> entry : serviceMap.entrySet()) {
            ArrayList<Element> elements = new ArrayList<Element>();
            serviceName = entry.getKey();
            for (Element element : roundEnv.getElementsAnnotatedWith(Service.class)) {
                String currentServiceName;
                if (element.getKind() != ElementKind.CLASS || !(currentServiceName = PackageHelper.getModuleName(element)).equals(entry.getKey())) continue;
                Logger.debug("addElementsToServiceMap: module: " + currentServiceName + " adding interface: " + element.asType().toString());
                elements.add(element);
            }
            Logger.debug("addElementsToServiceMap: serviceName: " + serviceName + " service count: " + elements.size());
            serviceMap.put(serviceName, elements);
        }
        return serviceMap;
    }

    public static Map<String, List<Element>> initializeServiceMap(RoundEnvironment roundEnv) {
        HashMap<String, List<Element>> map = new HashMap<String, List<Element>>();
        ArrayList elements = new ArrayList();
        for (Element element : roundEnv.getElementsAnnotatedWith(Service.class)) {
            if (element.getKind() != ElementKind.CLASS) continue;
            String serviceName = PackageHelper.getModuleName(element);
            map.put(serviceName, elements);
        }
        return map;
    }

    public static Map<String, List<String>> mergeMaps(Map<String, List<String>> mapA, Map<String, List<String>> mapB) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.putAll(mapA);
        mapB.forEach((key, value) -> {
            List list = (List)map.get(key);
            if (list == null) {
                map.put((String)key, (List<String>)value);
            } else {
                ArrayList mergedValue = new ArrayList(value);
                mergedValue.addAll(list);
                map.put((String)key, mergedValue);
            }
        });
        return map;
    }
}

