/*
 * Decompiled with CFR 0.152.
 */
package core.helpers;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import core.helpers.Helper;
import core.support.configReader.PropertiesReader;
import core.support.objects.TestObject;
import core.uiCore.driverProperties.globalProperties.CrossPlatformProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.json.JSONObject;

public class LocalizationHelper {
    public static String DEFAULT_LOCAL = "english";

    protected static String localize(String key) {
        String localFile = CrossPlatformProperties.getLocalizationFile();
        String translation = "";
        if (localFile.endsWith(".csv")) {
            translation = LocalizationHelper.localizeFromCsv(key);
        } else if (localFile.endsWith(".json")) {
            translation = LocalizationHelper.localizeFromJson(key);
        }
        if (translation != null && !translation.isEmpty()) {
            return translation;
        }
        return key;
    }

    protected static String localizeFromCsv(String value) {
        String translation = TestObject.getTestInfo().languageMap.get(value);
        return translation;
    }

    protected static void localizationSetupCsv(String language) {
        TestObject.getTestInfo().language = language;
        LocalizationHelper.loadCsvFileContent();
    }

    protected static String localizeFromJson(String key) {
        if (TestObject.getTestInfo().languageMap.isEmpty()) {
            String localFile = CrossPlatformProperties.getLocalizationFile();
            LocalizationHelper.localizationLoadJson(localFile);
        }
        String local = TestObject.getTestInfo().languageMap.get(key);
        return local;
    }

    protected static void localizationLoadJson(String fileName) {
        String filePath = PropertiesReader.getLocalResourcePath() + fileName;
        TestObject.getTestInfo().languageMap = LocalizationHelper.jsonFileToMap(filePath);
        TestObject.getTestInfo().config.put(CrossPlatformProperties.LOCALIZATION_FILE, fileName);
    }

    protected static Map<String, String> jsonStringToMap(String jsonString) {
        Type type = new TypeToken<Map<String, String>>(){}.getType();
        Gson gson = new Gson();
        return (Map)gson.fromJson(jsonString, type);
    }

    protected static Map<String, String> jsonFileToMap(String filePath) {
        JSONObject json = null;
        try {
            BufferedReader buff = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "UTF-8"));
            String line = null;
            StringBuilder sb = new StringBuilder();
            while ((line = buff.readLine()) != null) {
                sb.append(line);
            }
            json = new JSONObject(sb.toString());
            buff.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (Map)new Gson().fromJson(json.toString(), HashMap.class);
    }

    protected static void loadCsvFileContent() {
        if (TestObject.getTestInfo().languageMap.isEmpty()) {
            String localFile = CrossPlatformProperties.getLocalizationFile();
            String language = TestObject.getTestInfo().language;
            File csvFile = LocalizationHelper.getCsvFile(localFile);
            try {
                CSVParser parser = CSVParser.parse((File)csvFile, (Charset)StandardCharsets.ISO_8859_1, (CSVFormat)CSVFormat.EXCEL.withFirstRecordAsHeader());
                String translation = "";
                for (CSVRecord csvRecord : parser) {
                    String key = csvRecord.get(DEFAULT_LOCAL);
                    translation = csvRecord.get(language);
                    TestObject.getTestInfo().languageMap.put(key, translation);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected static List<String> getColumnHeaders(CSVParser parser) {
        ArrayList<String> columns = new ArrayList<String>();
        Map header = parser.getHeaderMap();
        for (Map.Entry entry : header.entrySet()) {
            columns.add((String)entry.getKey());
        }
        return columns;
    }

    protected static File getCsvFile(String filename) {
        String filePath = PropertiesReader.getLocalResourcePath() + filename;
        File csvFile = new File(filePath);
        if (csvFile.isFile() && csvFile.toString().endsWith(".csv")) {
            return csvFile;
        }
        Helper.assertTrue("csv file not found at: " + filename, false);
        return null;
    }
}

