/*
 * Decompiled with CFR 0.152.
 */
package core.helpers;

import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.WeekFields;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class DateHelper {
    public String getTimestampMiliseconds() {
        return this.getTime("yyyyMMddHHmmssSSSSS");
    }

    public String getTimeInstance() {
        return Instant.now().toString();
    }

    public String getTimestampSeconds() {
        return this.getTime("yyyy-MM-dd HH:mm:ss");
    }

    public String getTimeISOInstant() {
        return ZonedDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ISO_INSTANT);
    }

    public String getTime(String format, String zone) {
        Instant time = Instant.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format).withZone(ZoneId.of(zone));
        return formatter.format(time);
    }

    public String getTime(String format) {
        Instant time = Instant.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format).withZone(ZoneId.of("UTC"));
        return formatter.format(time);
    }

    public String getTime(Instant time, String format) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format).withZone(ZoneId.of("UTC"));
        return formatter.format(time);
    }

    public String getTime(String timeString, String format, String zone) {
        Instant timeInstant = Instant.parse(timeString);
        DateTimeFormatter formatter = null;
        if (StringUtils.isBlank((String)format) && StringUtils.isBlank((String)zone)) {
            return timeInstant.toString();
        }
        if (!StringUtils.isBlank((String)format) && StringUtils.isBlank((String)zone)) {
            return this.getTime(timeInstant, format);
        }
        if (StringUtils.isBlank((String)format) && !StringUtils.isBlank((String)zone)) {
            LocalDateTime timelocal = LocalDateTime.ofInstant(timeInstant, ZoneId.of(zone));
            ZoneId systemZone = ZoneId.of(zone);
            ZoneOffset offset = systemZone.getRules().getOffset(timeInstant);
            String dateString = timelocal.toInstant(offset).toString();
            return dateString;
        }
        formatter = DateTimeFormatter.ofPattern(format).withZone(ZoneId.of(zone));
        return formatter.format(timeInstant);
    }

    public int getDayOfWeekIndex(String day) {
        DateTimeFormatter dayOfWeekFormatter = DateTimeFormatter.ofPattern("EEEE", Locale.ENGLISH);
        Locale loc = Locale.US;
        WeekFields wf = WeekFields.of(loc);
        DayOfWeek dayOfWeek = DayOfWeek.from(dayOfWeekFormatter.parse(day));
        int dayNumber = dayOfWeek.get(wf.dayOfWeek());
        return dayNumber;
    }

    public int getDayOfWeekIndex(LocalDateTime time) {
        Locale loc = Locale.US;
        WeekFields wf = WeekFields.of(loc);
        DayOfWeek dayOfWeek = time.getDayOfWeek();
        int day = dayOfWeek.get(wf.dayOfWeek());
        return day;
    }

    public int getMonthOfYearIndex(String month) {
        int monthNum = Month.valueOf(month.toUpperCase()).getValue();
        return monthNum;
    }

    public int getMonthOfYearIndex(LocalDateTime time) {
        return time.getMonth().getValue();
    }
}

