/*
 * Decompiled with CFR 0.152.
 */
package core.apiCore.interfaces;

import com.microsoft.azure.servicebus.ExceptionPhase;
import com.microsoft.azure.servicebus.IMessage;
import com.microsoft.azure.servicebus.IMessageHandler;
import com.microsoft.azure.servicebus.Message;
import com.microsoft.azure.servicebus.MessageHandlerOptions;
import com.microsoft.azure.servicebus.QueueClient;
import com.microsoft.azure.servicebus.ReceiveMode;
import com.microsoft.azure.servicebus.SubscriptionClient;
import com.microsoft.azure.servicebus.TopicClient;
import com.microsoft.azure.servicebus.primitives.ConnectionStringBuilder;
import com.microsoft.azure.servicebus.primitives.ServiceBusException;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import core.apiCore.helpers.DataHelper;
import core.apiCore.helpers.MessageQueueHelper;
import core.support.configReader.Config;
import core.support.logger.TestLog;
import core.support.objects.KeyValue;
import core.support.objects.MessageObject;
import core.support.objects.ServiceObject;
import core.support.objects.TestObject;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class ServiceBusInterface {
    public static final String SERVICEBUS_CONNECTION_STR = "servicebus.connectionString";
    public static final String SERVICEBUS_QUEUE = "servicebus.queue";
    public static final String SERVICEBUS_OUTBOUND_QUEUE = "servicebus.outbound.queue";
    public static final String SERVICEBUS_TOPIC = "servicebus.topic";
    public static final String SERVICEBUS_OUTBOUND_TOPIC = "servicebus.outbound.topic";
    public static final String SERVICEBUS_HOST = "servicebus.host";
    public static final String SERVICEBUS_MESSAGE_ID_PREFIX = "servicebus.msgId.prefix";
    public static Connection connection = null;
    public static Channel channel;

    public static void testServicebusInterface(ServiceObject serviceObject) throws Exception {
        ServiceBusInterface.evaluateOption(serviceObject);
        serviceObject.withRequestBody(DataHelper.getRequestBodyIncludingTemplate(serviceObject));
        String messageId = MessageQueueHelper.generateMessageId(serviceObject, Config.getValue(SERVICEBUS_MESSAGE_ID_PREFIX));
        ServiceBusInterface.sendServiceBusMessage(serviceObject, messageId);
        MessageQueueHelper.receiveAndValidateMessages(serviceObject, messageId, MessageObject.messageType.SERVICEBUS);
    }

    public static void sendServiceBusMessage(ServiceObject serviceObject, String messageId) throws InterruptedException, ServiceBusException {
        TestLog.ConsoleLog("rabbitMq request body: " + serviceObject.getRequestBody(), new Object[0]);
        String connectionString = Config.getValue(SERVICEBUS_CONNECTION_STR);
        String topic = Config.getValue(SERVICEBUS_TOPIC);
        String queue = Config.getValue(SERVICEBUS_QUEUE);
        QueueClient sendQueueClient = new QueueClient(new ConnectionStringBuilder(connectionString, queue), ReceiveMode.PEEKLOCK);
        TopicClient sendClient = new TopicClient(new ConnectionStringBuilder(connectionString, topic));
        if (!queue.isEmpty()) {
            ServiceBusInterface.sendMessagesAsync(serviceObject, messageId, sendClient).thenRunAsync(() -> sendQueueClient.closeAsync());
        } else if (!topic.isEmpty()) {
            ServiceBusInterface.sendMessagesAsync(serviceObject, messageId, sendClient).thenRunAsync(() -> sendClient.closeAsync());
        }
    }

    static CompletableFuture<Void> sendQeueMessagesAsync(ServiceObject serviceObject, String messageId, QueueClient sendClient) {
        ArrayList<CompletionStage> tasks = new ArrayList<CompletionStage>();
        Message message = new Message(serviceObject.getRequestBody().getBytes());
        message.setContentType(serviceObject.getContentType());
        message.setLabel(messageId);
        message.setMessageId(messageId);
        message.setTimeToLive(Duration.ofMinutes(2L));
        TestLog.logPass("Message sending: Id = " + message.getMessageId() + "\n message: " + message, new Object[0]);
        tasks.add(sendClient.sendAsync((IMessage)message).thenRunAsync(() -> System.out.printf("Message acknowledged: Id = " + message.getMessageId(), new Object[0])));
        return CompletableFuture.allOf(tasks.toArray(new CompletableFuture[tasks.size()]));
    }

    static CompletableFuture<Void> sendMessagesAsync(ServiceObject serviceObject, String messageId, TopicClient sendClient) {
        ArrayList<CompletionStage> tasks = new ArrayList<CompletionStage>();
        Message message = new Message(serviceObject.getRequestBody().getBytes());
        message.setContentType(serviceObject.getContentType());
        message.setLabel(messageId);
        message.setMessageId(messageId);
        message.setTimeToLive(Duration.ofMinutes(2L));
        TestLog.logPass("Message sending: Id = " + message.getMessageId() + "\n message: " + message, new Object[0]);
        tasks.add(sendClient.sendAsync((IMessage)message).thenRunAsync(() -> System.out.printf("\n\tMessage acknowledged: Id = %s", message.getMessageId())));
        return CompletableFuture.allOf(tasks.toArray(new CompletableFuture[tasks.size()]));
    }

    public static void evaluateOption(ServiceObject serviceObject) {
        ServiceBusInterface.resetOptions();
        if (serviceObject.getOption().isEmpty()) {
            return;
        }
        DataHelper.saveDataToConfig(serviceObject.getOption());
        serviceObject.withOption(DataHelper.replaceParameters(serviceObject.getOption()));
        List<KeyValue> keywords = DataHelper.getValidationMap(serviceObject.getOption());
        for (KeyValue keyword : keywords) {
            switch (keyword.key.toLowerCase()) {
                case "topic": {
                    Config.putValue(SERVICEBUS_TOPIC, keyword.value);
                    break;
                }
                case "outbound_topic": {
                    Config.putValue(SERVICEBUS_OUTBOUND_TOPIC, keyword.value);
                    break;
                }
                case "host": {
                    Config.putValue(SERVICEBUS_HOST, keyword.value);
                    break;
                }
                case "queue": {
                    Config.putValue(SERVICEBUS_QUEUE, keyword.value);
                    break;
                }
                case "response_identifier": {
                    Config.putValue("response.identifier", keyword.value);
                }
            }
        }
    }

    private static void resetOptions() {
        String defaultTopic = TestObject.getDefaultTestInfo().config.get(SERVICEBUS_TOPIC).toString();
        String outboundTopic = TestObject.getDefaultTestInfo().config.get(SERVICEBUS_OUTBOUND_TOPIC).toString();
        String defaultQueue = TestObject.getDefaultTestInfo().config.get(SERVICEBUS_QUEUE).toString();
        String defaultHost = TestObject.getDefaultTestInfo().config.get(SERVICEBUS_HOST).toString();
        Config.putValue(SERVICEBUS_TOPIC, defaultTopic);
        Config.putValue(SERVICEBUS_OUTBOUND_TOPIC, outboundTopic);
        Config.putValue(SERVICEBUS_QUEUE, defaultQueue);
        Config.putValue(SERVICEBUS_HOST, defaultHost);
        Config.putValue("response.identifier", "");
    }

    public static void closeConnection() {
        try {
            channel.close();
            connection.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void getOutboundMessages() throws Exception {
        String connectionString = Config.getValue(SERVICEBUS_CONNECTION_STR);
        String topic = Config.getValue(SERVICEBUS_TOPIC);
        String outboundTopic = Config.getValue(SERVICEBUS_OUTBOUND_TOPIC);
        String host = Config.getValue(SERVICEBUS_HOST);
        if (!outboundTopic.isEmpty()) {
            topic = outboundTopic;
        }
        String entityPath = topic + "/subscriptions/" + host;
        SubscriptionClient subscription1Client = new SubscriptionClient(new ConnectionStringBuilder(connectionString, entityPath), ReceiveMode.PEEKLOCK);
        ServiceBusInterface.registerMessageHandlerOnClient(subscription1Client);
    }

    static void registerMessageHandlerOnClient(final SubscriptionClient receiveClient) throws Exception {
        IMessageHandler messageHandler = new IMessageHandler(){

            public CompletableFuture<Void> onMessageAsync(IMessage message) {
                MessageObject messageObject = new MessageObject().withMessageType(MessageObject.messageType.SERVICEBUS).withMessageId(message.getMessageId()).withCorrelationId(message.getCorrelationId()).withMessage(message.getMessageBody().getValueData().toString()).withLabel(message.getLabel());
                TestLog.logPass("Received messageId '" + message.getMessageId() + "\n with message content: " + message.getMessageBody().getValueData(), new Object[0]);
                MessageObject.outboundMessages.put(messageObject, true);
                return receiveClient.completeAsync(message.getLockToken());
            }

            public void notifyException(Throwable throwable, ExceptionPhase exceptionPhase) {
                System.out.printf(exceptionPhase + "-" + throwable.getMessage(), new Object[0]);
            }
        };
        receiveClient.registerMessageHandler(messageHandler, new MessageHandlerOptions(1, false, Duration.ofMinutes(1L)));
    }
}

