/*
 * Decompiled with CFR 0.152.
 */
package core.apiCore.interfaces;

import com.thoughtworks.paranamer.AnnotationParanamer;
import com.thoughtworks.paranamer.BytecodeReadingParanamer;
import com.thoughtworks.paranamer.CachingParanamer;
import com.thoughtworks.paranamer.Paranamer;
import core.apiCore.helpers.DataHelper;
import core.apiCore.helpers.JsonHelper;
import core.helpers.Helper;
import core.support.logger.TestLog;
import core.support.objects.KeyValue;
import core.support.objects.ServiceObject;
import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ExternalInterface {
    private static final String METHOD = "method";

    public static void ExternalInterfaceRunner(ServiceObject serviceObject) throws Exception {
        ExternalInterface.evaluateTestMethod(serviceObject);
    }

    public static void evaluateTestMethod(ServiceObject serviceObject) throws Exception {
        if (serviceObject.getMethod().isEmpty()) {
            return;
        }
        serviceObject.withRequestBody(DataHelper.getRequestBodyIncludingTemplate(serviceObject));
        List<KeyValue> parameterList = DataHelper.getValidationMap(serviceObject.getRequestBody());
        List<KeyValue> keywords = DataHelper.getValidationMap(serviceObject.getMethod());
        for (KeyValue keyword : keywords) {
            switch (keyword.key.toLowerCase()) {
                case "method": {
                    ExternalInterface.runExernalMethod(keyword.value.toString(), parameterList);
                    break;
                }
            }
        }
    }

    public static void runExernalMethod(String classmethod, List<KeyValue> parameterList) throws Exception {
        GroovyClassLoader groovyClassLoader = new GroovyClassLoader();
        Object[] parameters = ExternalInterface.getParameterValues(parameterList);
        Object[] parameterNames = ExternalInterface.getParameterNames(parameterList);
        String[] methodInfo = classmethod.split("\\.");
        if (methodInfo.length < 2) {
            Helper.assertFalse("wrong method format. must be class.method");
        }
        String className = methodInfo[0];
        String methodName = methodInfo[1];
        TestLog.logPass("invoking method: " + methodName + " at class: " + className, new Object[0]);
        File sourceFile = ExternalInterface.getExternalMethodFilePath(className);
        Class externalClass = groovyClassLoader.parseClass(sourceFile);
        Object external = externalClass.newInstance();
        Class<?>[] paramTypes = ExternalInterface.getMethodParameterTypes(externalClass, methodName, parameterNames);
        Method method = externalClass.getMethod(methodName, paramTypes);
        if (parameterNames.length != paramTypes.length) {
            Helper.assertFalse("number of parameters must match method parameters");
        }
        parameters = ExternalInterface.convertObjectToMethodType(paramTypes, parameters);
        method.invoke(external, parameters);
        groovyClassLoader.close();
    }

    public static Object[] convertObjectToMethodType(Class<?>[] paramTypes, Object[] parameterValues) {
        Object[] paramArr = new Object[parameterValues.length];
        for (int i = 0; i < parameterValues.length; ++i) {
            Object parameter;
            paramArr[i] = parameter = JsonHelper.convertToObject(parameterValues[i].toString(), false);
        }
        return paramArr;
    }

    public static boolean isParameterNamesMatch(String[] parameterNames, Object[] parameterList) {
        String parameterNamesString = Arrays.toString(parameterNames);
        String parameterListString = Arrays.toString(parameterList);
        return parameterNamesString.equals(parameterListString);
    }

    public static Class<?>[] getMethodParameterTypes(Class<?> external, String methodName, Object[] parameterList) {
        CachingParanamer info = new CachingParanamer((Paranamer)new AnnotationParanamer((Paranamer)new BytecodeReadingParanamer()));
        ArrayList<String> methodList = new ArrayList<String>();
        for (Method m : external.getMethods()) {
            if (!m.getName().equals(methodName)) continue;
            Object[] parameterNames = info.lookupParameterNames((AccessibleObject)m);
            methodList.add("method: " + m.getName() + "(" + Arrays.toString(parameterNames) + ")");
            boolean isParameterMatch = ExternalInterface.isParameterNamesMatch((String[])parameterNames, parameterList);
            if (m.getParameterCount() != parameterList.length || !isParameterMatch) continue;
            Class<?>[] params = m.getParameterTypes();
            return params;
        }
        if (!methodList.isEmpty()) {
            TestLog.logPass("method: " + methodName + "(" + Arrays.toString(parameterList) + ") not found. methods found: " + Arrays.toString(methodList.toArray()), new Object[0]);
        }
        return null;
    }

    public static File getExternalMethodFilePath(String classmethod) {
        String path = "module" + File.separator + "services" + File.separator + METHOD;
        File folder = new File(Helper.getRootDir() + "src" + File.separator + "main");
        List<File> listOfFiles = new ArrayList<File>();
        listOfFiles = ExternalInterface.getAllFiles(folder, listOfFiles);
        for (File file : listOfFiles) {
            if (!file.getAbsolutePath().contains(path + File.separator + classmethod)) continue;
            return file;
        }
        Helper.assertFalse("directory for external test method not found: " + path);
        return null;
    }

    private static List<File> getAllFiles(File pathToDir, List<File> listOfFiles) {
        if (pathToDir.isDirectory()) {
            String[] subdirs = pathToDir.list();
            for (int i = 0; i < subdirs.length; ++i) {
                ExternalInterface.getAllFiles(new File(pathToDir, subdirs[i]), listOfFiles);
            }
        } else {
            listOfFiles.add(pathToDir);
        }
        return listOfFiles;
    }

    private static Object[] getParameterValues(List<KeyValue> paramters) {
        ArrayList<Object> parameterList = new ArrayList<Object>();
        for (KeyValue parameter : paramters) {
            parameterList.add(parameter.value);
        }
        String[] paramArr = new String[parameterList.size()];
        return parameterList.toArray(paramArr);
    }

    private static Object[] getParameterNames(List<KeyValue> paramters) {
        ArrayList<String> parameterList = new ArrayList<String>();
        for (KeyValue parameter : paramters) {
            parameterList.add(parameter.key);
        }
        String[] paramArr = new String[parameterList.size()];
        return parameterList.toArray(paramArr);
    }
}

