/*
 * Decompiled with CFR 0.152.
 */
package core.apiCore.helpers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import core.apiCore.helpers.DataHelper;
import core.helpers.Helper;
import core.support.configReader.Config;
import core.support.logger.TestLog;
import core.support.objects.KeyValue;
import core.support.objects.ServiceObject;
import io.restassured.response.Response;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONArray;
import org.apache.commons.lang.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XML;
import org.skyscreamer.jsonassert.JSONCompare;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.skyscreamer.jsonassert.JSONCompareResult;

public class JsonHelper {
    public static String failOnEscapeChars = "api.validation.fail.on.escapechars";

    public static void saveOutboundJsonParameters(Response response, String outputParam) {
        if (response == null || outputParam.isEmpty()) {
            return;
        }
        JsonHelper.configMapJsonKeyValues(response, outputParam);
    }

    public static void configMapJsonKeyValues(Response response, String keyValue) {
        if (keyValue.isEmpty()) {
            return;
        }
        keyValue = DataHelper.replaceParameters(keyValue);
        List<KeyValue> keywords = DataHelper.getValidationMap(keyValue);
        for (KeyValue keyword : keywords) {
            if (!(keyword.value.toString().startsWith("<") && keyword.value.toString().contains("$") && keyword.value.toString().endsWith(">"))) {
                Helper.assertFalse("variable placement must of format path: <$variable>. invalid value: " + keyword.value.toString());
            }
            String key = (String)keyword.value;
            key = key.replace("$", "").replace("<", "").replace(">", "").trim();
            String value = JsonHelper.getJsonValue(response, keyword.key);
            if (!keyword.position.isEmpty()) {
                value = value.split(",")[Integer.valueOf(keyword.position) - 1];
            }
            Config.putValue(key, value);
        }
    }

    public static String getJsonValue(Response response, String path) {
        String jsonResponse = response.getBody().asString();
        String value = JsonHelper.getJsonValue(jsonResponse, path);
        return value;
    }

    public static String getJsonValue(String json, String path) {
        return JsonHelper.getJsonValue(json, path, true);
    }

    public static String getJsonValue(String json, String path, boolean isAlwaysReturnList) {
        Object values = JsonHelper.getJsonPathValue(json, path, isAlwaysReturnList);
        if (JsonHelper.isValidJsonkeyValue(values)) {
            return values.toString();
        }
        return DataHelper.objectToString(values);
    }

    public static Object getJsonPathValue(String json, String path, boolean isAlwaysReturnList) {
        String prefix = "$.";
        Object values = null;
        JsonHelper.isJSONValid(json, true);
        if (Config.getBooleanValue(failOnEscapeChars).booleanValue() && JsonHelper.containsEscapeChar(json)) {
            Helper.assertFalse("invalid escape character in json. invalid chars are: \\\", \\b, \\n, \\r, \\f, \\', \\\\: " + json);
        }
        if (path.startsWith(prefix)) {
            path = path.replace(prefix, "");
        }
        Configuration config = null;
        config = isAlwaysReturnList ? Configuration.defaultConfiguration().addOptions(new Option[]{Option.ALWAYS_RETURN_LIST}) : Configuration.defaultConfiguration();
        DocumentContext ctx = JsonPath.using((Configuration)config).parse(json);
        try {
            values = ctx.read(prefix + path, new Predicate[0]);
        }
        catch (Exception e) {
            if (e.getMessage().contains(Option.ALWAYS_RETURN_LIST.name()) && isAlwaysReturnList) {
                values = JsonHelper.getJsonValue(json, path, false);
            }
            Helper.assertFalse("invalid path: '" + path + "' for json string: " + json + "\n. see http://jsonpath.herokuapp.com to validate your path against json string. see https://github.com/json-path/JsonPath for more info. \n" + e.getMessage());
        }
        if (values == null) {
            Helper.assertFalse("no results returned: '" + path + "'. see http://jsonpath.herokuapp.com to validate your path against json string. see https://github.com/json-path/JsonPath for more info.");
        }
        return values;
    }

    public static boolean isJsonPathValueString(String json, String path) {
        JSONArray array;
        String prefix = "$.";
        Object jsonResponse = null;
        Object value = "";
        if (path.startsWith(prefix)) {
            path = path.replace(prefix, "");
        }
        Configuration config = Configuration.defaultConfiguration().addOptions(new Option[]{Option.ALWAYS_RETURN_LIST});
        DocumentContext ctx = JsonPath.using((Configuration)config).parse(json);
        try {
            jsonResponse = ctx.read(prefix + path, new Predicate[0]);
        }
        catch (Exception e) {
            e.getCause();
        }
        if (jsonResponse instanceof List && !(array = (JSONArray)jsonResponse).isEmpty()) {
            value = array.get(0);
        }
        return value instanceof String;
    }

    public static boolean containsEscapeChar(String value) {
        String[] escapeChars;
        for (String escape : escapeChars = new String[]{"\\\"", "\\b", "\\n", "\\r", "\\f", "\\'", "\\\\"}) {
            if (!value.contains(escape)) continue;
            return true;
        }
        return false;
    }

    public static String getJsonValueFromXml(String xml, String path) {
        String json = JsonHelper.XMLToJson(xml);
        return JsonHelper.getJsonValue(json, path);
    }

    public static String XMLToJson(String xml) {
        int printIndentFactor = 4;
        String jsonString = "";
        try {
            JSONObject xmlJSONObj = XML.toJSONObject((String)xml);
            jsonString = xmlJSONObj.toString(printIndentFactor);
        }
        catch (JSONException je) {
            je.toString();
        }
        return jsonString;
    }

    public static String getResponseValue(Response response) {
        return response.getBody().asString();
    }

    public static List<String> validateJsonKeywords(List<KeyValue> keywords, String responseString) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        for (KeyValue keyword : keywords) {
            String jsonPath = Helper.removeSurroundingQuotes(keyword.key);
            String expectedValue = Helper.stringRemoveLines((String)keyword.value);
            String command = "";
            String[] expected = expectedValue.split("[\\(\\)]");
            if (expected.length > 1) {
                command = expected[0];
                expectedValue = expected[1];
            } else if (expected.length == 1) {
                command = expectedValue;
                expectedValue = "";
            }
            TestLog.ConsoleLog("command: " + command + "json path: " + jsonPath, new Object[0]);
            String jsonResponse = JsonHelper.getJsonValue(responseString, jsonPath);
            String errorMessage = DataHelper.validateCommand(command, jsonResponse, expectedValue, keyword.position);
            errorMessages.add(errorMessage);
        }
        errorMessages.removeAll(Collections.singleton(""));
        return errorMessages;
    }

    public static boolean isJSONValid(String value, boolean isFailOnError) {
        String error = "";
        String expectedJson = Helper.stringNormalize(value);
        if (expectedJson.startsWith("_VERIFY.JSON.PART_") || expectedJson.startsWith("_VERIFY_JSON_PART_") || expectedJson.startsWith("_NOT_EMPTY_") || expectedJson.startsWith("_VERIFY_RESPONSE_BODY_")) {
            return false;
        }
        try {
            new JSONObject(value);
        }
        catch (JSONException ex) {
            try {
                error = ex.getMessage();
                new org.json.JSONArray(value);
            }
            catch (JSONException ex1) {
                if (error.isEmpty()) {
                    error = ex1.getMessage();
                }
                if (isFailOnError) {
                    Helper.assertFalse("Invalid Json. Error: " + error + "\n json: " + value);
                }
                return false;
            }
        }
        return true;
    }

    public static String validateByJsonBody(String expectedJson, String response) {
        if (JsonHelper.isJSONValid(expectedJson = Helper.stringRemoveLines(expectedJson), false)) {
            if (StringUtils.isBlank((String)response)) {
                return "response from json path is empty";
            }
            TestLog.logPass("expecting partial json: " + Helper.stringRemoveLines(expectedJson), new Object[0]);
            try {
                JSONCompareResult result = JSONCompare.compareJSON((String)expectedJson, (String)response, (JSONCompareMode)JSONCompareMode.LENIENT);
                if (result.failed()) {
                    return result.getMessage() + "\nsee http://jsonpath.herokuapp.com to validate your path against json string. see https://github.com/json-path/JsonPath for more info. \n\n expectedJson: " + expectedJson + "\n\n response: " + response + "\n\n";
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
                return e.getMessage() + "\nsee http://jsonpath.herokuapp.com to validate your path against json string. see https://github.com/json-path/JsonPath for more info. \n\n expectedJson: " + expectedJson + "\n\n response: " + response + "\n\n";
            }
        }
        return "";
    }

    public static List<String> validateByKeywords(String expectedJson, Response response) {
        String responseString = JsonHelper.getResponseValue(response);
        return JsonHelper.validateByKeywords(expectedJson, responseString);
    }

    public static List<String> validateByKeywords(String expectedJson, String responseString) {
        List<String> errorMessages = new ArrayList<String>();
        expectedJson = Helper.stringRemoveLines(expectedJson);
        if (!JsonHelper.isJSONValid(expectedJson = Helper.removeSurroundingQuotes(expectedJson), false)) {
            if (expectedJson.startsWith("_VERIFY.JSON.PART_") || expectedJson.startsWith("_VERIFY_JSON_PART_")) {
                List<KeyValue> keywords = DataHelper.getValidationMap(expectedJson);
                errorMessages = JsonHelper.validateJsonKeywords(keywords, responseString);
            } else if (expectedJson.startsWith("_NOT_EMPTY_") && responseString.isEmpty()) {
                errorMessages.add("response is empty");
            }
        }
        return errorMessages;
    }

    public static String validateResponseBody(String expected, Response response) {
        String responseString = JsonHelper.getResponseValue(response);
        return JsonHelper.validateResponseBody(expected, responseString);
    }

    public static String validateResponseBody(String expected, String responseString) {
        expected = Helper.stringRemoveLines(expected);
        if (!((expected = Helper.removeSurroundingQuotes(expected)).startsWith("_VERIFY_RESPONSE_BODY_") || expected.startsWith("_VERIFY_HEADER_PART_") || expected.startsWith("_VERIFY_TOPIC_PART_"))) {
            return "";
        }
        expected = JsonHelper.removeResponseIndicator(expected);
        String[] expectedArr = expected.split("[\\(\\)]");
        String expectedValue = "";
        String command = "";
        if (expectedArr.length == 1) {
            command = expected.trim();
        } else {
            command = expectedArr[0].trim();
            expectedValue = expectedArr[1].trim();
        }
        return DataHelper.validateCommand(command, responseString, expectedValue, "0");
    }

    public static String removeResponseIndicator(String expected) {
        ArrayList<String> indicator = new ArrayList<String>();
        indicator.add("_VERIFY_RESPONSE_BODY_");
        indicator.add("_VERIFY.JSON.PART_");
        indicator.add("_VERIFY_JSON_PART_");
        indicator.add("_VERIFY_HEADER_PART_");
        indicator.add("_VERIFY_TOPIC_PART_");
        for (String value : indicator) {
            expected = expected.replace(value, "");
        }
        return expected;
    }

    public static String getRequestBodyFromJsonTemplate(ServiceObject serviceObject) {
        if (!JsonHelper.isJsonFile(serviceObject.getTemplateFile())) {
            return "";
        }
        Path templatePath = DataHelper.getTemplateFilePath(serviceObject.getTemplateFile());
        String jsonFileValue = DataHelper.convertFileToString(templatePath);
        jsonFileValue = DataHelper.replaceParameters(jsonFileValue);
        if (serviceObject.getRequestBody().isEmpty()) {
            return jsonFileValue;
        }
        return JsonHelper.updateJsonFromRequestBody(serviceObject);
    }

    public static boolean isJsonFile(String filename) {
        return filename.toLowerCase().endsWith("json");
    }

    public static String convertJsonFileToString(Path templatePath) {
        return Helper.readFileContent(templatePath.toString());
    }

    public static String updateJsonFromRequestBody(ServiceObject serviceObject) {
        String jsonString = DataHelper.getServiceObjectTemplateString(serviceObject);
        Helper.assertTrue("json string is empty", !jsonString.isEmpty());
        jsonString = DataHelper.replaceParameters(jsonString);
        if (JsonHelper.isJSONValid(serviceObject.getRequestBody(), false)) {
            return serviceObject.getRequestBody();
        }
        List<KeyValue> keywords = DataHelper.getValidationMap(serviceObject.getRequestBody());
        for (KeyValue keyword : keywords) {
            jsonString = JsonHelper.replaceJsonPathValue(jsonString, keyword.key, keyword.value.toString());
        }
        return jsonString;
    }

    public static String replaceJsonPathValue(String jsonString, String path, String value) {
        DocumentContext doc = JsonPath.parse((String)jsonString);
        String prefix = "$.";
        boolean isJsonPathValueString = JsonHelper.isJsonPathValueString(jsonString, path);
        Object replacementValue = JsonHelper.convertToObject(value, isJsonPathValueString);
        if (path.startsWith(prefix)) {
            path = path.replace(prefix, "");
        }
        try {
            doc.set("$." + path, replacementValue, new Predicate[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonObject jsonObj = new GsonBuilder().serializeNulls().create().toJsonTree(doc.json()).getAsJsonObject();
        return jsonObj.toString();
    }

    public static Object convertToObject(String value, boolean isPathValueString) {
        Object objectvalue = null;
        if (isPathValueString) {
            objectvalue = value;
        } else {
            ObjectMapper ob = new ObjectMapper();
            ob.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
            try {
                objectvalue = ob.readValue(value, Object.class);
            }
            catch (IOException e) {
                objectvalue = value;
            }
        }
        if (objectvalue != null && objectvalue.equals("null")) {
            objectvalue = null;
        }
        return objectvalue;
    }

    public static org.json.JSONArray getJsonArray(String jsonString) {
        try {
            return new org.json.JSONArray(jsonString);
        }
        catch (JSONException ex) {
            ex.getMessage();
            return null;
        }
    }

    public static JSONObject getJsonObject(String jsonString) {
        try {
            return new JSONObject(jsonString);
        }
        catch (JSONException ex) {
            ex.getMessage();
            return null;
        }
    }

    public static boolean isValidJsonkeyValue(Object jsonObject) {
        String jsonString;
        if (jsonObject instanceof Map) {
            jsonObject = new Gson().toJson(jsonObject, Map.class);
        }
        if (JsonHelper.getJsonArray(jsonString = jsonObject.toString()) == null && JsonHelper.getJsonObject(jsonString) == null) {
            return false;
        }
        String jsonNormalized = DataHelper.objectToString(jsonString);
        return jsonNormalized.contains(":");
    }

    public static List<String> arrayRemoveAllEmptyString(List<String> list) {
        list.removeAll(Collections.singleton(""));
        return list;
    }
}

