/*
 * Decompiled with CFR 0.152.
 */
package core.apiCore.helpers;

import com.opencsv.CSVReader;
import core.apiCore.helpers.CsvReader;
import core.apiCore.helpers.JsonHelper;
import core.apiCore.helpers.XmlHelper;
import core.helpers.Helper;
import core.support.configReader.Config;
import core.support.configReader.PropertiesReader;
import core.support.logger.TestLog;
import core.support.objects.KeyValue;
import core.support.objects.ServiceObject;
import core.support.objects.TestObject;
import java.io.File;
import java.nio.file.Path;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;

public class DataHelper {
    public static final String VERIFY_JSON_PART_INDICATOR = "_VERIFY.JSON.PART_";
    public static final String VERIFY_JSON_PART_INDICATOR_UNDERSCORE = "_VERIFY_JSON_PART_";
    public static final String VERIFY_RESPONSE_BODY_INDICATOR = "_VERIFY_RESPONSE_BODY_";
    public static final String VERIFY_RESPONSE_NO_EMPTY = "_NOT_EMPTY_";
    public static final String VERIFY_HEADER_PART_INDICATOR = "_VERIFY_HEADER_PART_";
    public static final String VERIFY_TOPIC_PART_INDICATOR = "_VERIFY_TOPIC_PART_";
    public static final String EXPECTED_MESSAGE_COUNT = "EXPECTED_MESSAGE_COUNT";
    public static final String TEST_DATA_TEMPLATE_DATA_PATH = "api.templateDataFile";

    public static String replaceParameters(String source) {
        if (source.isEmpty()) {
            return source;
        }
        List<String> parameters = Helper.getValuesFromPattern(source, "<@(.+?)>");
        Object value = null;
        int length = 0;
        String newTime = "";
        for (String parameter : parameters) {
            if (parameter.contains("_TIME_MS_")) {
                newTime = DataHelper.getTime(parameter, Config.getValue("_startTimeString_"));
                Instant time = Instant.parse(newTime);
                value = DataHelper.getTimeSubstring(parameter, String.valueOf(time.toEpochMilli()));
            } else if (parameter.contains("_TIME_STRING_")) {
                newTime = DataHelper.getTime(parameter, Config.getValue("_startTimeString_"));
                value = DataHelper.getTimeSubstring(parameter, Helper.date.getTime(newTime, "yyyyMMddHHmmssSSS", null));
            } else if (parameter.contains("_TIME_ISO_")) {
                newTime = DataHelper.getTime(parameter, Config.getValue("_startTimeString_"));
                value = DataHelper.getTimeSubstring(parameter, newTime);
            } else if (parameter.contains("_TIME")) {
                newTime = DataHelper.getTime(parameter, Config.getValue("_startTimeString_"));
                value = DataHelper.getTimeSubstring(parameter, newTime);
            } else if (parameter.contains("_RAND")) {
                length = Helper.getIntFromString(parameter);
                value = Config.getValue("_randomString_").substring(0, length);
            } else if (parameter.contains("_INCREMENT_FROM_")) {
                value = DataHelper.getIncrementalValue(parameter);
            } else if (parameter.contains("_XML")) {
                String[] valueArray = parameter.split(":");
                int index = 0;
                String tag = valueArray[1];
                if (valueArray.length == 3) {
                    index = Integer.valueOf(parameter.split(":")[2]);
                }
                value = XmlHelper.getXmlTagValue(source, tag, index + 1);
            } else {
                value = Config.getObjectValue(parameter.replace("@", ""));
            }
            if (value == null) {
                TestLog.logWarning("parameter value not found: " + parameter, new Object[0]);
                continue;
            }
            TestLog.ConsoleLog("replacing value " + parameter + "  with: " + value, new Object[0]);
            source = source.replace("<@" + parameter + ">", Matcher.quoteReplacement(value.toString()));
        }
        return source;
    }

    public static int getIncrementalValue(String parameter) {
        int startingValue = Helper.getIntFromString(parameter);
        int testCurrentRunCount = 1;
        String testId = TestObject.getTestInfo().serviceObject.getTestCaseID();
        if (testId.matches(".*_run_(\\d)?$")) {
            testId = testId.substring(testId.lastIndexOf("_run_") + 1);
            testCurrentRunCount = Helper.getIntFromString(testId);
        }
        int incrementalValue = startingValue + testCurrentRunCount - 1;
        return incrementalValue;
    }

    public static String getTimeSubstring(String parameter, String finalTime) {
        Matcher matcher = Pattern.compile("\\d+").matcher(parameter);
        matcher.find();
        int length = Integer.valueOf(matcher.group());
        int maxLength = finalTime.length();
        if (length > maxLength || length == -1) {
            length = maxLength;
        }
        return finalTime.substring(0, length);
    }

    public static String getTime(String parameter, String timeString) {
        String[] values;
        for (String value : values = parameter.split(";")) {
            String setDay;
            if (value.contains("FORMAT")) {
                String format = value.split("FORMAT")[1];
                format = DataHelper.removeFirstAndLastChars(format, ":", "<", ">");
                timeString = Helper.date.getTime(timeString, format, null);
                continue;
            }
            if (value.contains("ZONE")) {
                String zone = value.split("ZONE")[1];
                zone = DataHelper.removeFirstAndLastChars(zone, ":", "<", ">");
                timeString = Helper.date.getTime(timeString, null, zone);
                continue;
            }
            if (value.contains("setTime")) {
                String setTime = value.split("setTime")[1];
                setTime = DataHelper.removeFirstAndLastChars(setTime, ":", "<", ">");
                timeString = DataHelper.setTime(setTime, timeString);
                continue;
            }
            if (value.contains("setDay")) {
                setDay = value.split("setDay")[1];
                setDay = DataHelper.removeFirstAndLastChars(setDay, ":", "<", ">");
                timeString = DataHelper.setDay(setDay, timeString);
                continue;
            }
            if (value.contains("setMonth")) {
                setDay = value.split("setMonth")[1];
                setDay = DataHelper.removeFirstAndLastChars(setDay, ":", "<", ">");
                timeString = DataHelper.setMonth(setDay, timeString);
                continue;
            }
            value = DataHelper.removeFirstAndLastChars(value, ":", "<", ">");
            timeString = DataHelper.getTimeWithModification(value, timeString);
        }
        return timeString;
    }

    public static String setTime(String parameter, String timeString) {
        Instant time = Instant.parse(timeString);
        String[] parameters = parameter.split(":");
        if (parameters.length != 3) {
            Helper.assertFalse("format must be hh:mm:ss. value: " + parameter);
        }
        int hour = Helper.getIntFromString(parameters[0]);
        int minute = Helper.getIntFromString(parameters[1]);
        int second = Helper.getIntFromString(parameters[2]);
        time = time.atZone(ZoneOffset.UTC).withHour(hour).withMinute(minute).withSecond(second).withNano(0).toInstant();
        return time.toString();
    }

    public static String setDay(String dayName, String timeString) {
        Instant timeinstance = Instant.parse(timeString);
        LocalDateTime time = LocalDateTime.ofInstant(timeinstance, ZoneOffset.UTC);
        int currentDay = Helper.date.getDayOfWeekIndex(time);
        int targetDay = Helper.date.getDayOfWeekIndex(dayName);
        int timeDifference = targetDay - currentDay;
        time = time.plusDays(timeDifference);
        return time.toString();
    }

    public static String setMonth(String monthName, String timeString) {
        Instant timeinstance = Instant.parse(timeString);
        LocalDateTime time = LocalDateTime.ofInstant(timeinstance, ZoneOffset.UTC);
        int currentMonth = Helper.date.getMonthOfYearIndex(time);
        int targetMonth = Helper.date.getMonthOfYearIndex(monthName);
        int timeDifference = targetMonth - currentMonth;
        time = time.plusMonths(timeDifference);
        return time.toString();
    }

    public static String removeFirstAndLastChars(String value, String ... toRemove) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return value;
        }
        if (toRemove.length == 0) {
            return value;
        }
        for (String remove : toRemove) {
            if (value.startsWith(remove)) {
                value = StringUtils.removeStart((String)value, (String)remove);
            }
            if (!value.endsWith(remove)) continue;
            value = StringUtils.removeEnd((String)value, (String)remove);
        }
        return value;
    }

    public static String getTimeWithModification(String parameter, String timeString) {
        Instant time = Instant.parse(timeString);
        LocalDateTime localTime = LocalDateTime.ofInstant(time, ZoneOffset.UTC);
        Instant newTime = time;
        String[] parameterArray = parameter.split("[+-]");
        if (parameterArray.length == 1) {
            return newTime.toString();
        }
        String modifier = parameter.split("[+-]")[1];
        String modiferSign = parameter.replaceAll("[^+-]", "");
        int modifierDuration = Helper.getIntFromString(modifier);
        String modifierUnit = modifier.replaceAll("[^A-Za-z]+", "");
        if (modiferSign.isEmpty() || modifierDuration == -1 || modifierUnit.isEmpty()) {
            Helper.assertFalse("invalid time modifier. format: eg. _TIME_STRING_17+72h or _TIME_STRING_17-72m");
        }
        switch (modifierUnit) {
            case "y": {
                if (modiferSign.equals("+")) {
                    localTime = localTime.plusYears(modifierDuration);
                    break;
                }
                if (!modiferSign.equals("-")) break;
                localTime = localTime.minusYears(modifierDuration);
                break;
            }
            case "mo": {
                if (modiferSign.equals("+")) {
                    localTime = localTime.plusMonths(modifierDuration);
                    break;
                }
                if (!modiferSign.equals("-")) break;
                localTime = localTime.minusMonths(modifierDuration);
                break;
            }
            case "w": {
                if (modiferSign.equals("+")) {
                    localTime = localTime.plusWeeks(modifierDuration);
                    break;
                }
                if (!modiferSign.equals("-")) break;
                localTime = localTime.minusWeeks(modifierDuration);
                break;
            }
            case "d": {
                if (modiferSign.equals("+")) {
                    localTime = localTime.plusDays(modifierDuration);
                    break;
                }
                if (!modiferSign.equals("-")) break;
                localTime = localTime.minusDays(modifierDuration);
                break;
            }
            case "h": {
                if (modiferSign.equals("+")) {
                    localTime = localTime.plusHours(modifierDuration);
                    break;
                }
                if (!modiferSign.equals("-")) break;
                localTime = localTime.minusHours(modifierDuration);
                break;
            }
            case "m": {
                if (modiferSign.equals("+")) {
                    localTime = localTime.plusMinutes(modifierDuration);
                    break;
                }
                if (!modiferSign.equals("-")) break;
                localTime = localTime.minusMinutes(modifierDuration);
                break;
            }
            default: {
                Helper.assertFalse("invalid time modifier. format: eg. +2d or +72h or -72m or +1mo or +2y");
            }
        }
        String dateString = localTime.toInstant(ZoneOffset.UTC).toString();
        return dateString;
    }

    public static List<KeyValue> getValidationMap(String expected) {
        ArrayList<KeyValue> keywords = new ArrayList<KeyValue>();
        expected = JsonHelper.removeResponseIndicator(expected);
        String[] keyVals = expected.split(";");
        String key = "";
        String position = "";
        String value = "";
        for (String keyVal : keyVals) {
            if (keyVal.isEmpty()) continue;
            List<String> parts = DataHelper.splitToKeyPositionValue(keyVal, ":", 3);
            if (parts.size() == 1) {
                key = Helper.stringRemoveLines(parts.get(0));
            }
            if (parts.size() == 2) {
                key = Helper.stringRemoveLines(parts.get(0));
                position = "";
                value = Helper.stringRemoveLines(parts.get(1));
            } else if (parts.size() == 3) {
                key = Helper.stringRemoveLines(parts.get(0));
                position = Helper.stringRemoveLines(parts.get(1));
                value = Helper.stringRemoveLines(parts.get(2));
            }
            if (key.isEmpty()) continue;
            KeyValue keyword = new KeyValue(key, position, value);
            keywords.add(keyword);
        }
        return keywords;
    }

    public static String getTemplateFileLocation(String file) {
        String templatePath = Config.getValue("api.templatePath").trim();
        String templateTestPath = PropertiesReader.getLocalRootPath() + templatePath;
        return templateTestPath + file;
    }

    public static Path getTemplateFilePath(String file) {
        String templatePath = Config.getValue("api.templatePath").trim();
        String templateTestPath = PropertiesReader.getLocalRootPath() + templatePath;
        String fullLocation = templateTestPath + file;
        return new File(fullLocation).toPath();
    }

    public static File getFile(String filename) {
        String templatePath = Config.getValue("api.templatePath").trim();
        String templateTestPath = PropertiesReader.getLocalRootPath() + templatePath;
        File file = new File(templateTestPath + filename);
        return file;
    }

    public static String getServiceObjectTemplateString(ServiceObject serviceObject) {
        Path templatePath = DataHelper.getTemplateFilePath(serviceObject.getTemplateFile());
        return DataHelper.convertFileToString(templatePath);
    }

    public static String validateCommand(String command, String responseString, String expectedString) {
        String error = DataHelper.validateExpectedCommand(command, responseString, expectedString, "");
        if (error.isEmpty()) {
            TestLog.ConsoleLog("validation passed for command: " + responseString + " " + command + " " + expectedString, new Object[0]);
        } else {
            TestLog.ConsoleLog("validation failed for command: " + command + " with error: " + error, new Object[0]);
        }
        return error;
    }

    public static String validateCommand(String command, String responseString, String expectedString, String position) {
        String error = DataHelper.validateExpectedCommand(command, responseString, expectedString, position);
        if (error.isEmpty()) {
            TestLog.ConsoleLog("validation passed for command: response " + command + " " + expectedString, new Object[0]);
        } else {
            TestLog.ConsoleLog("validation failed for command: " + command + " with error: " + error, new Object[0]);
        }
        return error;
    }

    public static String validateExpectedCommand(String command, String responseString, String expectedString, String position) {
        expectedString = Helper.removeSurroundingQuotes(expectedString);
        command = Helper.removeSurroundingQuotes(command);
        responseString = Helper.removeSurroundingQuotes(responseString);
        List<String> expectedArray = DataHelper.getResponseArray(expectedString);
        List<String> actualArray = DataHelper.getResponseArray(responseString);
        String actualString = "";
        int positionInt = 0;
        if (actualArray.size() == 1) {
            position = "1";
        }
        if (!position.isEmpty() && Helper.getIntFromString(position) > 0) {
            boolean inBounds;
            positionInt = Helper.getIntFromString(position);
            expectedString = expectedArray.get(0);
            boolean bl = inBounds = positionInt > 0 && positionInt <= actualArray.size();
            if (!inBounds) {
                Helper.assertFalse("items returned are less than specified. returned: " + actualArray.size() + " specified: " + positionInt);
            }
            actualString = actualArray.get(positionInt - 1);
        }
        if (DataHelper.getCommandFromExpectedString(command).isEmpty()) {
            Helper.assertFalse("Command not set. Options: " + Arrays.asList(JSON_COMMAND.values()) + ". See examples for usage.");
        }
        JSON_COMMAND jsonCommand = JSON_COMMAND.valueOf(command);
        switch (jsonCommand) {
            case hasItems: {
                boolean val = false;
                if (!position.isEmpty() && positionInt > 0) {
                    TestLog.logPass("verifying: " + actualString + " has item " + expectedString, new Object[0]);
                    val = actualString.contains(expectedString);
                    if (val) break;
                    return actualString + " does not have item " + expectedString;
                }
                if (!position.isEmpty() && positionInt == 0) {
                    TestLog.logPass("verifying: " + responseString + " has item " + expectedString, new Object[0]);
                    val = responseString.contains(expectedString);
                    if (val) break;
                    return responseString + " does not have item " + expectedString;
                }
                TestLog.logPass("verifying: " + Arrays.toString(actualArray.toArray()) + " has items " + Arrays.toString(expectedArray.toArray()), new Object[0]);
                val = actualArray.containsAll(expectedArray);
                if (val) break;
                return Arrays.toString(actualArray.toArray()) + " does not have items " + Arrays.toString(expectedArray.toArray());
            }
            case notHaveItems: {
                boolean val = false;
                if (!position.isEmpty() && positionInt > 0) {
                    TestLog.logPass("verifying: " + actualString + " does not have item " + expectedString, new Object[0]);
                    boolean bl = val = !actualString.contains(expectedString);
                    if (val) break;
                    return actualString + " does have item " + expectedString;
                }
                if (!position.isEmpty() && positionInt == 0) {
                    TestLog.logPass("verifying: " + responseString + " does not have item " + expectedString, new Object[0]);
                    boolean bl = val = !responseString.contains(expectedString);
                    if (val) break;
                    return responseString + " does not have item " + expectedString;
                }
                TestLog.logPass("verifying: " + Arrays.toString(actualArray.toArray()) + " does not have items " + Arrays.toString(expectedArray.toArray()), new Object[0]);
                boolean bl = val = !actualArray.containsAll(expectedArray);
                if (val) break;
                return Arrays.toString(actualArray.toArray()) + " does have items " + Arrays.toString(expectedArray.toArray());
            }
            case notEqualTo: {
                boolean val;
                if (!position.isEmpty() && positionInt > 0) {
                    boolean val2;
                    TestLog.logPass("verifying: " + actualString + " not equals " + expectedString, new Object[0]);
                    boolean bl = val2 = !actualString.equals(expectedString);
                    if (val2) break;
                    return actualString + " does equal " + expectedString;
                }
                if (!position.isEmpty() && positionInt == 0) {
                    boolean val3;
                    TestLog.logPass("verifying: " + responseString + " not equals " + expectedString, new Object[0]);
                    boolean bl = val3 = !responseString.equals(expectedString);
                    if (val3) break;
                    return responseString + " does equal " + expectedString;
                }
                TestLog.logPass("verifying: " + Arrays.toString(actualArray.toArray()) + " not equals " + Arrays.toString(expectedArray.toArray()), new Object[0]);
                boolean bl = val = !actualArray.equals(expectedArray);
                if (val) break;
                return Arrays.toString(actualArray.toArray()) + " does equal " + Arrays.toString(expectedArray.toArray());
            }
            case equalTo: {
                if (!position.isEmpty() && positionInt > 0) {
                    TestLog.logPass("verifying: " + actualString + " equals " + expectedString, new Object[0]);
                    boolean val = actualString.equals(expectedString);
                    if (val) break;
                    return actualString + " does not equal " + expectedString;
                }
                if (!position.isEmpty() && positionInt == 0) {
                    TestLog.logPass("verifying: " + responseString + " equals " + expectedString, new Object[0]);
                    boolean val = responseString.equals(expectedString);
                    if (val) break;
                    return responseString + " does not equal " + expectedString;
                }
                TestLog.logPass("verifying: " + Arrays.toString(actualArray.toArray()) + " equals " + Arrays.toString(expectedArray.toArray()), new Object[0]);
                boolean val = actualArray.equals(expectedArray);
                if (val) break;
                return Arrays.toString(actualArray.toArray()) + " does not equal " + Arrays.toString(expectedArray.toArray());
            }
            case notContain: {
                boolean val;
                if (!position.isEmpty() && positionInt > 0) {
                    boolean val4;
                    TestLog.logPass("verifying: " + actualString + " does not contain " + expectedString, new Object[0]);
                    boolean bl = val4 = !actualString.contains(expectedString);
                    if (val4) break;
                    return actualString + " does contain " + expectedString;
                }
                if (!position.isEmpty() && positionInt == 0) {
                    boolean val5;
                    TestLog.logPass("verifying: " + expectedString + " does not contain " + expectedString, new Object[0]);
                    boolean bl = val5 = !responseString.contains(expectedString);
                    if (val5) break;
                    return responseString + " does contain " + expectedString;
                }
                TestLog.logPass("verifying: " + Arrays.toString(actualArray.toArray()) + " does not contain " + Arrays.toString(expectedArray.toArray()), new Object[0]);
                boolean bl = val = !actualArray.containsAll(expectedArray);
                if (val) break;
                return Arrays.toString(actualArray.toArray()) + " does not contain " + Arrays.toString(expectedArray.toArray());
            }
            case contains: {
                if (!position.isEmpty() && positionInt > 0) {
                    TestLog.logPass("verifying: " + actualString + " contains " + expectedString, new Object[0]);
                    boolean val = actualString.contains(expectedString);
                    if (val) break;
                    return actualString + " does not contain " + expectedString;
                }
                if (!position.isEmpty() && positionInt == 0) {
                    TestLog.logPass("verifying: '" + responseString + "' contains " + expectedString, new Object[0]);
                    boolean val = responseString.contains(expectedString);
                    if (val) break;
                    return responseString + " does not contain " + expectedString;
                }
                TestLog.logPass("verifying: " + Arrays.toString(actualArray.toArray()) + " contains " + Arrays.toString(expectedArray.toArray()), new Object[0]);
                boolean val = actualArray.containsAll(expectedArray);
                if (val) break;
                return Arrays.toString(actualArray.toArray()) + " does not contain " + Arrays.toString(expectedArray.toArray());
            }
            case containsInAnyOrder: {
                TestLog.logPass("verifying: " + Arrays.toString(actualArray.toArray()) + " contains any order " + Arrays.toString(expectedArray.toArray()), new Object[0]);
                boolean val = actualArray.containsAll(expectedArray);
                if (val) break;
                return Arrays.toString(actualArray.toArray()) + " does not contain in any order " + Arrays.toString(expectedArray.toArray());
            }
            case integerGreaterThan: {
                TestLog.logPass("verifying: " + responseString + " is greater than " + expectedString, new Object[0]);
                boolean val = DataHelper.compareNumbers(responseString, expectedString, "greaterThan");
                if (val) break;
                return "actual: " + responseString + " is less than expected: " + expectedString;
            }
            case integerLessThan: {
                TestLog.logPass("verifying: " + responseString + " is less than " + expectedString, new Object[0]);
                boolean val = DataHelper.compareNumbers(responseString, expectedString, "lessThan");
                if (val) break;
                return "actual: " + responseString + " is greater than expected: " + expectedString;
            }
            case integerEqual: {
                TestLog.logPass("verifying: " + responseString + " is equal to " + expectedString, new Object[0]);
                boolean val = DataHelper.compareNumbers(responseString, expectedString, "equalTo");
                if (val) break;
                return "actual: " + responseString + " is not equal to expected: " + expectedString;
            }
            case integerNotEqual: {
                boolean val;
                boolean bl = val = !DataHelper.compareNumbers(responseString, expectedString, "equalTo");
                if (val) break;
                return "actual: " + responseString + " is not equal to expected: " + expectedString;
            }
            case nodeSizeGreaterThan: {
                int intValue = Integer.valueOf(expectedString);
                int actualLength = DataHelper.getResponseArrayLength(actualArray, responseString);
                TestLog.logPass("verifying node with size " + actualLength + " greater than " + intValue, new Object[0]);
                if (actualLength > intValue) break;
                return "response node size is: " + actualLength + " expected it to be greater than: " + intValue;
            }
            case nodeSizeLessThan: {
                int intValue = Integer.valueOf(expectedString);
                int actualLength = DataHelper.getResponseArrayLength(actualArray, responseString);
                TestLog.logPass("verifying node with size " + actualLength + " less than " + intValue, new Object[0]);
                if (actualLength < intValue) break;
                return "response node size is: " + actualLength + " expected it to be less than: " + intValue;
            }
            case nodeSizeExact: {
                int intValue = Integer.valueOf(expectedString);
                int actualLength = DataHelper.getResponseArrayLength(actualArray, responseString);
                TestLog.logPass("verifying node with size " + actualLength + " equals " + intValue, new Object[0]);
                if (actualLength == intValue) break;
                return "response node size is: " + actualLength + " expected: " + intValue;
            }
            case sequence: {
                TestLog.logPass("verifying: " + Arrays.toString(actualArray.toArray()) + " with sequence " + Arrays.toString(expectedArray.toArray()), new Object[0]);
                boolean val = Arrays.asList(actualArray).equals(Arrays.asList(expectedArray));
                if (val) break;
                return Arrays.toString(actualArray.toArray()) + " does not equal " + Arrays.toString(expectedArray.toArray());
            }
            case jsonbody: {
                TestLog.logPass("verifying response: \n" + ServiceObject.normalize(responseString) + "\n against expected: \n" + expectedString, new Object[0]);
                String error = JsonHelper.validateByJsonBody(expectedString, responseString);
                if (error.isEmpty()) break;
                return error;
            }
            case isNotEmpty: {
                TestLog.logPass("verifying response for path is not empty", new Object[0]);
                if (!DataHelper.isEmpty(responseString)) break;
                return "value is empty";
            }
            case isEmpty: {
                TestLog.logPass("verifying response for path is empty ", new Object[0]);
                if (DataHelper.isEmpty(responseString)) break;
                return "value is not empty";
            }
            default: {
                Helper.assertFalse("Command not set. Options: " + Arrays.asList(JSON_COMMAND.values()) + ". See examples for usage.");
            }
        }
        return "";
    }

    public static List<String> getResponseArray(String array) {
        String[] responses;
        ArrayList<String> list = new ArrayList<String>();
        for (String response : responses = array.split(",")) {
            response = response.trim().replace("\"", "");
            response = response.replace("[", "").replace("]", "");
            list.add(response);
        }
        return list;
    }

    public static int getResponseArrayLength(List<String> actualArray, String responseString) {
        int responseLength = -1;
        actualArray = DataHelper.removeEmptyElements(actualArray);
        JSONArray jsonArray = JsonHelper.getJsonArray(responseString);
        responseLength = jsonArray != null ? jsonArray.length() : actualArray.size();
        return responseLength;
    }

    public static boolean isGreaterThan(String value1, String value2) {
        return Helper.isNumeric(value1) && Helper.isNumeric(value2) && Integer.valueOf(value1) > Integer.valueOf(value2);
    }

    public static boolean isLessThan(String value1, String value2) {
        return Helper.isNumeric(value1) && Helper.isNumeric(value2) && Integer.valueOf(value1) < Integer.valueOf(value2);
    }

    public static boolean compareNumbers(String value1, String value2, String comparator) {
        if (!Helper.isStringContainNumber(value1) || !Helper.isStringContainNumber(value2)) {
            return false;
        }
        double val1Double = Helper.getDoubleFromString(value1);
        double val2Double = Helper.getDoubleFromString(value2);
        return DataHelper.compareNumbers(val1Double, val2Double, comparator);
    }

    public static boolean compareNumbers(double value1, double value2, String comparator) {
        switch (comparator) {
            case "greaterThan": {
                if (!(value1 > value2)) break;
                return true;
            }
            case "lessThan": {
                if (!(value1 < value2)) break;
                return true;
            }
            case "equalTo": {
                if (value1 != value2) break;
                return true;
            }
        }
        return false;
    }

    public static String listToString(List<String> values) {
        return StringUtils.join(values, (String)",");
    }

    public static String objectToString(Object values) {
        String stringVal = values.toString();
        stringVal = stringVal.replaceAll("[\\[\\](){}]", "");
        stringVal = stringVal.replace("\"", "");
        stringVal = stringVal.replace("\\/", "/");
        return stringVal;
    }

    public static List<String> splitToKeyPositionValue(String keyvalue, String regex, int limit) {
        ArrayList<String> result = new ArrayList<String>();
        if (!keyvalue.contains(":")) {
            result.add(keyvalue);
            return result;
        }
        String commandValue = DataHelper.getCommandFromExpectedString(keyvalue);
        if (!commandValue.isEmpty()) {
            return DataHelper.getJsonKeyValue(keyvalue, commandValue);
        }
        String position = "";
        boolean hasPosition = Pattern.compile(":\\d{1}:").matcher(keyvalue).find();
        if (hasPosition) {
            String[] resultArray = keyvalue.split(":\\d{1}:");
            Pattern pattern = Pattern.compile(":\\d{1}:");
            Matcher matcher = pattern.matcher(keyvalue);
            if (matcher.find()) {
                position = matcher.group(0);
            }
            result.add(resultArray[0]);
            result.add(DataHelper.removeFirstAndLastChars(position, ":"));
            result.add(resultArray[1]);
        } else {
            String[] resultArray = keyvalue.split(":", 2);
            result.add(resultArray[0]);
            result.add(resultArray[1]);
        }
        return result;
    }

    public static List<String> splitRight(String value, String regex, int limit) {
        String string = value;
        ArrayList<String> result = new ArrayList<String>();
        String[] temp = new String[]{};
        for (int i = 1; i < limit; ++i) {
            if (!string.matches(".*" + regex + ".*")) continue;
            temp = string.split(DataHelper.modifyRegex(regex));
            Helper.assertTrue("value not set for: " + string, temp.length > 1);
            result.add(temp[1]);
            string = temp[0];
        }
        if (temp.length > 0) {
            result.add(temp[0]);
        }
        if (value.split(":").length == 1) {
            result.add(string);
        }
        Collections.reverse(result);
        return result;
    }

    private static String getCommandFromExpectedString(String value) {
        String commandValue = "";
        for (JSON_COMMAND command : JSON_COMMAND.values()) {
            List<String> parameters = Helper.getValuesFromPattern(value, (Object)((Object)command) + "\\(([^)]+)\\)");
            if (!parameters.isEmpty()) {
                commandValue = (Object)((Object)command) + "(" + parameters.get(0) + ")";
                if (!value.endsWith(commandValue)) continue;
                return commandValue;
            }
            if (!value.endsWith(command.name())) continue;
            return command.name();
        }
        return "";
    }

    private static List<String> getJsonKeyValue(String value, String commandValue) {
        ArrayList<String> result = new ArrayList<String>();
        String keyPosition = (value = value.replace(commandValue, "")).trim().replaceAll(":$", "");
        List<String> keyPositionList = DataHelper.splitRight(keyPosition, ":", 2);
        if (keyPositionList.size() == 2 && Helper.isStringContainOnlyNumber(keyPositionList.get(1))) {
            result.add(keyPositionList.get(0));
            result.add(keyPositionList.get(1));
        } else {
            result.add(keyPosition);
        }
        result.add(commandValue);
        return result;
    }

    private static String modifyRegex(String regex) {
        return regex + "(?!.*" + regex + ".*$)";
    }

    public static boolean isEmpty(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return true;
        }
        return value.equals("null");
    }

    public static String getRequestBodyIncludingTemplate(ServiceObject serviceObject) {
        String requestbody = "";
        DataHelper.loadDataFile(serviceObject);
        if (JsonHelper.isJsonFile(serviceObject.getTemplateFile())) {
            requestbody = JsonHelper.getRequestBodyFromJsonTemplate(serviceObject);
        } else if (XmlHelper.isXmlFile(serviceObject.getTemplateFile())) {
            requestbody = XmlHelper.getRequestBodyFromXmlTemplate(serviceObject);
        } else if (!serviceObject.getTemplateFile().isEmpty()) {
            Path templatePath = DataHelper.getTemplateFilePath(serviceObject.getTemplateFile());
            requestbody = DataHelper.convertFileToString(templatePath);
        } else if (requestbody.isEmpty()) {
            requestbody = serviceObject.getRequestBody();
        }
        requestbody = DataHelper.replaceParameters(requestbody);
        return requestbody;
    }

    public static void loadDataFile(ServiceObject serviceObject) {
        if (serviceObject.getRequestBody().isEmpty()) {
            return;
        }
        String DataFile = "DataFile";
        List<KeyValue> keywords = DataHelper.getValidationMap(serviceObject.getRequestBody());
        for (KeyValue keyword : keywords) {
            switch (keyword.key) {
                case "DataFile": {
                    String updateRequest = serviceObject.getRequestBody().replace(keyword.value.toString(), "").replace(keyword.value.toString() + ";", "").replace("DataFile:", "");
                    String[] dataInfo = keyword.value.toString().split(":");
                    if (dataInfo.length != 2) {
                        Helper.assertFalse("format must be file:dataId. actual value: " + keyword.value.toString());
                    }
                    String dataFilename = dataInfo[0];
                    String expectedDataId = dataInfo[1];
                    String templateDataFilePath = PropertiesReader.getLocalRootPath() + Config.getValue(TEST_DATA_TEMPLATE_DATA_PATH);
                    File dataFile = new File(templateDataFilePath + dataFilename + ".csv");
                    try {
                        String[] line;
                        CSVReader reader = CsvReader.readCsvFile(dataFile);
                        String[] header = reader.readNext();
                        int dataId = CsvReader.getColumnIndexByName("dataId", header);
                        if (header.length > 1 && !updateRequest.isEmpty()) {
                            updateRequest = updateRequest + ";";
                        }
                        while ((line = reader.readNext()) != null) {
                            if (!expectedDataId.equals(line[dataId])) continue;
                            for (int i = 1; i < header.length; ++i) {
                                updateRequest = updateRequest + header[i] + ":" + line[i] + ";";
                            }
                        }
                        reader.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    serviceObject.withRequestBody(updateRequest);
                    break;
                }
            }
        }
    }

    public static void saveDataToConfig(String source) {
        if (source.isEmpty()) {
            return;
        }
        List<KeyValue> keywords = DataHelper.getValidationMap(source);
        for (KeyValue keyword : keywords) {
            if (!(keyword.value.toString().startsWith("<") && keyword.value.toString().contains("$") && keyword.value.toString().endsWith(">"))) {
                return;
            }
            String value = (String)keyword.value;
            value = value.replace("$", "").replace("<", "").replace(">", "").trim();
            String key = keyword.key;
            Config.putValue(value, key);
        }
    }

    public static String convertFileToString(Path templatePath) {
        String content = Helper.readFileContent(templatePath.toString());
        return DataHelper.replaceParameters(content);
    }

    public static String removeSectionFromExpectedResponse(String section, String expectedResponse) {
        String[] criteria = expectedResponse.split("&&");
        ArrayList<String> newResponse = new ArrayList<String>();
        for (String criterion : criteria) {
            if ((criterion = Helper.removeSurroundingQuotes(criterion)).trim().startsWith(section)) continue;
            newResponse.add(criterion);
        }
        return String.join((CharSequence)"&&", newResponse);
    }

    public static String getSectionFromExpectedResponse(String section, String expectedResponse) {
        String[] criteria = expectedResponse.split("&&");
        ArrayList<String> newResponse = new ArrayList<String>();
        for (String criterion : criteria) {
            if (!(criterion = Helper.removeSurroundingQuotes(criterion)).trim().startsWith(section)) continue;
            newResponse.add(criterion);
        }
        return String.join((CharSequence)"&&", newResponse);
    }

    public static List<String> validateExpectedValues(List<String> responseValues, String expectedResponse) {
        List<String> errorMessages = new ArrayList<String>();
        if (expectedResponse.trim().isEmpty()) {
            return errorMessages;
        }
        errorMessages = DataHelper.validateEmptyResponse(responseValues, expectedResponse);
        if (!errorMessages.isEmpty()) {
            return errorMessages;
        }
        expectedResponse = DataHelper.replaceParameters(expectedResponse);
        String[] criteria = expectedResponse.split("&&");
        DataHelper.logJsonResponse(responseValues);
        for (String criterion : criteria) {
            Helper.assertTrue("expected response is not a valid json, xml or keyword:  " + criterion, DataHelper.isValidExpectation(criterion));
            if (XmlHelper.isValidXmlString(criterion)) {
                TestLog.ConsoleLog("expected xml: " + ServiceObject.normalize(criterion), new Object[0]);
                criterion = JsonHelper.XMLToJson(criterion);
                TestLog.ConsoleLog("expected value converted to json for validation: " + ServiceObject.normalize(criterion), new Object[0]);
            }
            errorMessages.addAll(DataHelper.validateExpectedResponse(criterion, responseValues));
        }
        errorMessages = DataHelper.removeEmptyElements(errorMessages);
        return errorMessages;
    }

    public static void logJsonResponse(List<String> responseValues) {
        ArrayList<String> updatedList = new ArrayList<String>();
        for (String response : responseValues) {
            updatedList.add(response.replace(System.lineSeparator(), ""));
        }
        String responseString = String.join((CharSequence)System.lineSeparator(), updatedList);
        TestLog.logPass("response to be validated: " + ServiceObject.normalize(responseString), new Object[0]);
    }

    public static List<String> validateEmptyResponse(List<String> responseValues, String expected) {
        ArrayList<String> errorMessage = new ArrayList<String>();
        boolean isEmptyExpected = DataHelper.isEmptyResponseExpected(expected);
        for (String resonse : responseValues) {
            if (!resonse.isEmpty() || isEmptyExpected) continue;
            errorMessage.add("response value is empty");
            return errorMessage;
        }
        return errorMessage;
    }

    public static boolean isEmptyResponseExpected(String expected) {
        return (expected = JsonHelper.removeResponseIndicator(expected)).equals(JSON_COMMAND.isEmpty.name());
    }

    public static List<String> validateExpectedResponse(String criterion, List<String> responseString) {
        List<String> errorMessages = new ArrayList<String>();
        for (int i = 0; i < responseString.size(); ++i) {
            errorMessages = new ArrayList();
            if (XmlHelper.isValidXmlString(responseString.get(i))) {
                responseString.set(i, JsonHelper.XMLToJson(responseString.get(i)));
            }
            errorMessages.add(JsonHelper.validateByJsonBody(criterion, responseString.get(i)));
            errorMessages.addAll(JsonHelper.validateByKeywords(criterion, responseString.get(i)));
            errorMessages.add(JsonHelper.validateResponseBody(criterion, responseString.get(i)));
            errorMessages = DataHelper.removeEmptyElements(errorMessages);
            if (errorMessages.isEmpty()) break;
            if (i <= 0 || i != responseString.size() || errorMessages.isEmpty()) continue;
            errorMessages = new ArrayList();
            errorMessages.add("expected requirement: " + criterion + " not met by the responses: " + String.join((CharSequence)System.lineSeparator(), responseString));
        }
        return errorMessages;
    }

    public static boolean isValidExpectation(String expectedValue) {
        if (JsonHelper.isJSONValid(expectedValue, false)) {
            return true;
        }
        if (XmlHelper.isValidXmlString(expectedValue)) {
            return true;
        }
        return (expectedValue = Helper.stringNormalize(expectedValue)).startsWith(VERIFY_JSON_PART_INDICATOR) || expectedValue.startsWith(VERIFY_JSON_PART_INDICATOR_UNDERSCORE) || expectedValue.startsWith(VERIFY_RESPONSE_NO_EMPTY) || expectedValue.startsWith(VERIFY_RESPONSE_BODY_INDICATOR) || expectedValue.startsWith(VERIFY_HEADER_PART_INDICATOR) || expectedValue.startsWith(EXPECTED_MESSAGE_COUNT) || expectedValue.startsWith(VERIFY_TOPIC_PART_INDICATOR);
    }

    public static List<String> removeEmptyElements(List<String> list) {
        Iterator<String> i = list.iterator();
        while (i.hasNext()) {
            String s = i.next();
            if (s != null && !s.trim().isEmpty()) continue;
            i.remove();
        }
        return list;
    }

    public static String[] removeEmptyElements(String[] array) {
        ArrayList<String> list = new ArrayList<String>();
        for (String text : array) {
            if (text == null || text.trim().isEmpty()) continue;
            list.add(text);
        }
        array = list.toArray(new String[0]);
        return array;
    }

    public static enum JSON_COMMAND {
        hasItems,
        notHaveItems,
        notEqualTo,
        equalTo,
        notContain,
        contains,
        containsInAnyOrder,
        integerGreaterThan,
        integerLessThan,
        integerEqual,
        integerNotEqual,
        nodeSizeGreaterThan,
        nodeSizeExact,
        sequence,
        jsonbody,
        isNotEmpty,
        isEmpty,
        nodeSizeLessThan;

    }
}

