/*
 * Decompiled with CFR 0.152.
 */
package core.support.objects;

import core.helpers.Helper;
import core.support.logger.TestLog;
import core.support.objects.LoginObject;
import core.support.objects.TestObject;
import core.uiCore.driverProperties.browserType;
import core.uiCore.driverProperties.capabilities.AndroidCapability;
import core.uiCore.driverProperties.capabilities.IosCapability;
import core.uiCore.driverProperties.capabilities.WebCapability;
import core.uiCore.driverProperties.capabilities.WinAppCapabilities;
import core.uiCore.driverProperties.driverType;
import core.uiCore.driverProperties.globalProperties.CrossPlatformProperties;
import core.uiCore.drivers.AbstractDriver;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.DesiredCapabilities;

public class DriverObject {
    public List<WebDriver> webdriver;
    public Boolean isAvailable = true;
    public List<String> testIdList;
    public String initialURL = "";
    public String app = "";
    public driverType.DriverType driverType;
    public browserType.BrowserType browserType;
    public String driverVersion;
    public LoginObject login = new LoginObject();
    public DesiredCapabilities capabilities;
    public static Map<WebDriver, DriverObject> driverList = new ConcurrentHashMap<WebDriver, DriverObject>();

    public static synchronized WebDriver getFirstAvailableDriver() {
        for (Map.Entry<WebDriver, DriverObject> entry : driverList.entrySet()) {
            if (!entry.getValue().isAvailable.equals(true)) continue;
            entry.getValue().withIsAvailable(false);
            return entry.getKey();
        }
        return null;
    }

    public static void quitTestDrivers() {
        ArrayList<WebDriver> drivers = new ArrayList<WebDriver>(TestObject.getTestInfo().webDriverList);
        for (WebDriver driver : drivers) {
            DriverObject.quitWebDriver(driver);
        }
        TestObject.getTestInfo().withWebDriverList(new ArrayList<WebDriver>());
    }

    public static void quitWebDriver(WebDriver driver) {
        ArrayList<WebDriver> currentTestDrivers;
        TestLog.ConsoleLog("quitting test: " + TestObject.getTestInfo().testName, new Object[0]);
        if (driver != null && driverList.get(driver) != null) {
            TestObject.getTestInfo().withIsFirstRun(true);
            TestObject.getTestInfo().withIsForcedRestart(true);
            try {
                boolean hasQuit = driver.toString().contains("(null)");
                if (!hasQuit) {
                    driver.quit();
                }
                driverList.remove(driver);
                AbstractDriver.setWebDriver(null);
            }
            catch (Exception e) {
                e.getMessage();
            }
        }
        if ((currentTestDrivers = new ArrayList<WebDriver>(TestObject.getTestInfo().webDriverList)).contains(driver)) {
            TestObject.getTestInfo().webDriverList.remove(driver);
        }
    }

    public static void shutDownDriver(boolean isTestPass) {
        if (isTestPass) {
            if (!CrossPlatformProperties.isSingleSignIn().booleanValue()) {
                DriverObject.quitTestDrivers();
            } else {
                DriverObject.shutdownSingleSignInDrivers();
            }
        } else {
            DriverObject.quitTestDrivers();
        }
    }

    private static void shutdownSingleSignInDrivers() {
        if (!CrossPlatformProperties.isSingleSignIn().booleanValue()) {
            return;
        }
        ArrayList<WebDriver> currentTestDrivers = new ArrayList<WebDriver>(TestObject.getTestInfo().webDriverList);
        WebDriver activeDriver = AbstractDriver.getWebDriver();
        for (WebDriver driver : currentTestDrivers) {
            if (driver.equals(activeDriver)) continue;
            DriverObject.quitWebDriver(driver);
        }
    }

    public static void quitAllDrivers() {
        for (Map.Entry<WebDriver, DriverObject> entry : driverList.entrySet()) {
            try {
                boolean hasQuit = entry.getKey().toString().contains("(null)");
                if (hasQuit) continue;
                DriverObject.quitWebDriver(entry.getKey());
            }
            catch (Exception e) {
                e.getMessage();
            }
        }
        driverList = new ConcurrentHashMap<WebDriver, DriverObject>();
    }

    public static void initializeDriverList(DriverObject driver, String testId) {
        if (AbstractDriver.getWebDriver() != null) {
            driver.withTestId(testId);
            if (driverList.get(AbstractDriver.getWebDriver()) == null) {
                driverList.put(AbstractDriver.getWebDriver(), driver);
            }
        }
    }

    public static void setDriverAvailabiltity(WebDriver driver, boolean isAvailable) {
        driverList.get(driver).withIsAvailable(isAvailable);
    }

    public DriverObject withTestId(String testId) {
        if (AbstractDriver.getWebDriver() == null || driverList.get(AbstractDriver.getWebDriver()) == null) {
            this.testIdList = new ArrayList<String>();
            this.testIdList.add(testId);
        } else {
            DriverObject.getCurrentDriverObject().testIdList.add(testId);
        }
        return this;
    }

    public static String getCurrentTestId() {
        List<String> testIdList = DriverObject.driverList.get((Object)AbstractDriver.getWebDriver()).testIdList;
        return testIdList.get(testIdList.size() - 1);
    }

    public static String getPreviousTestId() {
        List<String> testIdList = DriverObject.driverList.get((Object)AbstractDriver.getWebDriver()).testIdList;
        if (testIdList.size() > 1) {
            return testIdList.get(testIdList.size() - 2);
        }
        return null;
    }

    public DriverObject withApp(String app) {
        this.app = app;
        return this;
    }

    public DriverObject withIsAvailable(Boolean isAvailable) {
        this.isAvailable = isAvailable;
        return this;
    }

    public DriverObject withUrl(String initialURL) {
        this.initialURL = initialURL;
        return this;
    }

    public DriverObject withBrowserType(browserType.BrowserType browserType2) {
        this.browserType = browserType2;
        return this;
    }

    public DriverObject withDriverVersion(String driverVersion) {
        this.driverVersion = driverVersion;
        return this;
    }

    public DriverObject withDriverType(driverType.DriverType driverType2) {
        this.driverType = driverType2;
        return this;
    }

    public DriverObject withCapabilities(DesiredCapabilities capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    public static DriverObject getCurrentDriverObject() {
        if (AbstractDriver.getWebDriver() == null || driverList.get(AbstractDriver.getWebDriver()) == null) {
            Helper.assertFalse("driver object not available");
            return null;
        }
        return driverList.get(AbstractDriver.getWebDriver());
    }

    public DriverObject withChromeLanguage(String locale) {
        ChromeOptions options = new ChromeOptions();
        options.addArguments(new String[]{"--lang=" + locale});
        this.capabilities.setCapability("goog:chromeOptions", (Object)options);
        return this;
    }

    public DriverObject withWebDriver(String App, String URL2) {
        WebCapability capability = new WebCapability().withBrowserCapability();
        return new DriverObject().withApp(App).withDriverType(capability.getWebDriverType()).withBrowserType(capability.getBrowser()).withDriverVersion(capability.getDriverVersion()).withUrl(capability.getUrl(App, URL2)).withCapabilities(capability.getCapability());
    }

    public DriverObject withiOSDriver(String app, String device) {
        IosCapability capability = new IosCapability().withDevice(device).withIosCapability();
        return new DriverObject().withApp(app).withDriverType(driverType.DriverType.IOS_DRIVER).withCapabilities(capability.getCapability());
    }

    public DriverObject withAndroidDriver(String app, String device) {
        AndroidCapability capability = new AndroidCapability().withDevice(device).withAndroidCapability();
        return new DriverObject().withApp(app).withDriverType(driverType.DriverType.ANDROID_DRIVER).withCapabilities(capability.getCapability());
    }

    public DriverObject withWinDriver(String app) {
        WinAppCapabilities capability = new WinAppCapabilities().withWinAppdCapability();
        return new DriverObject().withApp(app).withDriverType(driverType.DriverType.WINAPP_DRIVER).withCapabilities(capability.getCapability());
    }

    public DriverObject withApiDriver(String app) {
        return new DriverObject().withApp(app).withDriverType(driverType.DriverType.API);
    }

    public DriverObject withGenericDriver(String app) {
        return new DriverObject().withApp(app).withDriverType(driverType.DriverType.API);
    }
}

