/*
 * Decompiled with CFR 0.152.
 */
package core.support.annotation.template.service;

import core.apiCore.helpers.CsvReader;
import core.helpers.Helper;
import core.support.annotation.helper.FileCreatorHelper;
import core.support.annotation.helper.Logger;
import core.support.annotation.helper.PackageHelper;
import core.support.configReader.Config;
import core.support.configReader.PropertiesReader;
import core.support.objects.ServiceObject;
import java.io.BufferedWriter;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.tools.JavaFileObject;
import org.apache.commons.lang3.StringUtils;

public class ServiceData {
    public static JavaFileObject CSV_File_Object = null;
    public static String SERVICE_ROOT = "serviceManager";

    public static void writeServiceDataClass() {
        try {
            ServiceData.writeServiceDataClassImplementation();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void writeServiceDataClassImplementation() throws Exception {
        Logger.debug("<<<<start generating service data>>>>>>");
        String testFolderPath = Config.getValue("api.keywordPath");
        String csvTestPath = PropertiesReader.getLocalRootPath() + testFolderPath;
        ArrayList<File> csvFiles = Helper.getFileListByType(csvTestPath, ".csv");
        HashMap<String, ServiceObject> completeServices = new HashMap<String, ServiceObject>();
        for (int i = 0; i < csvFiles.size(); ++i) {
            List<String[]> list = CsvReader.getCsvTestList(csvFiles.get(i));
            completeServices.putAll(CsvReader.mapToApiObject(list));
        }
        Logger.debug("csv keyword file count: " + csvFiles.size());
        Logger.debug("csv data generated class count: " + completeServices.size());
        for (Map.Entry<String, ServiceObject> entry : completeServices.entrySet()) {
            ServiceData.writeServiceData(entry);
        }
        Logger.debug("<<<<scompleted generating service data>>>>>");
    }

    private static void writeServiceData(Map.Entry<String, ServiceObject> serviceEntry) throws Exception {
        String serviceClassName = StringUtils.capitalize((String)serviceEntry.getKey());
        String filePath = PackageHelper.SERVICE_PATH + "." + serviceClassName;
        JavaFileObject fileObject = FileCreatorHelper.createFileAbsolutePath(filePath);
        BufferedWriter bw = new BufferedWriter(fileObject.openWriter());
        List<String> parameters = ServiceData.getParameters(serviceEntry.getValue().getRequestBody());
        Date currentDate = new Date();
        bw.append("/**Auto generated code,don't modify it.\n");
        bw.append("* Author             ---- > Auto Generated.\n");
        bw.append("* Date  And Time     ---- > " + currentDate.toString() + "\n");
        bw.append("*");
        bw.append("**/\n\n\n\n");
        bw.append("package " + SERVICE_ROOT + ";\n");
        bw.newLine();
        bw.newLine();
        if (parameters.size() > 0) {
            bw.append("import core.support.configReader.Config;\n");
        }
        bw.append("import core.support.objects.ServiceObject;\n");
        bw.newLine();
        bw.newLine();
        bw.append("public class " + serviceClassName + " {\n");
        bw.newLine();
        bw.newLine();
        for (String parameter : parameters) {
            bw.append("public " + serviceClassName + " with" + StringUtils.capitalize((String)parameter) + "(String " + parameter + ") {\n");
            bw.append("    Config.putValue(\"" + parameter + "\" , " + parameter + ");\n");
            bw.append("    return this;\n");
            bw.append("}\n");
            bw.newLine();
            bw.newLine();
        }
        bw.append("public void build ()\n");
        bw.append("{\n");
        bw.append("    ServiceObject serviceObject = getServiceObject();\n");
        bw.append("    try {\n");
        bw.append("    \t\tServiceRunner.runInterface(serviceObject);\n");
        bw.append("    \t   } catch (Exception e) {\n");
        bw.append("    \t\te.printStackTrace();\n");
        bw.append("\t   }\n");
        bw.append("}\n");
        bw.newLine();
        bw.newLine();
        bw.append("public ServiceObject getService()\n");
        bw.append("{\n");
        bw.append("    return getServiceObject();\n");
        bw.append("}\n");
        bw.newLine();
        bw.newLine();
        bw.append("public ServiceObject getServiceObject() \n");
        bw.append("{\n");
        bw.append("    ServiceObject serviceObject = new ServiceObject()\n");
        bw.append("    \t\t\t\t.withTestSuite(\"" + ServiceData.formatString(serviceEntry.getValue().getTestSuite()) + "\")\n");
        bw.append("    \t\t\t\t.withTestCaseID(\"" + ServiceData.formatString(serviceEntry.getValue().getTestCaseID()) + "\")\n");
        bw.append("    \t\t\t\t.withRunFlag(\"" + ServiceData.formatString(serviceEntry.getValue().getRunFlag()) + "\")\n");
        bw.append("    \t\t\t\t.withInterfaceType(\"" + ServiceData.formatString(serviceEntry.getValue().getInterfaceType()) + "\")\n");
        bw.append("    \t\t\t\t.withUriPath(\"" + ServiceData.formatString(serviceEntry.getValue().getUriPath()) + "\")\n");
        bw.append("    \t\t\t\t.withContentType(\"" + ServiceData.formatString(serviceEntry.getValue().getContentType()) + "\")\n");
        bw.append("    \t\t\t\t.withMethod(\"" + ServiceData.formatString(serviceEntry.getValue().getMethod()) + "\")\n");
        bw.append("    \t\t\t\t.withOption(\"" + ServiceData.formatString(serviceEntry.getValue().getOption()) + "\")\n");
        bw.append("    \t\t\t\t.withRequestHeaders(\"" + ServiceData.formatString(serviceEntry.getValue().getRequestHeaders()) + "\")\n");
        bw.append("    \t\t\t\t.withTemplateFile(\"" + ServiceData.formatString(serviceEntry.getValue().getTemplateFile()) + "\")\n");
        bw.append("    \t\t\t\t.withRequestBody(\"" + ServiceData.formatString(serviceEntry.getValue().getRequestBody()) + "\")\n");
        bw.append("    \t\t\t\t.withOutputParams(\"" + ServiceData.formatString(serviceEntry.getValue().getOutputParams()) + "\")\n");
        bw.append("    \t\t\t\t.withRespCodeExp(\"" + ServiceData.formatString(serviceEntry.getValue().getRespCodeExp()) + "\")\n");
        bw.append("    \t\t\t\t.withExpectedResponse(\"" + ServiceData.formatString(serviceEntry.getValue().getExpectedResponse()) + "\")\n");
        bw.append("    \t\t\t\t.withTcComments(\"" + ServiceData.formatString(serviceEntry.getValue().getTcComments()) + "\");\n");
        bw.append("\t\treturn serviceObject;\n");
        bw.append("} \n");
        bw.append("}\n");
        bw.flush();
        bw.close();
    }

    private static String formatString(String val) {
        val = Helper.stringRemoveLines(val);
        val = val.replace("\"", "\\\"");
        return val;
    }

    private static List<String> getParameters(String requestBody) {
        List<String> parametersCandidates = Helper.getValuesFromPattern(requestBody, "<(.+?)>");
        ArrayList<String> parameters = new ArrayList<String>();
        for (String parameter : parametersCandidates) {
            String value = parameter.replace("@", "");
            parameters.add(value);
        }
        return parameters;
    }
}

