/*
 * Decompiled with CFR 0.152.
 */
package core.support.annotation.helper.utils;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;

public class dirChangeDetector {
    public static void main(String[] args) {
        String sourceDir = dirChangeDetector.getRootDir() + "src" + File.separator + "main";
        String keywordDir = dirChangeDetector.getRootDir() + "resources" + File.separator + "api" + File.separator + "keywords";
        System.out.println("sourceDir : " + sourceDir);
        System.out.println("keywordDir : " + keywordDir);
        ArrayList<String> sourceList = dirChangeDetector.getFileList(sourceDir);
        ArrayList<String> keywordList = dirChangeDetector.getFileList(keywordDir);
        sourceList.addAll(keywordList);
        String targetFile = dirChangeDetector.getRootDir() + "target" + File.separator + "generated-sources" + File.separator + "src_dir.txt";
        String oldFileList = dirChangeDetector.getFileContent(targetFile);
        ArrayList<String> oldDirList = new ArrayList<String>(Arrays.asList(oldFileList.split(",")));
        boolean hasChanged = dirChangeDetector.hasChangeDetected(oldDirList, sourceList);
        if (hasChanged) {
            String markerPath = dirChangeDetector.getRootDir() + "target" + File.separator + "generated-sources" + File.separator + "annotations" + File.separator + "marker" + File.separator + "marker.java";
            dirChangeDetector.deleteFile(markerPath);
        }
    }

    private static boolean hasChangeDetected(ArrayList<String> oldDirList, ArrayList<String> newDirList) {
        boolean hasChanged;
        String oldDir = String.join((CharSequence)", ", oldDirList);
        String newDir = String.join((CharSequence)", ", newDirList);
        ArrayList<String> differenceList = dirChangeDetector.listDifference(oldDirList, newDirList);
        boolean bl = hasChanged = !oldDir.equals(newDir);
        if (hasChanged) {
            System.out.println("changes in (src, or keyword) directory detected: \n changes: ");
            differenceList.forEach(System.out::println);
        }
        return hasChanged;
    }

    private static ArrayList<String> listDifference(ArrayList<String> oldDirList, ArrayList<String> newDirList) {
        ArrayList<String> newList = new ArrayList<String>(newDirList);
        newDirList.removeAll(oldDirList);
        oldDirList.removeAll(newList);
        newDirList.addAll(oldDirList);
        return newDirList;
    }

    public static ArrayList<String> getFileList(String directory) {
        ArrayList<String> array = new ArrayList<String>();
        File file = new File(directory);
        array = dirChangeDetector.getFileList(file, array);
        return array;
    }

    public static ArrayList<String> getFileList(File curDir, ArrayList<String> array) {
        File[] filesList;
        for (File f : filesList = curDir.listFiles()) {
            if (f.isDirectory()) {
                dirChangeDetector.getFileList(f, array);
            }
            if (!f.isFile()) continue;
            array.add(f.getPath());
        }
        return array;
    }

    protected static String getRootDir() {
        String root = "";
        try {
            root = new File(dirChangeDetector.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParentFile().getParent();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return root + File.separator;
    }

    protected static String getFileContent(String absolutePath) {
        String content = "";
        File file = new File(absolutePath);
        if (!file.exists()) {
            return content;
        }
        try {
            content = new String(Files.readAllBytes(Paths.get(absolutePath, new String[0])));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return content;
    }

    protected static void deleteFile(String absolutePath) {
        File file = new File(absolutePath);
        file.delete();
    }
}

