/*
 * Decompiled with CFR 0.152.
 */
package core.support.annotation.helper.utils;

import core.helpers.Helper;
import core.support.configReader.Config;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import net.lingala.zip4j.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.MavenInvocationException;

public class MavenCommandRunner {
    public static String MAVEN_PATH = "";
    public static String MAVEN_URL = "http://apache.mirror.globo.tech/maven/maven-3/3.6.2/binaries/apache-maven-3.6.2-bin.zip";
    public static String MAVEN_DOWNLOAD_DESTINATION = MavenCommandRunner.getRootDir() + ".." + File.separator + "runner" + File.separator + "utils" + File.separator + "maven" + File.separator;
    static String MAVEN_PROPERTY = "maven.home";
    static String MAVEN_URL_PROPERTY = "maven.url";

    public static void main(String[] args) throws Exception {
        System.out.println("Root Path: " + MavenCommandRunner.getRootDir());
        MavenCommandRunner.setMavenPathFromConfig();
        MavenCommandRunner.setMavenPath();
        MavenCommandRunner.downloadMavenIfNotExist();
        boolean isSuccess = MavenCommandRunner.runMavenInvoker(args);
        if (!isSuccess) {
            MavenCommandRunner.excuteCommand("mvn " + Arrays.toString(args).replaceAll("^.|.$", ""));
        }
    }

    public static void setMavenPathFromConfig() {
        String path = Config.getValue(MAVEN_PROPERTY);
        if (path.isEmpty()) {
            return;
        }
        File mavenFolderPath = new File(path);
        if (MavenCommandRunner.isFileInFolderPath(mavenFolderPath, "bin")) {
            MAVEN_PATH = path;
        }
    }

    public static void downloadMavenIfNotExist() throws Exception {
        if (!MAVEN_PATH.isEmpty()) {
            return;
        }
        File mavenDestinationPath = new File(MAVEN_DOWNLOAD_DESTINATION);
        if (!MavenCommandRunner.isMavenDownloaded(mavenDestinationPath)) {
            String urlProperty = Config.getValue(MAVEN_URL_PROPERTY);
            if (!urlProperty.isEmpty()) {
                MAVEN_URL = urlProperty;
            }
            System.out.println("<<Downloading maven... " + MAVEN_URL + ">>");
            FileUtils.deleteDirectory((File)mavenDestinationPath);
            mavenDestinationPath.mkdir();
            String zipPath = mavenDestinationPath.getAbsolutePath() + File.separator + "download.zip";
            FileUtils.copyURLToFile((URL)new URL(MAVEN_URL), (File)new File(zipPath));
            new ZipFile(zipPath).extractAll(MAVEN_DOWNLOAD_DESTINATION);
            FileUtils.forceDelete((File)new File(zipPath));
        }
        String mavenPath = MAVEN_DOWNLOAD_DESTINATION + MavenCommandRunner.getMavenDownloadHome(mavenDestinationPath);
        System.out.println("Setting maven path to: " + mavenPath);
        MAVEN_PATH = mavenPath;
    }

    private static String getMavenDownloadHome(File mavenDestinationPath) {
        String mavenHomePath = "";
        File[] fileList = mavenDestinationPath.listFiles();
        if (fileList.length == 0) {
            return mavenHomePath;
        }
        for (File file : fileList) {
            if (!file.getName().toLowerCase().contains("maven")) continue;
            return file.getName();
        }
        return mavenHomePath;
    }

    private static boolean isMavenDownloaded(File mavenDestinationPath) {
        File[] fileList = mavenDestinationPath.listFiles();
        if (fileList == null || fileList.length == 0) {
            return false;
        }
        String mavenHome = MavenCommandRunner.getMavenDownloadHome(mavenDestinationPath);
        File mavenPath = new File(mavenDestinationPath.getAbsolutePath() + File.separator + mavenHome + File.separator + "bin" + File.separator + "mvn");
        return mavenPath.exists();
    }

    public static void setMavenPath() {
        String[] resultArray;
        if (!MAVEN_PATH.isEmpty()) {
            return;
        }
        ArrayList<String> results = Helper.executeCommand("mvn -version");
        System.out.println("maven -version results: " + results);
        String resultsString = Arrays.toString(results.toArray());
        if (results.isEmpty()) {
            return;
        }
        for (String result : resultArray = resultsString.split(",")) {
            if (!result.contains("Maven home:")) continue;
            MAVEN_PATH = result.split(":")[1].trim();
        }
        System.out.println("maven path: " + MAVEN_PATH);
    }

    protected static ArrayList<String> excuteCommand(String command) {
        System.out.println("<<executing maven command through command line>>");
        ArrayList<String> results = new ArrayList<String>();
        if (MavenCommandRunner.isMac() || MavenCommandRunner.isUnix()) {
            results = MavenCommandRunner.runCommand("/bin/sh", "-c", command);
        } else if (MavenCommandRunner.isWindows()) {
            results = MavenCommandRunner.runCommand("cmd /c start " + command);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList<String> runCommand(String ... cmd) {
        ArrayList<String> results = new ArrayList<String>();
        Process pr = null;
        boolean success = false;
        int retry = 3;
        do {
            --retry;
            try {
                String line;
                Runtime run = Runtime.getRuntime();
                pr = run.exec(cmd);
                pr.waitFor();
                BufferedReader buf = new BufferedReader(new InputStreamReader(pr.getInputStream()));
                while ((line = buf.readLine()) != null) {
                    results.add(line);
                }
                success = true;
            }
            catch (Exception e) {
                System.out.println("shell command:  '" + cmd + "' output: " + e.getMessage());
            }
            finally {
                if (pr != null) {
                    pr.destroy();
                }
            }
        } while (!success && retry > 0);
        if (results.isEmpty()) {
            System.out.println("shell command:  '" + Arrays.toString(cmd) + "' did not return results. please check your path: ");
        }
        return results;
    }

    protected static boolean isMac() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.contains("mac");
    }

    protected static boolean isWindows() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.contains("win");
    }

    protected static boolean isUnix() {
        String osName = System.getProperty("os.name");
        return osName.indexOf("nix") >= 0 || osName.indexOf("linux") >= 0 || osName.indexOf("nux") >= 0 || osName.indexOf("aix") > 0;
    }

    private static boolean runMavenInvoker(String[] args) {
        ArrayList<String> goals = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            goals.add(args[i]);
        }
        if (goals.isEmpty()) {
            goals.add("compile");
        }
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        String pomLocation = MavenCommandRunner.getRootDir() + "pom.xml";
        request.setPomFile(new File(pomLocation));
        request.setGoals(goals);
        DefaultInvoker invoker = new DefaultInvoker();
        File mavenFile = MavenCommandRunner.verifyAndGetMavenHomePath();
        System.out.println("runMavenInvoker: " + MAVEN_PATH);
        invoker.setMavenHome(mavenFile);
        try {
            invoker.execute((InvocationRequest)request);
        }
        catch (MavenInvocationException e) {
            System.out.println("<<maven invoker has failed>>");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static File verifyAndGetMavenHomePath() {
        File mavenFolderPath = new File(MAVEN_PATH.trim());
        if (MavenCommandRunner.isFileInFolderPath(mavenFolderPath, "bin")) {
            return mavenFolderPath;
        }
        if (MavenCommandRunner.isFileInFolderPath(mavenFolderPath = mavenFolderPath.getParentFile(), "bin")) {
            return mavenFolderPath;
        }
        MAVEN_PATH = mavenFolderPath.getAbsolutePath();
        return mavenFolderPath;
    }

    public static String getRootDir() {
        File currentWorkingDir = new File(".");
        File root = null;
        if (MavenCommandRunner.isFileInFolderPath(currentWorkingDir, "pom.xml")) {
            root = currentWorkingDir;
        } else if (MavenCommandRunner.isFileInFolderPath(new File("../"), "pom.xml")) {
            root = new File("../");
        }
        return root.getAbsolutePath() + File.separator;
    }

    private static boolean isFileInFolderPath(File folderPath, String exepctedFile) {
        File[] fileList = folderPath.listFiles();
        if (fileList == null) {
            return false;
        }
        for (File file : fileList) {
            if (!file.getName().toLowerCase().contains(exepctedFile)) continue;
            return true;
        }
        return false;
    }

    public static void executeMavenCommandEmbedded() {
    }
}

