/*
 * Decompiled with CFR 0.152.
 */
package core.support.annotation.helper.annotationMap;

import core.support.annotation.Data;
import core.support.annotation.helper.Logger;
import core.support.annotation.helper.PackageHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;

public class DataMapHelper {
    public static Map<String, List<File>> getDataModuleMap(List<File> files) {
        HashMap<String, List<File>> moduleMap = new HashMap<String, List<File>>();
        for (File file : files) {
            List<File> dataFiles = new ArrayList<File>();
            String module = PackageHelper.getModuleFromFullPath(file);
            if (moduleMap.get(module) != null) {
                dataFiles = (List)moduleMap.get(module);
                dataFiles.add(file);
            } else {
                dataFiles.add(file);
            }
            moduleMap.put(module, dataFiles);
        }
        return moduleMap;
    }

    public static Map<String, List<Element>> getDataObjectMap(RoundEnvironment roundEnv) {
        return DataMapHelper.addElementsToDataMap(roundEnv);
    }

    public static Map<String, List<Element>> addElementsToDataMap(RoundEnvironment roundEnv) {
        Map<String, List<Element>> dataMap = DataMapHelper.initializePanelMap(roundEnv);
        String moduleName = "";
        for (Map.Entry<String, List<Element>> entry : dataMap.entrySet()) {
            ArrayList<Element> elements = new ArrayList<Element>();
            moduleName = entry.getKey();
            for (Element element : roundEnv.getElementsAnnotatedWith(Data.class)) {
                String currentModuleName;
                if (element.getKind() != ElementKind.CLASS || !(currentModuleName = PackageHelper.getModuleName(element)).equals(entry.getKey())) continue;
                Logger.debug("addElementsToDataMap: module: " + currentModuleName + " adding panel: " + element.asType().toString());
                elements.add(element);
            }
            Logger.debug("addElementsToDataMap: moduleName: " + moduleName + " panel count: " + elements.size());
            dataMap.put(moduleName, elements);
        }
        return dataMap;
    }

    public static Map<String, List<Element>> initializePanelMap(RoundEnvironment roundEnv) {
        HashMap<String, List<Element>> map = new HashMap<String, List<Element>>();
        ArrayList elements = new ArrayList();
        for (Element element : roundEnv.getElementsAnnotatedWith(Data.class)) {
            if (element.getKind() != ElementKind.CLASS) continue;
            String moduleName = PackageHelper.getModuleName(element);
            map.put(moduleName, elements);
        }
        return map;
    }

    public static Map<String, List<String>> mergeMaps(Map<String, List<String>> mapA, Map<String, List<String>> mapB) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.putAll(mapA);
        mapB.forEach((key, value) -> {
            List list = (List)map.get(key);
            if (list == null) {
                map.put((String)key, (List<String>)value);
            } else {
                ArrayList mergedValue = new ArrayList(value);
                mergedValue.addAll(list);
                map.put((String)key, mergedValue);
            }
        });
        return map;
    }
}

