/*
 * Decompiled with CFR 0.152.
 */
package core.helpers;

import core.support.logger.TestLog;
import org.testng.Assert;
import org.testng.asserts.SoftAssert;

public class AssertHelper {
    protected static void assertTrue(String message, boolean value) {
        if (!value) {
            TestLog.ConsoleLog("Assertion failed: " + message, new Object[0]);
        }
        Assert.assertTrue((boolean)value, (String)message);
    }

    protected static void assertFalse(String message) {
        Assert.assertTrue((boolean)false, (String)message);
    }

    protected static void assertFalse(String message, boolean value) {
        Assert.assertTrue((!value ? 1 : 0) != 0, (String)message);
    }

    protected static void assertEquals(String expected, String actual) {
        TestLog.logPass("validating if expected: " + expected + " equals to actual: " + actual, new Object[0]);
        Assert.assertEquals((String)actual, (String)expected);
    }

    protected static void assertEquals(boolean expected, boolean actual) {
        TestLog.logPass("validating if expected: " + expected + " equals to actual: " + actual, new Object[0]);
        Assert.assertEquals((boolean)actual, (boolean)expected);
    }

    protected static void assertEquals(int expected, int actual) {
        TestLog.logPass("validating if expected: " + expected + " equals to actual: " + actual, new Object[0]);
        Assert.assertEquals((int)actual, (int)expected);
    }

    protected static void softAssertTrue(String message, boolean value) {
        SoftAssert softAssertion = new SoftAssert();
        softAssertion.assertTrue(value, message);
        TestLog.ConsoleLogWarn("soft assert failed: " + message, new Object[0]);
    }

    protected static void softAssertEqual(String expected, String actual) {
        SoftAssert softAssertion = new SoftAssert();
        softAssertion.assertEquals(actual, expected);
        TestLog.ConsoleLogWarn("soft assert failed: expected: " + expected + " but actual was: " + actual, new Object[0]);
    }

    protected static void softAssertEqual(int expected, int actual) {
        SoftAssert softAssertion = new SoftAssert();
        softAssertion.assertEquals(actual, expected);
        TestLog.ConsoleLogWarn("soft assert failed: expected: " + expected + " but actual was: " + actual, new Object[0]);
    }

    protected static void assertContains(String actual, String expected) {
        TestLog.logPass("validating if expected: " + expected + " contains actual: " + actual, new Object[0]);
        AssertHelper.assertTrue("actual: " + actual + " does not contain expected: " + expected, actual.contains(expected));
    }
}

