/*
 * Decompiled with CFR 0.152.
 */
package core.apiCore.interfaces;

import com.microsoft.azure.servicebus.ClientFactory;
import com.microsoft.azure.servicebus.IMessage;
import com.microsoft.azure.servicebus.IMessageReceiver;
import com.microsoft.azure.servicebus.IMessageSender;
import com.microsoft.azure.servicebus.Message;
import com.microsoft.azure.servicebus.ReceiveMode;
import com.microsoft.azure.servicebus.primitives.ConnectionStringBuilder;
import com.microsoft.azure.servicebus.primitives.ServiceBusException;
import core.apiCore.helpers.DataHelper;
import core.apiCore.helpers.XmlHelper;
import core.helpers.Helper;
import core.helpers.StopWatchHelper;
import core.support.configReader.Config;
import core.support.logger.TestLog;
import core.support.objects.ServiceObject;
import core.support.objects.TestObject;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.builder.Input;
import org.xmlunit.diff.DefaultNodeMatcher;
import org.xmlunit.diff.Diff;
import org.xmlunit.diff.ElementSelector;
import org.xmlunit.diff.ElementSelectors;
import org.xmlunit.diff.NodeMatcher;

public class ServiceBusInterface {
    private static final String SERVICE_BUS_PREFIX = "SB_";
    private static final String CONNECTION_STR = "serviceBusConnectionString";
    private static final String INBOUND_QUEUE = "inboundQueue";
    private static final String OUTBOUND_TOPIC = "outboundTopic";
    private static final String OUTBOUND_SUB1 = "outboundSub1";
    private static final String OUTBOUND_SUB2 = "outboundSub2";
    private static final String OUTBOUND_ALERT = "outboundAlert";
    private static final String CONNECTION_SAP_STR = "SapServiceBusConnectionString";
    private static final String INBOUND_SAP_QUEUE = "SapInboundQueue";
    private static final String OUTBOUND_SAP_TOPIC = "SapOutboundTopic";
    private static final String EVENT_TOPIC = "eventTopic";
    private static final String HOST_FORM_SUBMITTED = "UserRequest";
    private static final String EVENT_SUB = "eventSub";
    private static final String DEAD_LETTER_QUEUE_SUFFIX = "/$DeadLetterQueue";
    private static final String CONF_MSG_TIME_OUT = "serviceBusMessageReceiveMaxTime";
    private static final String EMPTY_CHECK = "emptyCheck";
    private static final String TEMPLATE_FILES_PATH = "templateFilesPath";
    private static final String TEST_DATA_CLEANUP = "systemCleanup";
    private static final String PURGE_SB_RECEIVERS = "purgeServiceBusReceivers";
    private static final String AND_TOKEN = "&&";
    private static final String HOST1 = "HOST1";
    private static final String HOST2 = "HOST2";
    private static final String HOST_ALERT = "ALERT";
    private static final String MSG_ID_XPATH = "/Envelope/Body/Message/Header/MsgID";
    private static final String FORM_SUBMITTED = "FormSubmitted";
    public static final String MESSAGE_ID_PREFIX = "apiTestMsgID";
    private static final String NO_CHECK_NEEDED = "noCheckNeeded";
    private IMessageReceiver receiver1 = null;
    private IMessageReceiver receiver2 = null;
    private IMessageReceiver receiverAlert = null;
    private IMessageSender sender;
    public static Map<String, serviceBus> sbInstance = new ConcurrentHashMap<String, serviceBus>();
    public static Map<IMessage, Boolean> outboundMessages = new ConcurrentHashMap<IMessage, Boolean>();
    private static final int SERVICE_BUS_TIMEOUT_SECONDS = 120;

    public static synchronized serviceBus getInstance(String host) {
        serviceBus servicebus = null;
        int retry = 3;
        while ((servicebus = ServiceBusInterface.getSbInstance(host)) == null && --retry > 0) {
        }
        Helper.assertTrue("service bus instance could not be created", servicebus.isInitiated);
        return servicebus;
    }

    private static synchronized serviceBus getSbInstance(String type) {
        serviceBus instance = sbInstance.get(type);
        if (instance.isInitiated) {
            return instance;
        }
        instance.inbound = instance.inboundQueue;
        TestLog.logPass("inbound = {0}", instance.inbound);
        TestLog.logPass("connectionStr = {0}", instance.connectionStr);
        instance = ServiceBusInterface.setSender(instance);
        for (String host : instance.hosts) {
            instance.outbound = instance.outboundTopic + "/subscriptions/" + host;
            TestLog.logPass("outbound = {0}", instance.outbound);
            instance = ServiceBusInterface.setReceiver(host, instance);
        }
        if (instance.sender != null && !instance.receivers.isEmpty()) {
            instance.isInitiated = true;
        }
        return instance;
    }

    private static serviceBus setSender(serviceBus instance) {
        try {
            instance.sender = ClientFactory.createMessageSenderFromConnectionStringBuilder((ConnectionStringBuilder)new ConnectionStringBuilder(instance.connectionStr, instance.inbound));
        }
        catch (ServiceBusException | InterruptedException ex) {
            TestLog.ConsoleLogWarn(ex.getMessage(), new Object[0]);
            Thread.interrupted();
        }
        return instance;
    }

    private static serviceBus setReceiver(String host, serviceBus instance) {
        try {
            instance.receivers.put(host, ClientFactory.createMessageReceiverFromConnectionStringBuilder((ConnectionStringBuilder)new ConnectionStringBuilder(instance.connectionStr, instance.outbound), (ReceiveMode)ReceiveMode.RECEIVEANDDELETE));
        }
        catch (ServiceBusException | InterruptedException ex) {
            TestLog.ConsoleLogWarn(ex.getMessage(), new Object[0]);
            Thread.interrupted();
        }
        return instance;
    }

    private void setupServiceBusInstance() {
        serviceBus instance = null;
        for (Map.Entry<String, Object> entry : TestObject.getTestInfo().config.entrySet()) {
            if (!entry.getKey().contains(SERVICE_BUS_PREFIX)) continue;
            String[] values = entry.getKey().split("_");
            String type = values[1];
            String key = values[2];
            String value = (String)entry.getValue();
            instance = sbInstance.get(type) == null ? new ServiceBusInterface().new serviceBus() : sbInstance.get(type);
            switch (key) {
                case "connectionStr": {
                    instance.connectionStr = key;
                    break;
                }
                case "inboundQueue": {
                    instance.inboundQueue = key;
                    break;
                }
                case "outboundTopic": {
                    instance.outboundTopic = key;
                }
            }
            if (key.contains("host") && !value.isEmpty()) {
                instance.hosts.add(value);
            }
            sbInstance.put(type, instance);
        }
    }

    public static void testServiceBus(ServiceObject apiObject) {
        serviceBus serviceBus2 = ServiceBusInterface.getInstance(apiObject.getOption());
        apiObject.withRequestBody(DataHelper.replaceParameters(apiObject.getRequestBody()));
        apiObject.withExpectedResponse(DataHelper.replaceParameters(apiObject.getExpectedResponse()));
        apiObject.withRequestBody(ServiceBusInterface.getRequestBodyFromTemplate(apiObject.getRequestBody(), apiObject.getTemplateFile(), apiObject.getContentType()));
        apiObject.withRequestBody(DataHelper.replaceParameters(apiObject.getRequestBody()));
        String msgID = ServiceBusInterface.generateMessageId(apiObject.getRequestBody());
        ServiceBusInterface.sendMessage(apiObject.getRequestBody(), serviceBus2, msgID);
        boolean isTestPass = ServiceBusInterface.receiveAndVerifyOutboundMessage(serviceBus2, msgID, apiObject.getOption(), apiObject.getRequestBody(), apiObject.getOutputParams(), apiObject.getExpectedResponse());
        if (msgID.isEmpty()) {
            Helper.assertTrue("correct messages not received. SB Verification test, please investigate previous test for proper outbound message", isTestPass);
        }
        Helper.assertTrue("correct messages not received", isTestPass);
    }

    public static String generateMessageId(String requestBody) {
        if (!requestBody.isEmpty()) {
            return "apiTestMsgID-" + UUID.randomUUID().toString();
        }
        return "";
    }

    public static void sendMessage(String requestBody, serviceBus serviceBus2, String msgID) {
        if (!requestBody.isEmpty()) {
            Message msgToInboundQueue = new Message(requestBody.getBytes());
            msgToInboundQueue.setMessageId(msgID);
            TestLog.logPass("Request Message: {0} \r\n", requestBody);
            ServiceBusInterface.sendMessage(serviceBus2, (IMessage)msgToInboundQueue);
        }
    }

    public static String getRequestBodyFromTemplate(String requestBody, String templateFile, String contentType) {
        if (!templateFile.isEmpty()) {
            String templateFilePath = DataHelper.getTemplateFileLocation(templateFile);
            if (requestBody.isEmpty()) {
                // empty if block
            }
        }
        return requestBody;
    }

    public static IMessageReceiver getReceiver(serviceBus serviceBus2, String hostSelector) {
        if (!serviceBus2.hosts.contains(hostSelector)) {
            Helper.assertFalse("host receiver not available: " + hostSelector);
        }
        return serviceBus2.receivers.get(hostSelector);
    }

    public static boolean receiveAndVerifyOutboundMessage(serviceBus serviceBus2, String msgId, String options, String requestBody, String outputParams, String partialExpStr) {
        String outboundQueueMsg = "";
        CopyOnWriteArrayList<IMessage> filteredMessages = new CopyOnWriteArrayList<IMessage>();
        String hostSelector = XmlHelper.getXmlTagValue(options, "host");
        IMessageReceiver receiver = ServiceBusInterface.getReceiver(serviceBus2, hostSelector);
        int expectedMessageCount = ServiceBusInterface.getExpectedMessageCount(partialExpStr);
        TestLog.logPass("requestIdentifier: " + msgId, new Object[0]);
        if (ServiceBusInterface.isNoResponseExpected(outputParams, partialExpStr)) {
            return true;
        }
        int maxRetrySeconds = 120;
        boolean isTestPass = false;
        boolean isPartialExpStr = false;
        if (!partialExpStr.isEmpty()) {
            isPartialExpStr = true;
        }
        StopWatchHelper watch = StopWatchHelper.start();
        long passedTimeInSeconds = 0L;
        long lastLogged = 0L;
        int interval = 10;
        do {
            lastLogged = ServiceBusInterface.logPerInterval(interval, watch, lastLogged);
            Collection<IMessage> msgFromOutboundQueue = ServiceBusInterface.getOutboundMessages(receiver);
            filteredMessages.addAll(ServiceBusInterface.filterOUtboundMessage(hostSelector, requestBody, partialExpStr, msgFromOutboundQueue, msgId));
            if (ServiceBusInterface.isEmptyResultsExpectedAndVerified(filteredMessages, partialExpStr)) {
                return true;
            }
            for (IMessage message : filteredMessages) {
                TestLog.logPass("filteredMessages: " + filteredMessages.size(), new Object[0]);
                outboundQueueMsg = new String(message.getBody());
                TestLog.logPass("Message received: {0}", outboundQueueMsg);
                if (ServiceBusInterface.isNoResponseExpected(outboundQueueMsg, outputParams, partialExpStr)) {
                    return true;
                }
                boolean comparePartialExpected = ServiceBusInterface.isPartialExpect(partialExpStr = ServiceBusInterface.comparePartialExpected(outboundQueueMsg, message, receiver, partialExpStr), isPartialExpStr);
                if (!comparePartialExpected) continue;
                isTestPass = true;
                break;
            }
            passedTimeInSeconds = watch.time(TimeUnit.SECONDS);
        } while (!isTestPass && passedTimeInSeconds < (long)maxRetrySeconds);
        if (!isTestPass && filteredMessages.isEmpty()) {
            if (msgId.isEmpty()) {
                Helper.assertTrue("No messages received. SB verification test, please investigate previous test for proper outbound messag", false);
            }
            Helper.assertTrue("No messages received. msgId: " + msgId, false);
        }
        int receivedMessageCount = filteredMessages.size();
        return isTestPass;
    }

    public static int getExpectedMessageCount(String partialExpStr) {
        if (!partialExpStr.isEmpty()) {
            String[] values = partialExpStr.split(AND_TOKEN);
            return values.length;
        }
        return 1;
    }

    public static long logPerInterval(int interval, StopWatchHelper watch, long lastLogged) {
        long passedTimeInSeconds = watch.time(TimeUnit.SECONDS);
        if (passedTimeInSeconds > (long)interval && passedTimeInSeconds - lastLogged > (long)interval) {
            TestLog.logPass("waiting: " + watch.time(TimeUnit.SECONDS) + " seconds", new Object[0]);
            lastLogged = passedTimeInSeconds;
        }
        return lastLogged;
    }

    public static boolean isEmptyResultsExpectedAndVerified(Collection<IMessage> filteredMessages, String partialExpStr) {
        boolean isPartialExpStrEmpty = partialExpStr.equalsIgnoreCase(Config.getValue(EMPTY_CHECK));
        String outboundQueueMsg = "";
        if (isPartialExpStrEmpty) {
            if (!filteredMessages.isEmpty()) {
                outboundQueueMsg = new String(filteredMessages.iterator().next().getBody());
            }
            Helper.assertTrue("No outbound messages should be received, But got message of length: " + String.valueOf(outboundQueueMsg.length()), filteredMessages.isEmpty());
            return true;
        }
        return false;
    }

    public static boolean isNoResponseExpected(String outboundQueueMsg, String outputParams, String partialExpStr) {
        if (ServiceBusInterface.noCheckNeeded(partialExpStr)) {
            if (outputParams.isEmpty() || outboundQueueMsg.contains(FORM_SUBMITTED) || outboundQueueMsg.contains(HOST_FORM_SUBMITTED)) {
                // empty if block
            }
            Helper.waitForSeconds(3.0);
            return true;
        }
        return false;
    }

    public static boolean isNoResponseExpected(String outputParams, String partialExpStr) {
        if (ServiceBusInterface.noCheckNeeded(partialExpStr)) {
            Helper.waitForSeconds(10.0);
            return true;
        }
        return false;
    }

    public static boolean noCheckNeeded(String expStrContent) {
        return StringUtils.isEmpty((CharSequence)expStrContent) || expStrContent.equalsIgnoreCase(Config.getValue(NO_CHECK_NEEDED));
    }

    public static Collection<IMessage> filterOUtboundMessage(String hostSelector, String requestBody, String partialExpStr, Collection<IMessage> msgFromOutboundQueue, String msgId) {
        if (StringUtils.isEmpty((CharSequence)hostSelector)) {
            hostSelector = HOST1;
        }
        CopyOnWriteArrayList<IMessage> filteredMessages = new CopyOnWriteArrayList();
        if (!requestBody.isEmpty()) {
            filteredMessages = ServiceBusInterface.findMessages(hostSelector, msgId);
            if (filteredMessages.isEmpty() && !requestBody.contains("MsgID")) {
                TestLog.logPass("requestIdentifier: no message id", new Object[0]);
                filteredMessages = ServiceBusInterface.findMessagesNotContaining(hostSelector, "correlationid");
            }
            return filteredMessages;
        }
        if (requestBody.isEmpty()) {
            filteredMessages = ServiceBusInterface.FilterBasedOnIdentifierInExpectedMessages(hostSelector, "OrderNumber", partialExpStr);
            if (filteredMessages.isEmpty()) {
                filteredMessages = ServiceBusInterface.FilterBasedOnIdentifierInExpectedMessages(hostSelector, "TaskNumber", partialExpStr);
            }
            if (!filteredMessages.isEmpty()) {
                TestLog.logPass("requestIdentifier: OrderNumber or TaskNumber", new Object[0]);
                return filteredMessages;
            }
        }
        return filteredMessages;
    }

    public static void addMessages(String hostSelector, Collection<IMessage> msgFromOutboundQueue) {
        for (IMessage message : msgFromOutboundQueue) {
            if (hostSelector.toLowerCase().contains(HOST1.toLowerCase())) {
                hostSelector = HOST1;
            } else if (hostSelector.toLowerCase().contains(HOST2.toLowerCase())) {
                hostSelector = HOST2;
            }
            message.setLabel(hostSelector);
            outboundMessages.put(message, true);
            TestLog.logPass("global message size in outbound list: " + outboundMessages.size(), new Object[0]);
        }
    }

    public static CopyOnWriteArrayList<IMessage> FilterBasedOnIdentifierInExpectedMessages(String hostSelector, String key, String partialExpStr) {
        String orderValue = "";
        CopyOnWriteArrayList<IMessage> filteredMessages = new CopyOnWriteArrayList<IMessage>();
        if (!partialExpStr.isEmpty()) {
            orderValue = XmlHelper.getXmlTagValue(partialExpStr, key);
        }
        if (!orderValue.isEmpty()) {
            filteredMessages = ServiceBusInterface.findMessages(hostSelector, orderValue);
        }
        return filteredMessages;
    }

    public static CopyOnWriteArrayList<IMessage> findMessages(String hostSelector, String requestIdentifier) {
        CopyOnWriteArrayList<IMessage> filteredMessages = new CopyOnWriteArrayList<IMessage>();
        for (Map.Entry<IMessage, Boolean> entry : outboundMessages.entrySet()) {
            IMessage message = entry.getKey();
            String outboundQueueMsg = new String(message.getBody());
            String messageHost = message.getLabel();
            if (!entry.getValue().equals(true) || !outboundQueueMsg.toLowerCase().contains(requestIdentifier.toLowerCase())) continue;
            filteredMessages.add(message);
            outboundMessages.put(message, false);
        }
        return filteredMessages;
    }

    public static CopyOnWriteArrayList<IMessage> findMessagesNotContaining(String hostSelector, String requestIdentifier) {
        CopyOnWriteArrayList<IMessage> filteredMessages = new CopyOnWriteArrayList<IMessage>();
        for (Map.Entry<IMessage, Boolean> entry : outboundMessages.entrySet()) {
            IMessage message = entry.getKey();
            String outboundQueueMsg = new String(message.getBody());
            String messageHost = message.getLabel();
            if (!entry.getValue().equals(true) || outboundQueueMsg.toLowerCase().contains(requestIdentifier.toLowerCase())) continue;
            filteredMessages.add(message);
            outboundMessages.put(message, false);
        }
        return filteredMessages;
    }

    public static boolean isNumeric(String str) {
        for (char c : str.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isFromCurrentTest(String outboundQueueMsg) {
        return true;
    }

    public static void sendMessage(serviceBus serviceBus2, IMessage msgToInboundQueue) {
        try {
            serviceBus2.sender.send(msgToInboundQueue);
        }
        catch (ServiceBusException | InterruptedException ex) {
            TestLog.ConsoleLogWarn(ex.getMessage(), new Object[0]);
        }
    }

    public static Collection<IMessage> getOutboundMessages(IMessageReceiver receiver) {
        Collection<IMessage> msgFromOutboundQueue = new ArrayList();
        try {
            msgFromOutboundQueue = receiver.receiveBatch(500, Duration.ofSeconds(5L));
        }
        catch (ServiceBusException | InterruptedException ex) {
            ex.getMessage();
        }
        if (msgFromOutboundQueue != null) {
            for (IMessage message : msgFromOutboundQueue) {
                String correlationId = message.getCorrelationId();
                if (correlationId != null) {
                    TestLog.logPass("messageId received. correlationId: " + correlationId, new Object[0]);
                    continue;
                }
                String outboundMessage = new String(message.getBody());
                if (!outboundMessage.contains(MESSAGE_ID_PREFIX)) continue;
                correlationId = XmlHelper.getXmlTagValue(outboundMessage, "MsgCorrelationID");
                TestLog.logPass("messageId received. correlationId: " + correlationId, new Object[0]);
            }
        }
        if (msgFromOutboundQueue != null) {
            ServiceBusInterface.addMessages(receiver.getEntityPath(), msgFromOutboundQueue);
        }
        return msgFromOutboundQueue;
    }

    public static boolean compareExpected(String outboundQueueMsg, String expStr) {
        if (!ServiceBusInterface.noCheckNeeded(expStr)) {
            if (expStr.equalsIgnoreCase(Config.getValue(EMPTY_CHECK))) {
                Helper.assertTrue("No outbound messages should be received, But got message of length: " + String.valueOf(outboundQueueMsg.length()), outboundQueueMsg.isEmpty());
            } else {
                expStr = DataHelper.replaceParameters(expStr);
                Diff diffWithExpected = DiffBuilder.compare((Object)Input.fromString((String)outboundQueueMsg)).withTest((Object)Input.fromString((String)expStr)).ignoreComments().ignoreWhitespace().checkForSimilar().withNodeMatcher((NodeMatcher)new DefaultNodeMatcher(new ElementSelector[]{ElementSelectors.byNameAndAllAttributes})).build();
                if (diffWithExpected.hasDifferences()) {
                    TestLog.ConsoleLogWarn(diffWithExpected.toString(), new Object[0]);
                }
                return diffWithExpected.hasDifferences();
            }
        }
        return false;
    }

    public static boolean isPartialExpect(String partialExpStr, boolean isPartialExpStr) {
        if (isPartialExpStr) {
            return partialExpStr.isEmpty() || partialExpStr.equalsIgnoreCase(Config.getValue(EMPTY_CHECK));
        }
        return false;
    }

    public static String comparePartialExpected(String outboundQueueMsg, IMessage msgFromOutboundQueue, IMessageReceiver receiver, String partialExpStr) {
        if (!ServiceBusInterface.noCheckNeeded(partialExpStr) && !partialExpStr.equalsIgnoreCase(Config.getValue(EMPTY_CHECK))) {
            LinkedList<String> partialExpStrList = new LinkedList<String>(Arrays.asList(partialExpStr.split(AND_TOKEN)));
            Iterator iterator = partialExpStrList.iterator();
        }
        return partialExpStr;
    }

    public static boolean compareNotExpected(String outboundQueueMsg, String notExpStr) {
        if (!ServiceBusInterface.noCheckNeeded(notExpStr)) {
            if (notExpStr.equalsIgnoreCase(Config.getValue(EMPTY_CHECK))) {
                if (!outboundQueueMsg.isEmpty()) {
                    return true;
                }
            } else {
                notExpStr = DataHelper.replaceParameters(notExpStr);
            }
        }
        return false;
    }

    public static void purgeQueues() {
        TestLog.logPass("purgeServiceBusReceivers is disabled. Queued messages are not purged.", new Object[0]);
    }

    public static void purgeOutboundQueues() {
        String[] types;
        TestLog.logPass("purging queue messages from service bus by types", new Object[0]);
        for (String type : types = Config.getValue(PURGE_SB_RECEIVERS).split(",")) {
            ServiceBusInterface.purgeReceivers(sbInstance.get(type));
        }
    }

    private static void purgeReceivers(serviceBus serviceBus2) {
        try {
            for (Map.Entry<String, IMessageReceiver> entry : serviceBus2.receivers.entrySet()) {
                if (entry.getValue() == null) continue;
                while (entry.getValue().receiveBatch(100, Duration.ofSeconds(1L)) != null) {
                }
            }
        }
        catch (ServiceBusException | InterruptedException ex) {
            TestLog.ConsoleLogWarn(ex.getMessage(), new Object[0]);
        }
    }

    class serviceBus {
        boolean isInitiated = false;
        Map<String, IMessageReceiver> receivers = new ConcurrentHashMap<String, IMessageReceiver>();
        IMessageSender sender = null;
        String connectionStr = "";
        String inboundQueue = "";
        String inbound = "";
        String outboundTopic = "";
        String outbound = "";
        List<String> hosts = new ArrayList<String>();

        serviceBus() {
        }
    }

    public static enum SBEnv {
        DEFAULT,
        SAP,
        TOPIC_DLQ,
        HOST1,
        HOST2,
        ALERT;

    }
}

