/*
 * Decompiled with CFR 0.152.
 */
package core.apiCore.interfaces;

import core.apiCore.helpers.DataHelper;
import core.apiCore.helpers.JsonHelper;
import core.helpers.Helper;
import core.helpers.StopWatchHelper;
import core.support.configReader.Config;
import core.support.logger.TestLog;
import core.support.objects.KeyValue;
import core.support.objects.ServiceObject;
import core.support.objects.TestObject;
import io.restassured.RestAssured;
import io.restassured.config.EncoderConfig;
import io.restassured.config.HttpClientConfig;
import io.restassured.config.RestAssuredConfig;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;

public class RestApiInterface {
    private static final String AUTHORIZATION_HEADER = "Authorization";
    public static final String API_TIMEOUT_VALIDATION_ENABLED = "api.timeout.validation.isEnabled";
    public static final String API_TIMEOUT_VALIDATION_SECONDS = "api.timeout.validation.seconds";
    private static final String INVALID_TOKEN = "INVALID_TOKEN";
    private static final String NO_TOKEN = "NO_TOKEN";
    private static final String OPTION_NO_VALIDATION_TIMEOUT = "NO_VALIDATION_TIMEOUT";
    private static final String OPTION_WAIT_FOR_RESPONSE = "WAIT_FOR_RESPONSE";

    public static Response RestfullApiInterface(ServiceObject serviceObject) {
        if (serviceObject == null) {
            Helper.assertFalse("apiobject is null");
        }
        RestApiInterface.setTimeout();
        RestApiInterface.setProxy();
        serviceObject.withRequestBody(DataHelper.replaceParameters(serviceObject.getRequestBody()));
        RequestSpecification request = RestApiInterface.setURI(serviceObject);
        Response response = RestApiInterface.evaluateRequestAndValidateResponse(serviceObject, request);
        return response;
    }

    public static Response evaluateRequestAndValidateResponse(ServiceObject serviceObject, RequestSpecification request) {
        List<Object> errorMessages = new ArrayList();
        Response response = null;
        StopWatchHelper watch = StopWatchHelper.start();
        long passedTimeInSeconds = 0L;
        boolean isValidationTimeout = Config.getBooleanValue(API_TIMEOUT_VALIDATION_ENABLED);
        int maxRetrySeconds = Config.getIntValue(API_TIMEOUT_VALIDATION_SECONDS);
        int currentRetryCount = 0;
        do {
            response = RestApiInterface.evaluateRequest(serviceObject, request);
            errorMessages = RestApiInterface.validateResponse(response, serviceObject);
            if (!isValidationTimeout) break;
            if (currentRetryCount > 0) {
                Helper.waitForSeconds(1.0);
                String errors = StringUtils.join(errorMessages, (String)"\n error: ");
                TestLog.ConsoleLog("attempt failed with message: " + errors, new Object[0]);
                TestLog.ConsoleLog("attempt #" + (currentRetryCount + 1), new Object[0]);
            }
            ++currentRetryCount;
            passedTimeInSeconds = watch.time(TimeUnit.SECONDS);
        } while (!errorMessages.isEmpty() && passedTimeInSeconds < (long)maxRetrySeconds);
        if (!errorMessages.isEmpty()) {
            String errorString = StringUtils.join(errorMessages, (String)"\n error: ");
            TestLog.ConsoleLog(errorString, new Object[0]);
            Helper.assertFalse(StringUtils.join(errorMessages, (String)"\n error: "));
        }
        return response;
    }

    public static RequestSpecification setURI(ServiceObject serviceObject) {
        String url = "";
        RequestSpecification request = RestAssured.given();
        serviceObject.withUriPath(DataHelper.replaceParameters(serviceObject.getUriPath()));
        serviceObject.withUriPath(Helper.stringRemoveLines(serviceObject.getUriPath()));
        url = serviceObject.getUriPath().startsWith("http") ? serviceObject.getUriPath() : Helper.stringRemoveLines(Config.getValue("api.uriPath")) + serviceObject.getUriPath();
        serviceObject.withUriPath(url);
        URL aURL = Helper.convertToUrl(url);
        TestLog.logPass("request URL: " + aURL.toString(), new Object[0]);
        request.baseUri(aURL.getProtocol() + "://" + aURL.getHost());
        request.port(aURL.getPort());
        request.basePath(aURL.getPath());
        return request;
    }

    public static void setTimeout() {
        int connectTimeout = Config.getIntValue("api.timeout.connect.seconds");
        if (connectTimeout == -1) {
            return;
        }
        RestAssured.config = RestAssuredConfig.config().httpClient(HttpClientConfig.httpClientConfig().setParam("http.connection.timeout", (Object)(connectTimeout * 1000)).setParam("http.socket.timeout", (Object)(connectTimeout * 1000)).setParam("http.connection-manager.timeout", (Object)(connectTimeout * 1000)));
    }

    public static void setProxy() {
        String host = Config.getValue("api.proxy.host");
        String port = Config.getValue("api.proxy.port");
        if (host.isEmpty()) {
            return;
        }
        RestAssured.proxy((String)host);
        if (!port.isEmpty()) {
            RestAssured.proxy((String)port);
        }
    }

    public static List<String> validateResponse(Response response, ServiceObject serviceObject) {
        List<String> errorMessages = new ArrayList<String>();
        if (response == null) {
            errorMessages.add("no response returned");
            return errorMessages;
        }
        JsonHelper.saveOutboundJsonParameters(response, serviceObject.getOutputParams());
        if (!serviceObject.getRespCodeExp().isEmpty()) {
            String message = "expected status code: " + serviceObject.getRespCodeExp() + " response status code: " + response.getStatusCode();
            TestLog.logPass(message, new Object[0]);
            if (response.getStatusCode() != Integer.valueOf(serviceObject.getRespCodeExp()).intValue()) {
                errorMessages.add(message);
                return errorMessages;
            }
        }
        String responseString = JsonHelper.getResponseValue(response);
        errorMessages = RestApiInterface.validateExpectedValues(responseString, serviceObject);
        errorMessages.removeAll(Collections.singleton(""));
        return errorMessages;
    }

    public static List<String> validateExpectedValues(String responseString, ServiceObject serviceObject) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        TestLog.logPass("response: " + responseString, new Object[0]);
        if (!serviceObject.getExpectedResponse().isEmpty()) {
            String[] criteria;
            serviceObject.withExpectedResponse(DataHelper.replaceParameters(serviceObject.getExpectedResponse()));
            for (String criterion : criteria = serviceObject.getExpectedResponse().split("&&")) {
                Helper.assertTrue("expected is not valid format: " + criterion, JsonHelper.isValidExpectation(criterion));
                errorMessages.add(JsonHelper.validateByJsonBody(criterion, responseString));
                errorMessages.addAll(JsonHelper.validateByKeywords(criterion, responseString));
                errorMessages.add(JsonHelper.validateResponseBody(criterion, responseString));
            }
        }
        errorMessages.removeAll(Collections.singleton(""));
        return errorMessages;
    }

    public static RequestSpecification evaluateRequestHeaders(ServiceObject serviceObject, RequestSpecification request) {
        if (serviceObject.getRequestHeaders().isEmpty()) {
            return request;
        }
        serviceObject.withRequestHeaders(DataHelper.replaceParameters(serviceObject.getRequestHeaders()));
        List<KeyValue> keywords = DataHelper.getValidationMap(serviceObject.getRequestHeaders());
        block12: for (KeyValue keyword : keywords) {
            switch (keyword.key) {
                case "BASIC": {
                    ArrayList basicRequest = (ArrayList)Config.getObjectValue("BASIC");
                    if (basicRequest.size() == 0) {
                        Helper.assertFalse("basic request info not found: " + Arrays.toString(basicRequest.toArray()));
                    }
                    request = request.auth().basic((String)basicRequest.get(0), (String)basicRequest.get(1));
                    continue block12;
                }
                case "INVALID_TOKEN": {
                    String authValue = Config.getValue(AUTHORIZATION_HEADER);
                    if (!authValue.isEmpty()) {
                        authValue = Helper.generateRandomString(authValue.length());
                        request = request.given().header(AUTHORIZATION_HEADER, (Object)authValue, new Object[0]);
                        continue block12;
                    }
                    request = request.given().header(AUTHORIZATION_HEADER, (Object)"invalid", new Object[0]);
                    continue block12;
                }
                case "NO_TOKEN": {
                    request = request.given().header(AUTHORIZATION_HEADER, (Object)"", new Object[0]);
                    continue block12;
                }
                case "Authorization": {
                    Config.putValue(AUTHORIZATION_HEADER, (String)keyword.value);
                    request = request.given().header(keyword.key, keyword.value, new Object[0]);
                    continue block12;
                }
            }
            request = request.given().header(keyword.key, keyword.value, new Object[0]);
        }
        return request;
    }

    public static RequestSpecification evaluateQueryParameters(ServiceObject serviceObject, RequestSpecification request) {
        URL aURL = Helper.convertToUrl(serviceObject.getUriPath());
        if (StringUtils.isBlank((String)aURL.getQuery())) {
            return request;
        }
        String[] queryParameters = aURL.getQuery().split("&");
        if (queryParameters.length == 0) {
            Helper.assertFalse("query parameters are wrong format: " + aURL.getQuery() + ". should be \"key=value&key2=value2\"");
        }
        for (String queryParameter : queryParameters) {
            String[] query = queryParameter.split("=");
            if (query.length == 0) {
                Helper.assertFalse("query parameters are wrong format: " + aURL.getQuery() + ". should be \"key=value&key2=value2\"");
            }
            request = request.given().queryParam(query[0], new Object[]{query[1]});
        }
        return request;
    }

    public static RequestSpecification evaluateRequestBody(ServiceObject serviceObject, RequestSpecification request) {
        if (serviceObject.getRequestBody().isEmpty()) {
            return request;
        }
        request = request.contentType(serviceObject.getContentType());
        if (serviceObject.getContentType().contains("form")) {
            String[] formData;
            request = request.config(RestAssured.config().encoderConfig(EncoderConfig.encoderConfig().encodeContentTypeAs("multipart/form-data", ContentType.TEXT)));
            for (String data : formData = serviceObject.getRequestBody().split(",")) {
                String[] keyValue = data.split(":");
                if (keyValue.length == 3) {
                    switch (keyValue[1]) {
                        case "FILE": {
                            File file = DataHelper.getFile(keyValue[2]);
                            request.multiPart(file);
                            break;
                        }
                    }
                    continue;
                }
                request = request.formParam(keyValue[0].trim(), new Object[]{keyValue[1].trim()});
            }
            return request;
        }
        return request.body(serviceObject.getRequestBody());
    }

    public static RequestSpecification evaluateOption(ServiceObject serviceObject, RequestSpecification request) {
        RestApiInterface.resetValidationTimeout();
        if (serviceObject.getOption().isEmpty()) {
            return request;
        }
        serviceObject.withOption(DataHelper.replaceParameters(serviceObject.getOption()));
        List<KeyValue> keywords = DataHelper.getValidationMap(serviceObject.getOption());
        for (KeyValue keyword : keywords) {
            switch (keyword.key) {
                case "NO_VALIDATION_TIMEOUT": {
                    Config.putValue(API_TIMEOUT_VALIDATION_ENABLED, false);
                    break;
                }
                case "WAIT_FOR_RESPONSE": {
                    Config.putValue(API_TIMEOUT_VALIDATION_ENABLED, true);
                    Config.putValue(API_TIMEOUT_VALIDATION_SECONDS, keyword.value);
                    break;
                }
            }
        }
        return request;
    }

    private static void resetValidationTimeout() {
        String defaultValidationTimeoutIsEnabled = TestObject.getDefaultTestInfo().config.get(API_TIMEOUT_VALIDATION_ENABLED).toString();
        Config.putValue(API_TIMEOUT_VALIDATION_ENABLED, defaultValidationTimeoutIsEnabled);
    }

    public static Response evaluateRequest(ServiceObject serviceObject, RequestSpecification request) {
        Response response = null;
        request = RestApiInterface.evaluateRequestHeaders(serviceObject, request);
        request = RestApiInterface.evaluateQueryParameters(serviceObject, request);
        request = RestApiInterface.evaluateRequestBody(serviceObject, request);
        request = RestApiInterface.evaluateOption(serviceObject, request);
        TestLog.logPass("request body: " + Helper.stringRemoveLines(serviceObject.getRequestBody()), new Object[0]);
        TestLog.logPass("request type: " + serviceObject.getMethod(), new Object[0]);
        switch (serviceObject.getMethod()) {
            case "POST": {
                response = (Response)request.when().post();
                break;
            }
            case "PUT": {
                response = (Response)request.when().put();
                break;
            }
            case "PATCH": {
                response = (Response)request.when().patch();
                break;
            }
            case "DELETE": {
                response = (Response)request.when().delete();
                break;
            }
            case "GET": {
                response = (Response)request.when().get();
                break;
            }
            case "OPTIONS": {
                response = (Response)request.when().options();
                break;
            }
            case "HEAD": {
                response = (Response)request.when().head();
                break;
            }
            default: {
                Helper.assertTrue("request type not found", false);
            }
        }
        TestLog.logPass("response: " + response.getBody().asString(), new Object[0]);
        return (Response)((ValidatableResponse)response.then()).extract().response();
    }
}

