/*
 * Decompiled with CFR 0.152.
 */
package core.apiCore.interfaces;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import core.apiCore.helpers.DataHelper;
import core.apiCore.helpers.XmlHelper;
import core.helpers.Helper;
import core.support.configReader.Config;
import core.support.logger.TestLog;
import core.support.objects.KeyValue;
import core.support.objects.ServiceObject;
import core.support.objects.TestObject;
import java.util.List;

public class RabbitMqInterface {
    private static final String RABBIT_MQ_HOST = "rabbitMq.host";
    private static final String RABBIT_MQ_VIRTUAL_HOST = "rabbitMq.virtualhost";
    private static final String RABBIT_MQ_USER = "rabbitMq.user";
    private static final String RABBIT_MQ_PASS = "rabbitMq.password";
    public static final String RABBIT_MQ_EXCHANGE = "rabbitMq.exchange";
    public static final String RABBIT_MQ_QUEUE = "rabbitMq.defaultQueue";
    public static Connection connection = null;
    public static Channel channel;

    public static void testRabbitMqInterface(ServiceObject serviceObject) throws Exception {
        RabbitMqInterface.connectRabbitMq(serviceObject);
        RabbitMqInterface.evaluateOption(serviceObject);
        RabbitMqInterface.sendRabbitMqMessage(serviceObject);
    }

    public static synchronized void connectRabbitMq(ServiceObject serviceObject) {
        if (channel == null) {
            try {
                ConnectionFactory factory = new ConnectionFactory();
                factory.setHost(Config.getValue(RABBIT_MQ_HOST));
                factory.setUsername(Config.getValue(RABBIT_MQ_USER));
                factory.setPassword(Config.getValue(RABBIT_MQ_PASS));
                factory.setVirtualHost(Config.getValue(RABBIT_MQ_VIRTUAL_HOST));
                connection = factory.newConnection();
                channel = connection.createChannel();
                Helper.waitForSeconds(1.0);
            }
            catch (Exception e) {
                e.printStackTrace();
                TestLog.ConsoleLog("Connection failed: " + e.getMessage(), new Object[0]);
                throw new RuntimeException("Could not connect. ", e);
            }
        }
    }

    public static void sendRabbitMqMessage(ServiceObject serviceObject) throws Exception {
        String requestBody = DataHelper.replaceParameters(serviceObject.getRequestBody());
        serviceObject.withRequestBody(requestBody);
        requestBody = XmlHelper.getRequestBodyFromXmlTemplate(serviceObject);
        serviceObject.withRequestBody(requestBody);
        RabbitMqInterface.sendMessage(serviceObject);
    }

    public static void sendMessage(ServiceObject serviceObject) {
        TestLog.ConsoleLog("rabbitMq request body: " + serviceObject.getRequestBody(), new Object[0]);
        String exchange = Config.getValue(RABBIT_MQ_EXCHANGE);
        String queueName = Config.getValue(RABBIT_MQ_QUEUE);
        try {
            channel.basicPublish(exchange, queueName, null, serviceObject.getRequestBody().getBytes());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not send message. ", e);
        }
    }

    public static void evaluateOption(ServiceObject serviceObject) {
        RabbitMqInterface.setDefaultQueueAndExchange();
        if (serviceObject.getOption().isEmpty()) {
            return;
        }
        serviceObject.withOption(DataHelper.replaceParameters(serviceObject.getOption()));
        List<KeyValue> keywords = DataHelper.getValidationMap(serviceObject.getOption());
        for (KeyValue keyword : keywords) {
            switch (keyword.key) {
                case "EXCHANGE": {
                    Config.putValue(RABBIT_MQ_EXCHANGE, keyword.value);
                    break;
                }
                case "QUEUE": {
                    Config.putValue(RABBIT_MQ_QUEUE, keyword.value);
                    break;
                }
            }
        }
    }

    private static void setDefaultQueueAndExchange() {
        String defaultExchange = TestObject.getDefaultTestInfo().config.get(RABBIT_MQ_EXCHANGE).toString();
        String defaultQueue = TestObject.getDefaultTestInfo().config.get(RABBIT_MQ_QUEUE).toString();
        Config.putValue(RABBIT_MQ_EXCHANGE, defaultExchange);
        Config.putValue(RABBIT_MQ_QUEUE, defaultQueue);
    }

    public static void closeConnection() {
        try {
            channel.close();
            connection.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

