/*
 * Decompiled with CFR 0.152.
 */
package core.apiCore.interfaces;

import core.apiCore.helpers.DataHelper;
import core.apiCore.helpers.XmlHelper;
import core.support.configReader.Config;
import core.support.logger.TestLog;
import core.support.objects.ServiceObject;
import java.util.Properties;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;

public class KafkaInterface {
    public static final String KAFKA_SERVER_URL = "kafka.server.url";
    public static final String KAFKA_SERVER_PORT = "kafka.server.port";
    public static final String KAFKA_CLIENT_ID = "kafka.client.id";
    public static final String KFAKA_TOPIC = "kafka.topic";
    private static KafkaProducer<byte[], byte[]> producer;

    public static void testRabbitMqInterface(ServiceObject serviceObject) throws Exception {
        KafkaInterface.setupProducer(serviceObject);
        KafkaInterface.sendKafkaMessage(serviceObject);
    }

    public static synchronized void setupProducer(ServiceObject apiObject) {
        Properties properties = new Properties();
        properties.put("bootstrap.servers", Config.getValue(KAFKA_SERVER_URL) + ":" + Config.getValue(KAFKA_SERVER_PORT));
        properties.put("client.id", Config.getValue(KAFKA_CLIENT_ID));
        properties.put("key.serializer", "org.apache.kafka.common.serialization.IntegerSerializer");
        properties.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        properties.put("retries", "3");
        producer = new KafkaProducer(properties);
    }

    public static void sendKafkaMessage(ServiceObject serviceObject) throws Exception {
        String requestBody = DataHelper.replaceParameters(serviceObject.getRequestBody());
        serviceObject.withRequestBody(requestBody);
        requestBody = XmlHelper.getRequestBodyFromXmlTemplate(serviceObject);
        serviceObject.withRequestBody(requestBody);
        KafkaInterface.sendMessage(serviceObject);
    }

    public static void sendMessage(ServiceObject serviceObject) {
        String messageBody = serviceObject.getRequestBody();
        try {
            producer.send(new ProducerRecord(Config.getValue(KFAKA_TOPIC), (Object)messageBody.getBytes())).get();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TestLog.ConsoleLog("Sent message: " + serviceObject.getRequestBody(), new Object[0]);
    }

    public static void closeConnection() {
        producer.close();
    }
}

