/*
 * Decompiled with CFR 0.152.
 */
package core.apiCore.interfaces;

import core.apiCore.helpers.DataHelper;
import core.apiCore.interfaces.RestApiInterface;
import core.helpers.Helper;
import core.support.configReader.Config;
import core.support.logger.TestLog;
import core.support.objects.ServiceObject;
import io.restassured.RestAssured;
import io.restassured.specification.RequestSpecification;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Authentication {
    public static final String BASIC_AUTHORIZATION = "BASIC";
    public static final String AUTHENTICATION_SCHEME = "AUTHENTICATION_SCHEME";

    public static void tokenGenerator(ServiceObject apiObject) {
        if (apiObject == null) {
            Helper.assertFalse("apiobject is null");
        }
        RestApiInterface.setTimeout();
        RestApiInterface.setProxy();
        apiObject.withRequestBody(DataHelper.replaceParameters(apiObject.getRequestBody()));
        Authentication.setURI(apiObject);
        Authentication.evaluateRequest(apiObject);
    }

    public static void setURI(ServiceObject serviceObject) {
        String url = "";
        serviceObject.withUriPath(DataHelper.replaceParameters(serviceObject.getUriPath()));
        serviceObject.withUriPath(Helper.stringRemoveLines(serviceObject.getUriPath()));
        url = serviceObject.getUriPath().startsWith("http") ? serviceObject.getUriPath() : Helper.stringRemoveLines(Config.getValue("api.uriPath")) + serviceObject.getUriPath();
        serviceObject.withUriPath(url);
        URL aURL = Helper.convertToUrl(url);
        TestLog.logPass("request URL: " + aURL.toString(), new Object[0]);
        RestAssured.baseURI = aURL.getProtocol() + "://" + aURL.getHost();
        RestAssured.port = aURL.getPort();
        RestAssured.basePath = aURL.getPath();
    }

    private static RequestSpecification evaluateRequest(ServiceObject apiObject) {
        RequestSpecification request = null;
        request = Authentication.evaluateOption(apiObject, request);
        if (apiObject.getRequestBody().isEmpty()) {
            Helper.assertFalse("no request set");
        }
        Map<String, String> parameterMap = Authentication.getParameters(apiObject);
        TestLog.logPass("authentication type: " + Helper.stringRemoveLines(apiObject.getOption()), new Object[0]);
        switch (apiObject.getOption()) {
            case "BASIC": {
                String username = parameterMap.get("username");
                String password = parameterMap.get("password");
                ArrayList<String> credentials = new ArrayList<String>();
                credentials.add(username);
                credentials.add(password);
                Config.putValue(BASIC_AUTHORIZATION, credentials);
                break;
            }
            case "OAUTH2": {
                String username = parameterMap.get("username");
                String password = parameterMap.get("password");
                String clientId = parameterMap.get("cliendId");
                String clientSecret = parameterMap.get("clientSecret");
                String grantType = parameterMap.get("grantType");
                String scope = parameterMap.get("scope");
                String redirectUri = parameterMap.get("redirectUri");
                request = RestAssured.given().auth().preemptive().basic(clientId, clientSecret).formParam("grant_type", new Object[]{grantType}).formParam("username", new Object[]{username}).formParam("password", new Object[]{password}).formParam("redirect_uri", new Object[]{redirectUri}).formParam("scope", new Object[]{scope});
                break;
            }
            default: {
                Helper.assertFalse("Correct authentication type not set. selected: <" + apiObject.getMethod() + "> Available options: BASIC");
            }
        }
        return request;
    }

    private static Map<String, String> getParameters(ServiceObject apiObject) {
        String[] formData;
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        for (String data : formData = apiObject.getRequestBody().split(",")) {
            String[] keyValue = data.split(":");
            parameterMap.put(keyValue[0].trim(), keyValue[1].trim());
        }
        return parameterMap;
    }

    private static RequestSpecification evaluateOption(ServiceObject apiObject, RequestSpecification request) {
        if (apiObject.getOption().isEmpty()) {
            return request;
        }
        apiObject.withOption(DataHelper.replaceParameters(apiObject.getOption()));
        switch (apiObject.getOption()) {
            default: 
        }
        return request;
    }
}

