/*
 * Decompiled with CFR 0.152.
 */
package core.apiCore.helpers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import core.apiCore.helpers.DataHelper;
import core.helpers.Helper;
import core.support.configReader.Config;
import core.support.logger.TestLog;
import core.support.objects.KeyValue;
import core.support.objects.ServiceObject;
import io.restassured.response.Response;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XML;
import org.skyscreamer.jsonassert.JSONCompare;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.skyscreamer.jsonassert.JSONCompareResult;

public class JsonHelper {
    public static void saveOutboundJsonParameters(Response response, String outputParam) {
        if (response == null || outputParam.isEmpty()) {
            return;
        }
        JsonHelper.configMapJsonKeyValues(response, outputParam);
    }

    public static void configMapJsonKeyValues(Response response, String keyValue) {
        if (keyValue.isEmpty()) {
            return;
        }
        keyValue = DataHelper.replaceParameters(keyValue);
        List<KeyValue> keywords = DataHelper.getValidationMap(keyValue);
        for (KeyValue keyword : keywords) {
            if (!(keyword.value.toString().startsWith("<") && keyword.value.toString().contains("$") && keyword.value.toString().endsWith(">"))) {
                Helper.assertFalse("variable placement must of format <$variable>: " + keyword.value.toString());
            }
            String key = (String)keyword.value;
            key = key.replace("$", "").replace("<", "").replace(">", "").trim();
            String value = JsonHelper.getJsonValue(response, keyword.key);
            if (!keyword.position.isEmpty()) {
                value = value.split(",")[Integer.valueOf(keyword.position) - 1];
            }
            Config.putValue(key, value);
            TestLog.logPass("replacing value " + key + " with: " + value, new Object[0]);
        }
    }

    public static String getJsonValue(Response response, String path) {
        String jsonResponse = response.getBody().asString();
        String value = JsonHelper.getJsonValue(jsonResponse, path);
        return value;
    }

    public static String getJsonValue(String json, String path) {
        String prefix = "$.";
        Object values = null;
        if (path.startsWith(prefix)) {
            path = path.replace(prefix, "");
        }
        Configuration config = Configuration.defaultConfiguration().addOptions(new Option[]{Option.ALWAYS_RETURN_LIST});
        DocumentContext ctx = JsonPath.using((Configuration)config).parse(json);
        try {
            values = ctx.read(prefix + path, new Predicate[0]);
        }
        catch (Exception e) {
            Helper.assertFalse("invalid path: '" + path + "' for json string: " + json + "\n. see http://jsonpath.herokuapp.com to validate your path against json string. see https://github.com/json-path/JsonPath for more info. \n" + e.getMessage());
        }
        if (values == null) {
            Helper.assertFalse("no results returned: '" + path + "'. see http://jsonpath.herokuapp.com to validate your path against json string. see https://github.com/json-path/JsonPath for more info.");
        }
        if (JsonHelper.isValidJsonkeyValue(values)) {
            return values.toString();
        }
        return DataHelper.ObjectToString(values);
    }

    public static String getJsonValueFromXml(String xml, String path) {
        String json = JsonHelper.XMLToJson(xml);
        return JsonHelper.getJsonValue(json, path);
    }

    public static String XMLToJson(String xml) {
        int printIndentFactor = 4;
        String jsonString = "";
        try {
            JSONObject xmlJSONObj = XML.toJSONObject((String)xml);
            jsonString = xmlJSONObj.toString(printIndentFactor);
        }
        catch (JSONException je) {
            je.toString();
        }
        return jsonString;
    }

    public static String getResponseValue(Response response) {
        return response.getBody().asString();
    }

    public static List<String> validateJsonKeywords(List<KeyValue> keywords, String responseString) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        for (KeyValue keyword : keywords) {
            String jsonPath = Helper.removeSurroundingQuotes(keyword.key);
            String expectedValue = Helper.stringRemoveLines((String)keyword.value);
            String command = "";
            String[] expected = expectedValue.split("[\\(\\)]");
            if (expected.length > 1) {
                command = expected[0];
                expectedValue = expected[1];
            } else if (expected.length == 1) {
                command = expectedValue;
                expectedValue = "";
            }
            TestLog.ConsoleLog("command: " + command + "json path: " + jsonPath, new Object[0]);
            String jsonResponse = JsonHelper.getJsonValue(responseString, jsonPath);
            String errorMessage = DataHelper.validateCommand(command, jsonResponse, expectedValue, keyword.position);
            errorMessages.add(errorMessage);
        }
        errorMessages.removeAll(Collections.singleton(""));
        return errorMessages;
    }

    public static boolean isJSONValid(String value, boolean printError) {
        String error = "";
        String expectedJson = Helper.stringNormalize(value);
        if (expectedJson.startsWith("_VERIFY.JSON.PART_") || expectedJson.startsWith("_NOT_EMPTY_") || expectedJson.startsWith("_VERIFY.RESPONSE.BODY_")) {
            return false;
        }
        try {
            new JSONObject(value);
        }
        catch (JSONException ex) {
            try {
                error = ex.getMessage();
                new JSONArray(value);
            }
            catch (JSONException ex1) {
                if (error.isEmpty()) {
                    error = ex1.getMessage();
                }
                if (printError) {
                    TestLog.ConsoleLog("Invalid Json error: " + error, new Object[0]);
                }
                return false;
            }
        }
        return true;
    }

    public static String validateByJsonBody(String expectedJson, String response) {
        if (JsonHelper.isJSONValid(expectedJson = Helper.stringRemoveLines(expectedJson), true)) {
            if (StringUtils.isBlank((String)response)) {
                Helper.assertFalse("response is empty, please re-evaluate your json path");
            }
            TestLog.logPass("expected: " + Helper.stringRemoveLines(expectedJson), new Object[0]);
            try {
                JSONCompareResult result = JSONCompare.compareJSON((String)expectedJson, (String)response, (JSONCompareMode)JSONCompareMode.LENIENT);
                if (result.failed()) {
                    return result.getMessage() + "\nsee http://jsonpath.herokuapp.com to validate your path against json string. see https://github.com/json-path/JsonPath for more info. \n\n expectedJson: " + expectedJson + "\n\n response: " + response + "\n\n";
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public static boolean isValidExpectation(String expectedJson) {
        if (JsonHelper.isJSONValid(expectedJson, false)) {
            return true;
        }
        return (expectedJson = Helper.stringNormalize(expectedJson)).startsWith("_VERIFY.JSON.PART_") || expectedJson.startsWith("_NOT_EMPTY_") || expectedJson.startsWith("_VERIFY.RESPONSE.BODY_");
    }

    public static List<String> validateByKeywords(String expectedJson, Response response) {
        String responseString = JsonHelper.getResponseValue(response);
        return JsonHelper.validateByKeywords(expectedJson, responseString);
    }

    public static List<String> validateByKeywords(String expectedJson, String responseString) {
        List<String> errorMessages = new ArrayList<String>();
        expectedJson = Helper.stringRemoveLines(expectedJson);
        if (!JsonHelper.isJSONValid(expectedJson = Helper.removeSurroundingQuotes(expectedJson), false)) {
            if (expectedJson.startsWith("_VERIFY.JSON.PART_")) {
                List<KeyValue> keywords = DataHelper.getValidationMap(expectedJson);
                errorMessages = JsonHelper.validateJsonKeywords(keywords, responseString);
            } else if (expectedJson.startsWith("_NOT_EMPTY_") && responseString.isEmpty()) {
                errorMessages.add("response is empty");
            }
        }
        return errorMessages;
    }

    public static String validateResponseBody(String expected, Response response) {
        String responseString = JsonHelper.getResponseValue(response);
        return JsonHelper.validateResponseBody(expected, responseString);
    }

    public static String validateResponseBody(String expected, String responseString) {
        if (!expected.startsWith("_VERIFY.RESPONSE.BODY_")) {
            return "";
        }
        expected = JsonHelper.removeResponseIndicator(expected);
        String[] expectedArr = expected.split("[\\(\\)]");
        String expectedValue = "";
        String command = "";
        if (expectedArr.length == 1) {
            command = expected.trim();
        } else {
            command = expectedArr[0].trim();
            expectedValue = expectedArr[1].trim();
        }
        return DataHelper.validateCommand(command, responseString, expectedValue, "0");
    }

    public static String removeResponseIndicator(String expected) {
        ArrayList<String> indicator = new ArrayList<String>();
        indicator.add("_VERIFY.RESPONSE.BODY_");
        indicator.add("_VERIFY.JSON.PART_");
        for (String value : indicator) {
            expected = expected.replace(value, "");
        }
        return expected;
    }

    public static String getRequestBodyFromJsonTemplate(ServiceObject serviceObject) {
        Path templatePath = DataHelper.getTemplateFilePath(serviceObject.getTemplateFile());
        String jsonFileValue = JsonHelper.convertJsonFileToString(templatePath);
        jsonFileValue = DataHelper.replaceParameters(jsonFileValue);
        if (serviceObject.getRequestBody().isEmpty()) {
            return jsonFileValue;
        }
        return JsonHelper.updateJsonFromRequestBody(serviceObject);
    }

    public static String convertJsonFileToString(Path templatePath) {
        return Helper.readFileContent(templatePath.toString());
    }

    public static String updateJsonFromRequestBody(ServiceObject serviceObject) {
        String jsonString = DataHelper.getServiceObjectTemplateString(serviceObject);
        Helper.assertTrue("json string is empty", !jsonString.isEmpty());
        jsonString = DataHelper.replaceParameters(jsonString);
        serviceObject.withRequestBody(DataHelper.replaceParameters(serviceObject.getRequestBody()));
        List<KeyValue> keywords = DataHelper.getValidationMap(serviceObject.getRequestBody());
        for (KeyValue keyword : keywords) {
            jsonString = JsonHelper.replaceJsonPathValue(jsonString, keyword.key, keyword.value.toString());
        }
        return jsonString;
    }

    public static String replaceJsonPathValue(String jsonString, String path, String value) {
        DocumentContext doc = JsonPath.parse((String)jsonString);
        try {
            doc.set("$." + path, (Object)value, new Predicate[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonObject jsonObj = new GsonBuilder().create().toJsonTree(doc.json()).getAsJsonObject();
        return jsonObj.toString();
    }

    public static JSONArray getJsonArray(String jsonString) {
        try {
            return new JSONArray(jsonString);
        }
        catch (JSONException ex) {
            ex.getMessage();
            return null;
        }
    }

    public static JSONObject getJsonObject(String jsonString) {
        try {
            return new JSONObject(jsonString);
        }
        catch (JSONException ex) {
            ex.getMessage();
            return null;
        }
    }

    public static boolean isValidJsonkeyValue(Object jsonObject) {
        String jsonString;
        if (jsonObject instanceof Map) {
            jsonObject = new Gson().toJson(jsonObject, Map.class);
        }
        if (JsonHelper.getJsonArray(jsonString = jsonObject.toString()) == null && JsonHelper.getJsonObject(jsonString) == null) {
            return false;
        }
        String jsonNormalized = DataHelper.ObjectToString(jsonString);
        return jsonNormalized.contains(":");
    }

    public static String updateJsonFromJasonPath(String jsonPath) {
        return jsonPath;
    }
}

