/*
 * Decompiled with CFR 0.152.
 */
package core.apiCore.helpers;

import core.apiCore.helpers.JsonHelper;
import core.helpers.Helper;
import core.support.configReader.Config;
import core.support.configReader.PropertiesReader;
import core.support.logger.TestLog;
import core.support.objects.KeyValue;
import core.support.objects.ServiceObject;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;

public class DataHelper {
    public static final String VERIFY_JSON_PART_INDICATOR = "_VERIFY.JSON.PART_";
    public static final String VERIFY_RESPONSE_BODY_INDICATOR = "_VERIFY.RESPONSE.BODY_";
    public static final String VERIFY_RESPONSE_NO_EMPTY = "_NOT_EMPTY_";

    public static String replaceParameters(String source) {
        if (source.isEmpty()) {
            return source;
        }
        List<String> parameters = Helper.getValuesFromPattern(source, "<@(.+?)>");
        Object val = null;
        int length = 0;
        for (String parameter : parameters) {
            if (parameter.contains("_TIME")) {
                length = Helper.getIntFromString(parameter);
                if (length > 19) {
                    length = 19;
                }
                val = Config.getValue("_startTimeString_").substring(0, length);
            } else if (parameter.contains("_RAND")) {
                length = Helper.getIntFromString(parameter);
                val = Config.getValue("_randomString_").substring(0, length);
            } else {
                val = Config.getObjectValue(parameter);
            }
            if (val == null) {
                TestLog.logWarning("parameter value not found: " + parameter, new Object[0]);
                continue;
            }
            source = source.replace("<@" + parameter + ">", Matcher.quoteReplacement(val.toString()));
        }
        return source;
    }

    public static List<KeyValue> getValidationMap(String expected) {
        ArrayList<KeyValue> keywords = new ArrayList<KeyValue>();
        expected = JsonHelper.removeResponseIndicator(expected);
        String[] keyVals = expected.split(";");
        String key = "";
        String position = "";
        String value = "";
        for (String keyVal : keyVals) {
            List<String> parts = DataHelper.splitRight(keyVal, ":", 3);
            if (parts.size() == 1) {
                key = Helper.stringRemoveLines(parts.get(0));
            }
            if (parts.size() == 2) {
                key = Helper.stringRemoveLines(parts.get(0));
                position = "";
                value = Helper.stringRemoveLines(parts.get(1));
            } else if (parts.size() == 3) {
                key = Helper.stringRemoveLines(parts.get(0));
                position = Helper.stringRemoveLines(parts.get(1));
                value = Helper.stringRemoveLines(parts.get(2));
            }
            if (key.isEmpty()) continue;
            KeyValue keyword = new KeyValue(key, position, value);
            keywords.add(keyword);
        }
        return keywords;
    }

    public static String getTemplateFileLocation(String file) {
        String templatePath = Config.getValue("api.templatePath");
        String templateTestPath = PropertiesReader.getLocalRootPath() + templatePath;
        return templateTestPath + file;
    }

    public static Path getTemplateFilePath(String file) {
        String templatePath = Config.getValue("api.templatePath");
        String templateTestPath = PropertiesReader.getLocalRootPath() + templatePath;
        String fullLocation = templateTestPath + file;
        return new File(fullLocation).toPath();
    }

    public static File getFile(String filename) {
        String templatePath = Config.getValue("api.templatePath");
        String templateTestPath = PropertiesReader.getLocalRootPath() + templatePath;
        File file = new File(templateTestPath + filename);
        return file;
    }

    public static String convertTemplateToString(String templateFilePath) {
        String xml = "";
        try {
            xml = new String(Files.readAllBytes(new File(templateFilePath).toPath()), StandardCharsets.UTF_8);
            System.out.println(xml.length());
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return xml;
    }

    public static String getServiceObjectTemplateString(ServiceObject serviceObject) {
        String path = DataHelper.getTemplateFileLocation(serviceObject.getTemplateFile());
        File file = new File(path);
        return DataHelper.convertTemplateToString(file.getAbsolutePath());
    }

    public static String validateCommand(String command, String responseString, String expectedString) {
        return DataHelper.validateCommand(command, responseString, expectedString, "");
    }

    public static String validateCommand(String command, String responseString, String expectedString, String position) {
        expectedString = Helper.removeSurroundingQuotes(expectedString);
        command = Helper.removeSurroundingQuotes(command);
        responseString = Helper.removeSurroundingQuotes(responseString);
        Object[] expectedArray = expectedString.split(",");
        Object[] actualArray = responseString.split(",");
        Object actualString = "";
        int positionInt = 0;
        if (!position.isEmpty() && Helper.getIntFromString(position) > 0) {
            boolean inBounds;
            positionInt = Helper.getIntFromString(position);
            expectedString = expectedArray[0];
            boolean bl = inBounds = positionInt > 0 && positionInt <= actualArray.length;
            if (!inBounds) {
                Helper.assertFalse("items returned are less than specified. returned: " + actualArray.length + " specified: " + positionInt);
            }
            actualString = actualArray[positionInt - 1];
        }
        if (DataHelper.getCommandFromExpectedString(command).isEmpty()) {
            Helper.assertFalse("Command not set. Options: " + Arrays.asList(JSON_COMMAND.values()) + ". See examples for usage.");
        }
        JSON_COMMAND jsonCommand = JSON_COMMAND.valueOf(command);
        switch (jsonCommand) {
            case hasItems: {
                boolean val = false;
                if (!position.isEmpty() && positionInt > 0) {
                    TestLog.logPass("verifying: " + (String)actualString + " has item " + expectedString, new Object[0]);
                    val = ((String)actualString).contains(expectedString);
                    if (val) break;
                    return (String)actualString + " does not have item " + expectedString;
                }
                if (!position.isEmpty() && positionInt == 0) {
                    val = responseString.contains(expectedString);
                    if (val) break;
                    return responseString + " does not have item " + expectedString;
                }
                TestLog.logPass("verifying: " + Arrays.toString(actualArray) + " has items " + Arrays.toString(expectedArray), new Object[0]);
                val = Arrays.asList(actualArray).containsAll(Arrays.asList(expectedArray));
                if (val) break;
                return Arrays.toString(actualArray) + " does not have items " + Arrays.toString(expectedArray);
            }
            case notHaveItems: {
                boolean val = false;
                if (!position.isEmpty() && positionInt > 0) {
                    TestLog.logPass("verifying: " + (String)actualString + " does not have item " + expectedString, new Object[0]);
                    boolean bl = val = !((String)actualString).contains(expectedString);
                    if (val) break;
                    return (String)actualString + " does have item " + expectedString;
                }
                if (!position.isEmpty() && positionInt == 0) {
                    boolean bl = val = !responseString.contains(expectedString);
                    if (val) break;
                    return responseString + " does not have item " + expectedString;
                }
                TestLog.logPass("verifying: " + Arrays.toString(actualArray) + " does not have items " + Arrays.toString(expectedArray), new Object[0]);
                boolean bl = val = !Arrays.asList(actualArray).containsAll(Arrays.asList(expectedArray));
                if (val) break;
                return Arrays.toString(actualArray) + " does have items " + Arrays.toString(expectedArray);
            }
            case notEqualTo: {
                boolean val;
                if (!position.isEmpty() && positionInt > 0) {
                    boolean val2;
                    TestLog.logPass("verifying: " + (String)actualString + " not equals " + expectedString, new Object[0]);
                    boolean bl = val2 = !((String)actualString).equals(expectedString);
                    if (val2) break;
                    return (String)actualString + " does equal " + expectedString;
                }
                if (!position.isEmpty() && positionInt == 0) {
                    boolean val3;
                    boolean bl = val3 = !responseString.equals(expectedString);
                    if (val3) break;
                    return responseString + " does equal " + expectedString;
                }
                TestLog.logPass("verifying: " + Arrays.toString(actualArray) + " not equals " + Arrays.toString(expectedArray), new Object[0]);
                boolean bl = val = !Arrays.equals(expectedArray, actualArray);
                if (val) break;
                return Arrays.toString(actualArray) + " does equal " + Arrays.toString(expectedArray);
            }
            case equalTo: {
                if (!position.isEmpty() && positionInt > 0) {
                    TestLog.logPass("verifying: " + (String)actualString + " equals " + expectedString, new Object[0]);
                    boolean val = ((String)actualString).equals(expectedString);
                    if (val) break;
                    return (String)actualString + " does not equal " + expectedString;
                }
                if (!position.isEmpty() && positionInt == 0) {
                    boolean val = responseString.equals(expectedString);
                    if (val) break;
                    return responseString + " does not equal " + expectedString;
                }
                TestLog.logPass("verifying: " + Arrays.toString(actualArray) + " equals " + Arrays.toString(expectedArray), new Object[0]);
                boolean val = Arrays.equals(expectedArray, actualArray);
                if (val) break;
                return Arrays.toString(actualArray) + " does not equal " + Arrays.toString(expectedArray);
            }
            case notContain: {
                boolean val;
                if (!position.isEmpty() && positionInt > 0) {
                    boolean val4;
                    TestLog.logPass("verifying: " + (String)actualString + " does not contain " + expectedString, new Object[0]);
                    boolean bl = val4 = !((String)actualString).contains(expectedString);
                    if (val4) break;
                    return (String)actualString + " does contain " + expectedString;
                }
                if (!position.isEmpty() && positionInt == 0) {
                    boolean val5;
                    boolean bl = val5 = !responseString.contains(expectedString);
                    if (val5) break;
                    return responseString + " does contain " + expectedString;
                }
                TestLog.logPass("verifying: " + Arrays.toString(actualArray) + " does not contain " + Arrays.toString(expectedArray), new Object[0]);
                boolean bl = val = !Arrays.asList(actualArray).containsAll(Arrays.asList(expectedArray));
                if (val) break;
                return Arrays.toString(actualArray) + " does not contain " + Arrays.toString(expectedArray);
            }
            case contains: {
                if (!position.isEmpty() && positionInt > 0) {
                    TestLog.logPass("verifying: " + (String)actualString + " contains " + expectedString, new Object[0]);
                    boolean val = ((String)actualString).contains(expectedString);
                    if (val) break;
                    return (String)actualString + " does not contain " + expectedString;
                }
                if (!position.isEmpty() && positionInt == 0) {
                    boolean val = responseString.contains(expectedString);
                    if (val) break;
                    return responseString + " does not contain " + expectedString;
                }
                TestLog.logPass("verifying: " + Arrays.toString(actualArray) + " contains " + Arrays.toString(expectedArray), new Object[0]);
                boolean val = Arrays.asList(actualArray).containsAll(Arrays.asList(expectedArray));
                if (val) break;
                return Arrays.toString(actualArray) + " does not contain " + Arrays.toString(expectedArray);
            }
            case containsInAnyOrder: {
                TestLog.logPass("verifying: " + Arrays.toString(actualArray) + " contains any order " + Arrays.toString(expectedArray), new Object[0]);
                boolean val = Arrays.asList(actualArray).containsAll(Arrays.asList(expectedArray));
                if (val) break;
                return Arrays.toString(actualArray) + " does not contain in any order " + Arrays.toString(expectedArray);
            }
            case integerGreaterThan: {
                boolean val = DataHelper.compareNumbers(responseString, expectedString, "greaterThan");
                if (val) break;
                return "actual: " + responseString + " is is less than expected: " + expectedString;
            }
            case integerLessThan: {
                boolean val = DataHelper.compareNumbers(responseString, expectedString, "lessThan");
                if (val) break;
                return "actual: " + responseString + " is is greater than expected: " + expectedString;
            }
            case integerEqual: {
                boolean val = DataHelper.compareNumbers(responseString, expectedString, "equalTo");
                if (val) break;
                return "actual: " + responseString + " is not equal to expected: " + expectedString;
            }
            case integerNotEqual: {
                boolean val;
                boolean bl = val = !DataHelper.compareNumbers(responseString, expectedString, "equalTo");
                if (val) break;
                return "actual: " + responseString + " is not equal to expected: " + expectedString;
            }
            case nodeSizeGreaterThan: {
                int intValue = Integer.valueOf(expectedString);
                TestLog.logPass("verifying node with size " + actualArray.length + " greater than " + intValue, new Object[0]);
                if (intValue < actualArray.length) break;
                return "response node size is: " + actualArray.length + " expected it to be greated than: " + intValue;
            }
            case nodeSizeLessThan: {
                int intValue = Integer.valueOf(expectedString);
                TestLog.logPass("verifying node with size " + actualArray.length + " less than " + intValue, new Object[0]);
                if (intValue >= actualArray.length) break;
                return "response node size is: " + actualArray.length + " expected it to be greated than: " + intValue;
            }
            case nodeSizeExact: {
                int intValue = Integer.valueOf(expectedString);
                TestLog.logPass("verifying node with size " + actualArray.length + " equals " + intValue, new Object[0]);
                if (actualArray.length == intValue) break;
                return "response node size is: " + actualArray.length + " expected: " + intValue;
            }
            case sequence: {
                TestLog.logPass("verifying: " + Arrays.toString(actualArray) + " with sequence " + Arrays.toString(expectedArray), new Object[0]);
                boolean val = Arrays.equals(expectedArray, actualArray);
                if (val) break;
                return Arrays.toString(actualArray) + " does not equal " + Arrays.toString(expectedArray);
            }
            case jsonbody: {
                TestLog.logPass("verifying response: \n" + responseString + "\n against expected: \n" + expectedString, new Object[0]);
                String error = JsonHelper.validateByJsonBody(expectedString, responseString);
                if (error.isEmpty()) break;
                return error;
            }
            case isNotEmpty: {
                TestLog.logPass("verifying response for path is not empty", new Object[0]);
                if (!DataHelper.isEmpty(responseString)) break;
                return "value is empty";
            }
            case isEmpty: {
                TestLog.logPass("verifying response for path is empty ", new Object[0]);
                if (DataHelper.isEmpty(responseString)) break;
                return "value is not empty";
            }
            default: {
                Helper.assertFalse("Command not set. Options: " + Arrays.asList(JSON_COMMAND.values()) + ". See examples for usage.");
            }
        }
        return "";
    }

    public static boolean isGreaterThan(String value1, String value2) {
        return Helper.isNumeric(value1) && Helper.isNumeric(value2) && Integer.valueOf(value1) > Integer.valueOf(value2);
    }

    public static boolean isLessThan(String value1, String value2) {
        return Helper.isNumeric(value1) && Helper.isNumeric(value2) && Integer.valueOf(value1) < Integer.valueOf(value2);
    }

    public static boolean compareNumbers(String value1, String value2, String comparator) {
        if (!Helper.isStringContainNumber(value1) || !Helper.isStringContainNumber(value2)) {
            return false;
        }
        double val1Double = Helper.getDoubleFromString(value1);
        double val2Double = Helper.getDoubleFromString(value2);
        return DataHelper.compareNumbers(val1Double, val2Double, comparator);
    }

    public static boolean compareNumbers(double value1, double value2, String comparator) {
        switch (comparator) {
            case "greaterThan": {
                if (!(value1 > value2)) break;
                return true;
            }
            case "lessThan": {
                if (!(value1 < value2)) break;
                return true;
            }
            case "equalTo": {
                if (value1 != value2) break;
                return true;
            }
        }
        return false;
    }

    public static String listToString(List<String> values) {
        return StringUtils.join(values, (String)",");
    }

    public static String ObjectToString(Object values) {
        String stringVal = values.toString();
        stringVal = stringVal.replaceAll("[\\[\\](){}]", "");
        stringVal = stringVal.replace("\"", "");
        return stringVal;
    }

    public static List<String> splitRight(String value, String regex, int limit) {
        String commandValue = DataHelper.getCommandFromExpectedString(value);
        if (!commandValue.isEmpty()) {
            return DataHelper.getJsonKeyValue(value, commandValue);
        }
        String string = value;
        ArrayList<String> result = new ArrayList<String>();
        String[] temp = new String[]{};
        for (int i = 1; i < limit; ++i) {
            if (!string.matches(".*" + regex + ".*")) continue;
            temp = string.split(DataHelper.modifyRegex(regex));
            result.add(temp[1]);
            string = temp[0];
        }
        if (temp.length > 0) {
            result.add(temp[0]);
        }
        if (value.split(":").length == 1) {
            result.add(string);
        }
        Collections.reverse(result);
        return result;
    }

    private static String getCommandFromExpectedString(String value) {
        String commandValue = "";
        for (JSON_COMMAND command : JSON_COMMAND.values()) {
            List<String> parameters = Helper.getValuesFromPattern(value, (Object)((Object)command) + "\\(([^)]+)\\)");
            if (!parameters.isEmpty()) {
                commandValue = (Object)((Object)command) + "(" + parameters.get(0) + ")";
                if (!value.endsWith(commandValue)) continue;
                return commandValue;
            }
            if (!value.endsWith(command.name())) continue;
            return command.name();
        }
        return "";
    }

    private static List<String> getJsonKeyValue(String value, String commandValue) {
        ArrayList<String> result = new ArrayList<String>();
        String keyPosition = (value = value.replace(commandValue, "")).trim().replaceAll(":$", "");
        List<String> keyPositionList = DataHelper.splitRight(keyPosition, ":", 2);
        if (keyPositionList.size() == 2 && Helper.isStringContainOnlyNumber(keyPositionList.get(1))) {
            result.add(keyPositionList.get(0));
            result.add(keyPositionList.get(1));
        } else {
            result.add(keyPosition);
        }
        result.add(commandValue);
        return result;
    }

    private static String modifyRegex(String regex) {
        return regex + "(?!.*" + regex + ".*$)";
    }

    public static boolean isEmpty(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return true;
        }
        return value.equals("null");
    }

    static enum JSON_COMMAND {
        hasItems,
        notHaveItems,
        notEqualTo,
        equalTo,
        notContain,
        contains,
        containsInAnyOrder,
        integerGreaterThan,
        integerLessThan,
        integerEqual,
        integerNotEqual,
        nodeSizeGreaterThan,
        nodeSizeExact,
        sequence,
        jsonbody,
        isNotEmpty,
        isEmpty,
        nodeSizeLessThan;

    }
}

