/*
 * Decompiled with CFR 0.152.
 */
package core.apiCore.helpers;

import com.opencsv.CSVReader;
import core.apiCore.TestDataProvider;
import core.apiCore.helpers.DataHelper;
import core.helpers.Helper;
import core.support.configReader.Config;
import core.support.configReader.PropertiesReader;
import core.support.objects.KeyValue;
import core.support.objects.ServiceObject;
import core.support.objects.TestObject;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.IntStream;
import org.apache.commons.lang3.ArrayUtils;

public class CsvReader {
    public static int SERVICE_CSV_COLUMN_COUNT = 19;
    public static String SERVICE_CSV_FILE_PREFIX = "TestCases_";
    public static final String ACTION_KEY = "action";

    public static synchronized List<Object[]> getTestCasesFromCsvFile() {
        int index = CsvReader.getCurrentTestInvocation();
        String testCaseFile = Config.getValue("api.testCaseFile");
        if (!testCaseFile.isEmpty()) {
            index = CsvReader.getCsvFileIndex(testCaseFile);
        }
        String csvFileName = CsvReader.getCsvFileFromIndex(index);
        List<String[]> csvList = CsvReader.getCsvTestListForTestRunner(csvFileName);
        ArrayList<String[]> updatedCsvList = new ArrayList<String[]>();
        updatedCsvList.addAll(CsvReader.addActionCsvTests(csvList));
        return CsvReader.updateCsvFileFromFile(updatedCsvList, csvFileName, testCaseFile);
    }

    public static List<Object[]> updateCsvFileFromFile(List<String[]> csvList, String csvFileName, String testCaseFile) {
        ArrayList<Object[]> testCases = new ArrayList<Object[]>();
        for (int i = 0; i < csvList.size(); ++i) {
            Object[] obj = new String[]{csvFileName, String.valueOf(i) + ":" + String.valueOf(csvList.size()), TestObject.testType.service.name()};
            String[] csvRow = (String[])ArrayUtils.addAll((Object[])csvList.get(i), (Object[])obj);
            String testCase = Config.getValue("api.testCase");
            if (testCaseFile.isEmpty() || testCase.isEmpty()) {
                testCases.add(csvRow);
                continue;
            }
            if (!csvRow[1].equals(testCase)) continue;
            testCases.add(csvRow);
            return testCases;
        }
        return testCases;
    }

    public static List<String[]> addActionCsvTests(List<String[]> csvList) {
        String csvTestPath = PropertiesReader.getLocalRootPath() + Config.getValue("api.actionTestcasePath");
        ArrayList<String[]> updateDataList = new ArrayList<String[]>();
        boolean hasActionKey = false;
        for (Object[] objectArray : csvList) {
            hasActionKey = false;
            ServiceObject serviceObject = CsvReader.mapToServiceObject(objectArray);
            List<KeyValue> keywords = DataHelper.getValidationMap(serviceObject.getMethod());
            String runFlag = serviceObject.getRunFlag();
            if (!runFlag.equals("Y")) break;
            for (KeyValue keyword : keywords) {
                if (!keyword.key.equals(ACTION_KEY)) continue;
                List<String[]> tests = CsvReader.getCsvTestListForTestRunner(csvTestPath, keyword.value.toString());
                updateDataList.addAll(tests);
                hasActionKey = true;
            }
            if (hasActionKey) continue;
            updateDataList.add((String[])objectArray);
        }
        return updateDataList;
    }

    public static Map<String, ServiceObject> mapToApiObject(List<String[]> testCases) {
        ConcurrentHashMap<String, ServiceObject> serviceMap = new ConcurrentHashMap<String, ServiceObject>();
        for (Object[] objectArray : testCases) {
            ServiceObject ServiceObject2 = CsvReader.mapToServiceObject(objectArray);
            serviceMap.put(ServiceObject2.getTestCaseID(), ServiceObject2);
        }
        return serviceMap;
    }

    public static ServiceObject mapToServiceObject(Object[] testData) {
        return new ServiceObject().setServiceObject(testData);
    }

    public static void getAllTestCases(String testPath, String prefix) {
        ArrayList<File> csvFiles = Helper.getFileListByType(testPath, prefix);
        for (int i = 0; i < csvFiles.size(); ++i) {
            List<String[]> testCases = CsvReader.getCsvTestList(csvFiles.get(i));
            Map<String, ServiceObject> apiMap = CsvReader.mapToApiObject(testCases);
            TestObject.getTestInfo().apiMap.putAll(apiMap);
        }
    }

    public static synchronized void getAllKeywords() {
        String testFolderPath = Config.getValue("api.keywordPath");
        String csvTestPath = PropertiesReader.getLocalRootPath() + testFolderPath;
        CsvReader.getAllTestCases(csvTestPath, ".csv");
    }

    public static int getCurrentTestInvocation() {
        if (CsvReader.isRunningServiceTest()) {
            String activeTest = TestObject.getTestInfo().testCsvFileName;
            return CsvReader.getCsvFileIndex(activeTest);
        }
        return TestDataProvider.csvFileIndex.getAndIncrement();
    }

    public static boolean isRunningServiceTest() {
        return !TestObject.getTestInfo().testCsvFileName.isEmpty();
    }

    public static String getCsvFileFromIndex(int index) {
        ArrayList<File> testCsvList = CsvReader.getTestDataCsvFileList();
        Helper.assertTrue("test not found at index: " + index, testCsvList.size() > index);
        return testCsvList.get(index).getName();
    }

    public static int getCsvFileCount() {
        return CsvReader.getTestDataCsvFileList().size();
    }

    public static ArrayList<File> getTestDataCsvFileList() {
        String csvTestPath = PropertiesReader.getLocalRootPath() + Config.getValue("api.parallelTestcasePath");
        return CsvReader.getCsvFileList(csvTestPath);
    }

    public static ArrayList<File> getCsvFileList(String csvTestPath) {
        ArrayList<File> csvFiles = Helper.getFileListByType(csvTestPath, ".csv");
        return csvFiles;
    }

    public static int getCsvFileIndex(String fileName) {
        String csvTestPath = PropertiesReader.getLocalRootPath() + Config.getValue("api.parallelTestcasePath");
        return CsvReader.getCsvFileIndex(csvTestPath, fileName);
    }

    public static int getCsvFileIndex(String csvDir, String fileName) {
        Helper.assertTrue("csv file is null", fileName != null);
        ArrayList<File> csvFiles = CsvReader.getCsvFileList(csvDir);
        OptionalInt indexOpt = IntStream.range(0, csvFiles.size()).filter(i -> fileName.contains(((File)csvFiles.get(i)).getName())).findFirst();
        Helper.assertTrue("csv file: " + fileName + " not found", indexOpt.isPresent());
        return indexOpt.getAsInt();
    }

    public static List<String[]> getCsvTestListForTestRunner(String csvFile) {
        String csvTestPath = PropertiesReader.getLocalRootPath() + Config.getValue("api.parallelTestcasePath");
        return CsvReader.getCsvTestListForTestRunner(csvTestPath, csvFile);
    }

    public static List<String[]> getCsvTestListForTestRunner(String csvDir, String csvFile) {
        ArrayList<String[]> csvList = new ArrayList();
        ArrayList<File> testCsvFileList = CsvReader.getCsvFileList(csvDir);
        int fileIndex = CsvReader.getFileIndex(testCsvFileList, csvFile);
        if (fileIndex == -1) {
            Helper.assertFalse("csv file not found. csv file: " + csvFile + " at location: " + csvDir);
        }
        csvList = CsvReader.getCsvTestList(testCsvFileList.get(fileIndex));
        return csvList;
    }

    public static List<String[]> getCsvTestList(File file) {
        ArrayList<String[]> csvList = new ArrayList<String[]>();
        try {
            String[] line;
            CSVReader reader = new CSVReader((Reader)new FileReader(file.getPath()));
            String[] header = reader.readNext();
            int runFlag = CsvReader.getColumnIndexByName("RunFlag", header);
            int testCaseID = CsvReader.getColumnIndexByName("TestCaseID", header);
            while ((line = reader.readNext()) != null) {
                if (!line[runFlag].equals("Y") || line[testCaseID].isEmpty()) continue;
                csvList.add(line);
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return csvList;
    }

    public static int getFileIndex(ArrayList<File> testCsvFileList, String csvFile) {
        for (int i = 0; i < testCsvFileList.size(); ++i) {
            if (!testCsvFileList.get(i).getName().equals(csvFile)) continue;
            return i;
        }
        return -1;
    }

    public static int getColumnIndexByName(String column, String[] row) {
        for (int i = 0; i < row.length; ++i) {
            if (!row[i].equals(column)) continue;
            return i;
        }
        Helper.assertTrue("column not found", false);
        return -1;
    }

    public static int getCsvTestcount() {
        return CsvReader.getCsvTestListForTestRunner(TestObject.getTestInfo().testCsvFileName).size();
    }

    public static boolean isValidTestFileType(String filename) {
        for (VALID_TEST_FILE_TYPES types : VALID_TEST_FILE_TYPES.values()) {
            if (!filename.endsWith(types.name())) continue;
            return true;
        }
        return false;
    }

    static enum VALID_TEST_FILE_TYPES {
        csv;

    }
}

