/*
 * Decompiled with CFR 0.152.
 */
package core.apiCore;

import core.apiCore.driver.ApiTestDriver;
import core.apiCore.helpers.CsvReader;
import core.apiCore.helpers.DataHelper;
import core.apiCore.interfaces.Authentication;
import core.apiCore.interfaces.AzureInterface;
import core.apiCore.interfaces.RabbitMqInterface;
import core.apiCore.interfaces.RestApiInterface;
import core.apiCore.interfaces.SqlInterface;
import core.apiCore.interfaces.TestPrepare;
import core.helpers.Helper;
import core.support.configReader.Config;
import core.support.configReader.PropertiesReader;
import core.support.objects.DriverObject;
import core.support.objects.KeyValue;
import core.support.objects.ServiceObject;
import core.support.objects.TestObject;
import core.uiCore.driverProperties.driverType;
import core.uiCore.drivers.AbstractDriverTestNG;
import java.io.File;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ServiceManager {
    private static final String TOKEN_GENERATOR = "Authentication";
    public static final String SERVICE_TEST_RUNNER_ID = "ServiceTestRunner";
    private static final String RESTFULL_API_INTERFACE = "RESTfulAPI";
    private static final String SQL_DB_INTERFACE = "SQLDB";
    private static final String AZURE_INTERFACE = "AZURE";
    private static final String RABBIT_MQ_INTERFACE = "RABBITMQ";
    private static final String TEST_PREPARE_INTERFACE = "TestPrepare";
    public static final String EXTERNAL_INTERFACE = "EXTERNAL";
    public static final String TEST_BASE_PATH = "api.base.path";
    public static final String TEST_BASE_BEFORE_CLASS = "api.base.before.testfile";
    public static final String TEST_BASE_AFTER_CLASS = "api.base.after.testfile";
    public static final String TEST_BASE_BEFORE_SUITE = "api.base.before.suite";
    public static final String TEST_BASE_AFTER_SUITE = "api.base.after.suite";
    private static final String BEFORE_CLASS_DIR = "beforeClass";
    private static final String AFTER_CLASS_DIR = "afterClass";
    private static final String BEFORE_SUITE_DIR = "beforeSuite";
    private static final String AFTER_SUITE_DIR = "afterSuite";
    public static final String IS_BASE_BEFORE_CLASS_COMPLETE = "api.base.before.isComplete";
    public static final String IS_BASE_AFTER_CLASS_COMPLETE = "api.base.after.isComplete";
    public static final String BEFORE_CSV_FILE = "beforeCsvFile";
    public static final String AFTER_CSV_FILE = "afterCsvFile";

    public static void TestRunner(ServiceObject serviceObject) {
        try {
            new AbstractDriverTestNG().setupApiDriver(serviceObject);
            ServiceManager.runInterface(serviceObject);
        }
        catch (Exception e) {
            Helper.assertFalse(e.getMessage());
        }
    }

    public static void runInterface(ServiceObject serviceObject) {
        try {
            ServiceManager.runCsvInterface(serviceObject);
        }
        catch (Exception e) {
            Helper.assertFalse(e.getMessage());
        }
    }

    public static void runCsvInterface(ServiceObject serviceObject) throws Exception {
        switch (serviceObject.getInterfaceType()) {
            case "Authentication": {
                Authentication.tokenGenerator(serviceObject);
                break;
            }
            case "RESTfulAPI": {
                RestApiInterface.RestfullApiInterface(serviceObject);
                break;
            }
            case "SQLDB": {
                SqlInterface.DataBaseInterface(serviceObject);
                break;
            }
            case "AZURE": {
                AzureInterface.AzureClientInterface(serviceObject);
                break;
            }
            case "RABBITMQ": {
                RabbitMqInterface.testRabbitMqInterface(serviceObject);
                break;
            }
            case "TestPrepare": {
                TestPrepare.TestPrepareInterface(serviceObject);
                break;
            }
            case "EXTERNAL": {
                break;
            }
            default: {
                Helper.assertFalse("no interface found: " + serviceObject.getInterfaceType() + ". Options:Authentication, RESTfulAPI, SQLDB, RABBITMQ");
            }
        }
    }

    public static void runBeforeCsv(ServiceObject serviceObject) throws Exception {
        boolean isBeforeCsvComplete = Config.getParentValue(IS_BASE_BEFORE_CLASS_COMPLETE);
        if (isBeforeCsvComplete) {
            return;
        }
        String csvTestPath = PropertiesReader.getLocalRootPath() + Config.getValue(TEST_BASE_PATH) + BEFORE_CLASS_DIR + File.separator;
        String beforeCsvFile = Config.getValue(TEST_BASE_BEFORE_CLASS);
        if (StringUtils.isBlank((CharSequence)beforeCsvFile)) {
            return;
        }
        String beforeTestName = ApiTestDriver.getTestClass(serviceObject) + TestObject.BEFORE_TEST_FILE_PREFIX + "-" + ApiTestDriver.getTestClass(beforeCsvFile);
        ServiceManager.runServiceTestFileWithoutDataProvider(csvTestPath, beforeCsvFile, beforeTestName, serviceObject.getParent());
        Config.setParentValue(IS_BASE_BEFORE_CLASS_COMPLETE, true);
    }

    public static void setTestBaseOverride(ServiceObject serviceObject) {
        if (!serviceObject.getInterfaceType().equals(EXTERNAL_INTERFACE)) {
            return;
        }
        List<KeyValue> keywords = DataHelper.getValidationMap(serviceObject.getMethod());
        for (KeyValue keyword : keywords) {
            if (!CsvReader.isValidTestFileType(keyword.value.toString())) {
                keyword.value = "";
            }
            switch (keyword.key) {
                case "beforeCsvFile": {
                    Config.putValue(TEST_BASE_BEFORE_CLASS, keyword.value.toString());
                    break;
                }
                case "afterCsvFile": {
                    Config.putValue(TEST_BASE_AFTER_CLASS, keyword.value.toString());
                    break;
                }
            }
        }
    }

    public static void runAfterCsv(ServiceObject serviceObject) throws Exception {
        boolean isAfterCsvComplete = Config.getParentValue(IS_BASE_AFTER_CLASS_COMPLETE);
        boolean isCsvTestComplete = ApiTestDriver.isCsvTestComplete(serviceObject);
        if (!isCsvTestComplete || isAfterCsvComplete) {
            return;
        }
        Config.setParentValue(IS_BASE_AFTER_CLASS_COMPLETE, true);
        String csvTestPath = PropertiesReader.getLocalRootPath() + Config.getValue(TEST_BASE_PATH) + AFTER_CLASS_DIR + File.separator;
        String afterCsvFile = Config.getValue(TEST_BASE_AFTER_CLASS);
        if (StringUtils.isBlank((CharSequence)afterCsvFile)) {
            return;
        }
        String afterTestName = ApiTestDriver.getTestClass(serviceObject) + TestObject.AFTER_TEST_FILE_PREFIX + "-" + ApiTestDriver.getTestClass(afterCsvFile);
        ServiceManager.runServiceTestFileWithoutDataProvider(csvTestPath, afterCsvFile, afterTestName, serviceObject.getParent());
    }

    public static void runServiceBeforeSuite() {
        String csvTestPath = PropertiesReader.getLocalRootPath() + Config.getValue(TEST_BASE_PATH) + BEFORE_SUITE_DIR + File.separator;
        String beforeSuiteFile = Config.getValue(TEST_BASE_BEFORE_SUITE);
        if (StringUtils.isBlank((CharSequence)beforeSuiteFile)) {
            return;
        }
        String beforeSuiteName = TestObject.SUITE_NAME + TestObject.BEFORE_SUITE_PREFIX + "-" + ApiTestDriver.getTestClass(beforeSuiteFile);
        ServiceManager.runServiceTestFileWithoutDataProvider(csvTestPath, beforeSuiteFile, beforeSuiteName, "");
    }

    public static void runServiceAfterSuite() {
        String csvTestPath = PropertiesReader.getLocalRootPath() + Config.getValue(TEST_BASE_PATH) + AFTER_SUITE_DIR + File.separator;
        String afterSuiteFile = Config.getValue(TEST_BASE_AFTER_SUITE);
        if (StringUtils.isBlank((CharSequence)afterSuiteFile)) {
            return;
        }
        String afterSuiteName = TestObject.SUITE_NAME + TestObject.AFTER_SUITE_PREFIX + "-" + ApiTestDriver.getTestClass(afterSuiteFile);
        ServiceManager.runServiceTestFileWithoutDataProvider(csvTestPath, afterSuiteFile, afterSuiteName, "");
    }

    public static void runServiceTestFileWithoutDataProvider(String csvTestPath, String file, String testname, String parent) {
        String updateName = testname;
        List<String[]> testList = CsvReader.getCsvTestListForTestRunner(csvTestPath, file);
        List<Object[]> updateList = CsvReader.updateCsvFileFromFile(testList, updateName, "");
        for (Object[] dataRow : updateList) {
            ServiceObject testServiceObject = CsvReader.mapToServiceObject(dataRow);
            testServiceObject.withParent(parent);
            ServiceManager.TestRunner(testServiceObject);
        }
    }

    public static void setupParentObject(ServiceObject serviceObject) {
        String csvFileName = ApiTestDriver.getTestClass(serviceObject);
        String parent = csvFileName + TestObject.PARENT_PREFIX;
        serviceObject.withParent(parent);
        DriverObject driver = new DriverObject().withDriverType(driverType.DriverType.API);
        new AbstractDriverTestNG().setupWebDriver(serviceObject.getParent(), driver);
        TestObject.getTestInfo().serviceObject = serviceObject;
    }
}

