/*
 * Decompiled with CFR 0.152.
 */
package core.uiCore.webElement;

import core.helpers.Element;
import core.helpers.Helper;
import core.support.logger.TestLog;
import core.uiCore.drivers.AbstractDriver;
import core.uiCore.webElement.ElementObject;
import core.uiCore.webElement.EnhancedBy;
import core.uiCore.webElement.EnhancedWebElement;
import io.appium.java_client.MobileElement;
import io.appium.java_client.PerformsTouchActions;
import io.appium.java_client.TouchAction;
import io.appium.java_client.touch.offset.PointOption;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;

public class ImpEnhancedWebElement
implements EnhancedWebElement {
    private final String elementName;
    private final EnhancedBy element;
    private By by;
    private final WebDriver webDriver;
    private final EnhancedBy parent;
    private final int parentIndex;
    private List<WebElement> parentElements;
    private List<WebElement> current;
    public Element.LocatorType locatorType;

    public ImpEnhancedWebElement(EnhancedBy parent, int parentIndex, WebDriver webDriver, EnhancedBy element) {
        this.elementName = element.name;
        this.element = element;
        this.webDriver = webDriver;
        this.parent = parent;
        this.parentIndex = parentIndex;
        this.current = null;
        this.parentElements = new ArrayList<WebElement>();
    }

    @Override
    public EnhancedWebElement findElement(EnhancedBy parentElement, int parentIndex, EnhancedBy element) {
        return new ImpEnhancedWebElement(parentElement, parentIndex, this.webDriver, element);
    }

    public void clear() {
        this.clear(0);
    }

    @Override
    public void clear(int index) {
        int retry = 1;
        boolean success = false;
        do {
            --retry;
            try {
                this.isDisplayed(index);
                if (!this.isExist(new int[0])) continue;
                this.scrollToView_Web(index);
                WebElement element = this.getElement(index);
                element.clear();
                success = true;
            }
            catch (Exception e) {
                this.resetElement();
                e.getMessage();
            }
        } while (!success && retry > 0);
    }

    public String getCssValue(String arg0) {
        return this.getCssValue(arg0, 0);
    }

    @Override
    public String getCssValue(String arg0, int index) {
        WebElement element = this.getElement(index);
        return element.getCssValue(arg0);
    }

    public Point getLocation() {
        return this.getLocation(0);
    }

    @Override
    public Point getLocation(int index) {
        WebElement element = this.getElement(index);
        return element.getLocation();
    }

    public Dimension getSize() {
        return this.getSize(0);
    }

    public Dimension getSize(int index) {
        TestLog.ConsoleLog("getSize: " + this.elementName, new Object[0]);
        WebElement element = this.getElement(index);
        return element.getSize();
    }

    @Override
    public int count() {
        if (this.isExist(new int[0])) {
            List<WebElement> elements = this.getElements();
            return elements.size();
        }
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return this.count() == 0;
    }

    public String getTagName() {
        return this.getTagName(0);
    }

    public String getTagName(int index) {
        WebElement element = this.getElement(index);
        return element.getTagName();
    }

    public boolean isDisplayed() {
        return this.isDisplayed(0);
    }

    @Override
    public boolean isDisplayed(int index) {
        WebElement element = this.getElement(index);
        return element.isDisplayed();
    }

    public boolean isEnabled() {
        return this.isEnabled(0);
    }

    @Override
    public boolean isEnabled(int index) {
        WebElement element = this.getElement(index);
        return element.isEnabled();
    }

    public void submit() {
        this.submit(0);
    }

    public void submit(int index) {
        WebElement element = this.getElement(index);
        element.submit();
    }

    @Override
    public void click() {
        this.click(0);
    }

    @Override
    public void click(int index) {
        int retry = 3;
        ArrayList<String> exception = new ArrayList<String>();
        boolean success = false;
        do {
            --retry;
            try {
                this.scrollToView(index);
                if (!this.isExist(new int[0])) continue;
                Helper.highLightWebElement(this.element, index);
                WebElement toClick = this.getElement(index);
                toClick.click();
                success = true;
            }
            catch (Exception e) {
                this.resetElement();
                String message = e.getLocalizedMessage();
                String rootCause = message.substring(0, message.indexOf("\n"));
                exception.add(rootCause);
                TestLog.ConsoleLog("click failed for element: " + this.elementName + ": " + rootCause, new Object[0]);
            }
        } while (!success && retry > 0);
    }

    @Override
    public void scrollToView() {
        this.scrollToView(0);
    }

    @Override
    public void scrollToView(int index) {
        if (this.isExist(index)) {
            this.scrollToView_Web(index);
        }
    }

    public void mobileScroll(int index) {
        if (Helper.mobile_isMobile()) {
            for (int scrollCount = 5; !this.isExist(new int[0]) && scrollCount > 0; --scrollCount) {
                Helper.scrollDown();
                Helper.refreshMobileApp();
            }
        }
    }

    public void scrollTo_mobile(int index) {
        if (Helper.mobile.isAndroid()) {
            this.webDriver.manage().timeouts().implicitlyWait(1L, TimeUnit.MILLISECONDS);
            WebElement element = this.getElement(index);
            int x = element.getLocation().getX();
            int y = element.getLocation().getY();
            TouchAction action = new TouchAction((PerformsTouchActions)Helper.mobile.getAndroidDriver());
            action.press(PointOption.point((int)x, (int)y)).moveTo(PointOption.point((int)(x + 90), (int)y)).release().perform();
            this.webDriver.manage().timeouts().implicitlyWait((long)AbstractDriver.TIMEOUT_IMPLICIT_SECONDS, TimeUnit.SECONDS);
        }
    }

    @Override
    public void scrollToView_Web(int index) {
        if (!Helper.mobile.isWebDriver()) {
            return;
        }
        if (Helper.isVisibleInViewport(this.element, index).booleanValue()) {
            return;
        }
        this.webDriver.manage().timeouts().implicitlyWait(1L, TimeUnit.MILLISECONDS);
        WebElement element = this.getElement(index);
        Actions action = new Actions(AbstractDriver.getWebDriver());
        action.moveToElement(element);
        this.webDriver.manage().timeouts().implicitlyWait((long)AbstractDriver.TIMEOUT_IMPLICIT_SECONDS, TimeUnit.SECONDS);
    }

    @Override
    public boolean isExist(int ... index) {
        this.webDriver.manage().timeouts().implicitlyWait(1L, TimeUnit.MILLISECONDS);
        boolean isExist = false;
        isExist = index.length > 0 ? this.isElementExist(index[0]) : this.isListExist();
        if (!isExist) {
            this.resetElement();
        }
        this.webDriver.manage().timeouts().implicitlyWait((long)AbstractDriver.TIMEOUT_IMPLICIT_SECONDS, TimeUnit.SECONDS);
        return isExist;
    }

    public boolean isListExist() {
        List<WebElement> elements = this.getElements();
        if (elements == null || elements.isEmpty()) {
            return false;
        }
        int size = elements.size();
        int i = 0;
        while (i < size) {
            if (!this.isExist(i++)) continue;
            return true;
        }
        return false;
    }

    public boolean isElementExist(int index) {
        boolean isElementExists = false;
        try {
            WebElement element = this.getElement(index);
            if (element.isDisplayed()) {
                isElementExists = true;
            }
        }
        catch (Exception e) {
            isElementExists = false;
        }
        return isElementExists;
    }

    @Override
    public void moveMouse() {
        this.moveMouse(0);
    }

    @Override
    public void moveMouse(int index) {
        WebElement element = this.getElement(index);
        element.getLocation();
    }

    @Override
    public By getBy() {
        return this.by;
    }

    public String getCssSelectorValue() {
        String byValue = this.by.toString();
        return byValue.substring(byValue.indexOf(":") + 1);
    }

    @Override
    public void setValue(int index, CharSequence ... keysToSend) {
        MobileElement element = (MobileElement)this.getElement(index);
        String value = keysToSend[0].toString();
        element.setValue(value);
    }

    @Override
    public void sendKeys(CharSequence ... keysToSend) {
        this.sendKeys(0, keysToSend);
    }

    @Override
    public void sendKeys(int index, CharSequence ... keysToSend) {
        int retry = 3;
        ArrayList<String> exception = new ArrayList<String>();
        boolean success = false;
        do {
            --retry;
            try {
                this.scrollToView(index);
                this.isDisplayed(index);
                if (!this.isExist(new int[0])) continue;
                Helper.highLightWebElement(this.element, index);
                WebElement element = this.getElement(index);
                element.sendKeys(keysToSend);
                success = true;
            }
            catch (Exception e) {
                this.resetElement();
                String message = e.getLocalizedMessage();
                String rootCause = message.substring(0, message.indexOf("\n"));
                exception.add(rootCause);
                TestLog.ConsoleLog("send keys failed for element: " + this.elementName + ": " + rootCause, new Object[0]);
            }
        } while (!success && retry > 0);
    }

    @Override
    public void sendKeysByAction(int index, CharSequence ... keysToSend) {
        int retry = 3;
        boolean success = false;
        do {
            --retry;
            try {
                this.scrollToView(index);
                this.isDisplayed(index);
                if (!this.isExist(new int[0])) continue;
                this.sendKeyByAction(index, keysToSend);
                success = true;
            }
            catch (Exception e) {
                this.resetElement();
                String message = e.getLocalizedMessage();
                String rootCause = message.substring(0, message.indexOf("\n"));
                TestLog.ConsoleLog("sendkey failed: " + rootCause, new Object[0]);
            }
        } while (!success && retry > 0);
        Helper.assertTrue("send key was not successful", success);
    }

    @Override
    public void sendKeyByJs(int index, CharSequence[] keysToSend) {
        WebElement element = this.getElement(index);
        Helper.executeJs("arguments[0].setAttribute('value', '" + String.valueOf(keysToSend[0]) + "')", element);
    }

    public void sendKeyByAction(int index, CharSequence[] keysToSend) {
        WebElement element = this.getElement(index);
        Actions action = new Actions(this.webDriver);
        action.moveToElement(element).click().sendKeys(keysToSend).build().perform();
    }

    @Override
    public String getAttribute(String name) {
        return this.getAttribute(name, 0);
    }

    @Override
    public String getAttribute(String name, int index) {
        int retry = 3;
        String value = "";
        boolean isSuccess = false;
        do {
            --retry;
            try {
                WebElement element = this.getElement(index);
                value = element.getAttribute(name);
                isSuccess = true;
            }
            catch (Exception e) {
                e.getMessage();
            }
        } while (!isSuccess && retry > 0);
        return value;
    }

    @Override
    public void setAttribute(String attribute, String value) {
        this.setAttribute(attribute, 0, value);
    }

    @Override
    public void setAttribute(String attribute, int index, String value) {
        WebElement element = this.getElement(index);
        Helper.executeJs("arguments[0].setAttribute('" + attribute + "', '" + value + "')", element);
    }

    @Override
    public WebElement get(int index) {
        return this.getElement(index);
    }

    @Override
    public String getText() {
        return this.getText(0);
    }

    @Override
    public String getText(int index) {
        this.scrollToView_Web(index);
        int retry = 1;
        String value = "";
        boolean isSuccess = false;
        do {
            --retry;
            try {
                WebElement element = this.getElement(index);
                value = element.getText();
                if (value.isEmpty()) {
                    value = this.getAttribute("textContent", index);
                }
                if (value.isEmpty()) {
                    value = this.getAttribute("value", index);
                }
                if (value.isEmpty()) {
                    value = this.getAttribute("innerText", index);
                }
                if (value.isEmpty()) continue;
                isSuccess = true;
            }
            catch (Exception e) {
                e.getMessage();
            }
        } while (!isSuccess && retry > 0);
        return value;
    }

    @Override
    public List<String> getTextList() {
        ArrayList<String> stringList = new ArrayList<String>();
        List<WebElement> elementList = this.getElements();
        int listSize = elementList.size();
        for (int i = 0; i < listSize; ++i) {
            stringList.add(elementList.get(i).getText().trim());
        }
        return stringList;
    }

    private void resetElement() {
        this.current = null;
    }

    @Override
    public String getElementName() {
        return this.elementName;
    }

    public WebElement getElement(int index) {
        WebElement element = index == 0 ? this.getElement().get(0) : this.getElements().get(index);
        return element;
    }

    public void getParentElement() {
        if (this.parent == null || !this.parentElements.isEmpty()) {
            return;
        }
        for (ElementObject elementObject : this.parent.elementObject) {
            this.by = elementObject.by;
            this.locatorType = elementObject.locatorType;
            try {
                this.current = new ArrayList<WebElement>();
                this.parentElements = this.webDriver.findElements(this.by);
                if (!this.parentElements.isEmpty()) continue;
            }
            catch (Exception e) {
                e.getMessage();
            }
        }
    }

    public List<WebElement> getElement() {
        List<Object> elements = new ArrayList<WebElement>();
        if (this.current != null && !this.current.isEmpty()) {
            return this.current;
        }
        this.getParentElement();
        if (this.element.elementObject.size() > 1) {
            this.webDriver.manage().timeouts().implicitlyWait(1L, TimeUnit.MILLISECONDS);
        }
        for (ElementObject elementObject : this.element.elementObject) {
            this.by = elementObject.by;
            this.locatorType = elementObject.locatorType;
            try {
                if (!this.parentElements.isEmpty()) {
                    this.current = new ArrayList<WebElement>();
                    elements = this.parentElements.get(this.parentIndex).findElements(this.by);
                } else if (this.current == null || this.current.isEmpty()) {
                    this.current = new ArrayList<WebElement>();
                    elements = this.webDriver.findElements(this.by);
                }
                if (elements.isEmpty()) continue;
                WebElement element = this.getFirstVisibleElement(elements);
                this.current.add(element);
            }
            catch (Exception e) {
                e.getMessage();
            }
        }
        this.webDriver.manage().timeouts().implicitlyWait((long)AbstractDriver.TIMEOUT_IMPLICIT_SECONDS, TimeUnit.SECONDS);
        return this.current;
    }

    @Override
    public List<WebElement> getElements() {
        if (this.current != null && !this.current.isEmpty()) {
            return this.current;
        }
        this.getParentElement();
        if (this.element.elementObject.size() > 1) {
            this.webDriver.manage().timeouts().implicitlyWait(1L, TimeUnit.MILLISECONDS);
        }
        for (ElementObject elementObject : this.element.elementObject) {
            try {
                this.by = elementObject.by;
                this.locatorType = elementObject.locatorType;
                if (!this.parentElements.isEmpty()) {
                    this.current = this.parentElements.get(this.parentIndex).findElements(this.by);
                } else if (this.current == null || this.current.isEmpty()) {
                    this.current = this.webDriver.findElements(this.by);
                }
                if (this.current.isEmpty()) continue;
                break;
            }
            catch (Exception e) {
                e.getMessage();
            }
        }
        this.webDriver.manage().timeouts().implicitlyWait((long)AbstractDriver.TIMEOUT_IMPLICIT_SECONDS, TimeUnit.SECONDS);
        return this.current;
    }

    public WebElement getFirstVisibleElement(List<WebElement> elements) {
        this.webDriver.manage().timeouts().implicitlyWait(1L, TimeUnit.MILLISECONDS);
        WebElement element = null;
        int count = elements.size();
        if (count > 1) {
            for (int i = 0; i < elements.size(); ++i) {
                if (!elements.get(i).isDisplayed()) continue;
                element = elements.get(i);
                break;
            }
        } else {
            element = elements.get(0);
        }
        this.webDriver.manage().timeouts().implicitlyWait((long)AbstractDriver.TIMEOUT_IMPLICIT_SECONDS, TimeUnit.SECONDS);
        return element;
    }

    public boolean isSelected() {
        return false;
    }

    @Override
    public By getElementCssSelector() {
        return null;
    }

    public Rectangle getRect() {
        return null;
    }

    public <X> X getScreenshotAs(OutputType<X> arg0) throws WebDriverException {
        return null;
    }

    public List<WebElement> findElements(By by) {
        return null;
    }

    @Override
    public By getElementCssSelector(int index) {
        return null;
    }

    @Override
    public String getAttribute(int index, String name) {
        return null;
    }

    @Override
    public String getElementName(int index) {
        return null;
    }

    public WebElement findElement(By arg0) {
        return null;
    }
}

