/*
 * Decompiled with CFR 0.152.
 */
package core.uiCore.driverProperties.capabilities;

import core.support.configReader.Config;
import core.support.objects.TestObject;
import core.uiCore.driverProperties.browserType;
import core.uiCore.driverProperties.driverType;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.logging.LoggingPreferences;
import org.openqa.selenium.remote.DesiredCapabilities;

public class WebCapability {
    private static final String CHROME_OPTIONS_PREFIX = "chrome.options";
    private static final String FIREFOX_OPTIONS_PREFIX = "firefox.options";
    private static final String CHROME_PREF_PREFIX = "chrome.pref";
    private static final String FIREFOX_PREF_PREFIX = "firefox.pref";
    private static final String WEB_CAPABILITIES_PREFIX = "web.capabilities.";
    public DesiredCapabilities capabilities = new DesiredCapabilities();
    public ChromeOptions chromeOptions = new ChromeOptions();
    FirefoxOptions firefoxOptions = new FirefoxOptions();
    driverType.DriverType driverType;

    public WebCapability withCapability(DesiredCapabilities Capabilities) {
        this.capabilities = Capabilities;
        return this;
    }

    public WebCapability withBrowserCapability() {
        System.setProperty("webdriver.chrome.args", "--disable-logging");
        System.setProperty("webdriver.chrome.silentOutput", "true");
        this.capabilities.setCapability("recordVideo", true);
        this.capabilities.setBrowserName(this.getBrowserName());
        this.capabilities.setCapability("name", TestObject.getTestInfo().testName);
        this.setWebCapabilties();
        this.setOptions();
        this.setPreferences();
        LoggingPreferences logs = new LoggingPreferences();
        logs.enable("driver", Level.SEVERE);
        this.capabilities.setCapability("loggingPrefs", (Object)logs);
        return this;
    }

    public DesiredCapabilities setWebCapabilties() {
        Map<String, Object> propertiesMap = TestObject.getTestInfo().config;
        for (Map.Entry<String, Object> entry : propertiesMap.entrySet()) {
            boolean isWebCapability = entry.getKey().toString().startsWith(WEB_CAPABILITIES_PREFIX);
            if (!isWebCapability) continue;
            String fullKey = entry.getKey().toString();
            String key = fullKey.substring(fullKey.lastIndexOf(".") + 1).trim();
            String value = entry.getValue().toString().trim();
            this.capabilities.setCapability(key, value);
        }
        return this.capabilities;
    }

    private DesiredCapabilities setPreferences() {
        Map<String, Object> propertiesMap = TestObject.getTestInfo().config;
        HashMap<String, String> chromePreferences = new HashMap<String, String>();
        FirefoxProfile fireFoxProfile = new FirefoxProfile();
        for (Map.Entry<String, Object> entry : propertiesMap.entrySet()) {
            boolean isPref = entry.getKey().toString().startsWith(CHROME_PREF_PREFIX) || entry.getKey().toString().startsWith(FIREFOX_PREF_PREFIX);
            if (!isPref) continue;
            String fullKey = entry.getKey().toString();
            String[] split = fullKey.split("pref.");
            String key = split[1].trim();
            String value = entry.getValue().toString().trim();
            if (this.isChrome() && fullKey.contains(CHROME_PREF_PREFIX)) {
                chromePreferences.put(key, value);
                continue;
            }
            if (!this.isFirefox() || !fullKey.contains(FIREFOX_PREF_PREFIX)) continue;
            fireFoxProfile.setPreference(key, value);
        }
        if (this.isChrome()) {
            this.chromeOptions.setExperimentalOption("prefs", chromePreferences);
            this.capabilities.setCapability("goog:chromeOptions", (Object)this.chromeOptions);
        } else if (this.isFirefox()) {
            this.firefoxOptions.setProfile(fireFoxProfile);
            this.capabilities.setCapability("moz:firefoxOptions", (Object)this.firefoxOptions);
        }
        return this.capabilities;
    }

    private DesiredCapabilities setOptions() {
        Map<String, Object> propertiesMap = TestObject.getTestInfo().config;
        for (Map.Entry<String, Object> entry : propertiesMap.entrySet()) {
            boolean isOption = entry.getKey().toString().startsWith(CHROME_OPTIONS_PREFIX) || entry.getKey().toString().startsWith(FIREFOX_OPTIONS_PREFIX);
            if (!isOption) continue;
            String fullKey = entry.getKey().toString();
            String[] split = fullKey.split("options.");
            String key = "--" + split[1].trim();
            boolean isEnable = Boolean.valueOf(entry.getValue().toString().trim());
            if (isEnable && this.isChrome() && fullKey.contains(CHROME_OPTIONS_PREFIX)) {
                this.chromeOptions.addArguments(new String[]{key});
                continue;
            }
            if (!isEnable || !this.isFirefox() || !fullKey.contains(FIREFOX_OPTIONS_PREFIX)) continue;
            this.firefoxOptions.addArguments(new String[]{key});
        }
        if (this.isChrome()) {
            this.capabilities.setCapability("goog:chromeOptions", (Object)this.chromeOptions);
        } else if (this.isFirefox()) {
            this.capabilities.setCapability("moz:firefoxOptions", (Object)this.firefoxOptions);
        }
        return this.capabilities;
    }

    public DesiredCapabilities getCapability() {
        return this.capabilities;
    }

    public String getUrl(String app, String defaultUrl) {
        String value = Config.getValue(app);
        if (value.isEmpty()) {
            value = defaultUrl;
        }
        return value;
    }

    public browserType.BrowserType getBrowser() {
        String value = Config.getValue("web.browserType");
        return Enum.valueOf(browserType.BrowserType.class, value);
    }

    public String getBrowserName() {
        String browsername = this.getBrowser().toString().toLowerCase();
        if ((browsername = browsername.replace("_", "")).contains("chrome")) {
            browsername = "chrome";
        }
        if (browsername.contains("firefox")) {
            browsername = "firefox";
        }
        return browsername;
    }

    public boolean isChrome() {
        return this.getBrowserName().equals("chrome");
    }

    public boolean isFirefox() {
        return this.getBrowserName().equals("firefox");
    }

    public String getDriverVersion() {
        String value = Config.getValue("web.driver.manager.version");
        return value;
    }

    public driverType.DriverType getWebDriverType() {
        String value = Config.getValue("web.webdriverType");
        return Enum.valueOf(driverType.DriverType.class, value);
    }
}

