/*
 * Decompiled with CFR 0.152.
 */
package core.support.configReader;

import core.helpers.Helper;
import core.support.configReader.MavenReader;
import core.support.configReader.PropertiesReader;
import core.support.logger.TestLog;
import core.support.objects.TestObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class Config {
    private static final String CONFIG_PREFIX = "config.";
    public static String RESOURCE_PATH = PropertiesReader.getLocalResourcePath();

    private static String getStringProperty(String key, Properties property) {
        if (!MavenReader.getStringProperty(key).isEmpty()) {
            return MavenReader.getStringProperty(key);
        }
        if (!PropertiesReader.getStringProperty(key, property).isEmpty()) {
            return PropertiesReader.getStringProperty(key, property);
        }
        return "";
    }

    public static void getAllFiles(File curDir) {
        File[] filesList;
        for (File f : filesList = curDir.listFiles()) {
            if (f.isDirectory()) {
                Config.getAllFiles(f);
            }
            if (!f.isFile()) continue;
            System.out.println("All files: " + f.getPath() + " : " + f.getName());
        }
    }

    public static Map<String, String> getAllKeys(String path) {
        ConcurrentHashMap<String, String> config = new ConcurrentHashMap<String, String>();
        try {
            List<Properties> properties = PropertiesReader.Property(path);
            for (Properties property : properties) {
                for (String key : property.stringPropertyNames()) {
                    Helper.assertTrue("duplicate property/config key exists: " + key + " at folder: " + path, config.get(key) == null);
                    String value = Config.getStringProperty(key, property);
                    config.put(key, value);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return config;
    }

    public static void loadConfig(String testId) {
        Map<String, Object> config = Config.loadConfigProperties();
        TestObject.getTestInfo((String)testId).config.putAll(config);
    }

    public static Map<String, Object> loadConfigProperties() {
        ConcurrentHashMap<String, Object> config = new ConcurrentHashMap<String, Object>();
        Map<String, String> propertiesMap = Config.getAllKeys(RESOURCE_PATH);
        config.putAll(propertiesMap);
        for (Map.Entry<String, String> entry : propertiesMap.entrySet()) {
            boolean isConfig = entry.getKey().toString().startsWith(CONFIG_PREFIX);
            if (!isConfig) continue;
            propertiesMap = Config.getAllKeys(PropertiesReader.getLocalRootPath() + entry.getValue());
            config.putAll(propertiesMap);
        }
        return config;
    }

    public static String getValue(String key) {
        return Config.getValue(key, false);
    }

    public static String getValue(String key, boolean isFailable) {
        Object value = TestObject.getTestInfo().config.get(key);
        if (value == null) {
            if (isFailable) {
                Helper.assertFalse("value not found, default empty: " + key);
            }
            System.out.println("value not found, default empty: " + key);
            TestLog.ConsoleLogWarn("value not found, default empty: " + key, new Object[0]);
            value = "";
        }
        List<String> items = Arrays.asList(value.toString().split("\\s*,\\s*"));
        return items.get(0);
    }

    public static Boolean getBooleanValue(String key) {
        return Config.getBooleanValue(key, false);
    }

    public static Boolean getBooleanValue(String key, boolean isFailable) {
        String value = Config.getValue(key, isFailable);
        if (value.isEmpty()) {
            if (isFailable) {
                Helper.assertFalse("value not found: " + key);
            }
            TestLog.ConsoleLogWarn("value not found, default false: " + key, new Object[0]);
            return false;
        }
        return Boolean.parseBoolean(value);
    }

    public static Object getObjectValue(String key) {
        Object value = TestObject.getTestInfo().config.get(key);
        return value;
    }

    public static int getIntValue(String key) {
        return Config.getIntValue(key, false);
    }

    public static int getIntValue(String key, boolean isFailable) {
        String value = Config.getValue(key, isFailable);
        if (value.isEmpty()) {
            if (isFailable) {
                Helper.assertFalse("value not found: " + key);
            }
            TestLog.ConsoleLogWarn("value not found, default -1: " + key, new Object[0]);
            return -1;
        }
        return Integer.valueOf(value);
    }

    public static double getDoubleValue(String key) {
        return Config.getDoubleValue(key, false);
    }

    public static double getDoubleValue(String key, boolean isFailable) {
        String value = Config.getValue(key, isFailable);
        if (value.isEmpty()) {
            if (isFailable) {
                Helper.assertFalse("value not found: " + key);
            }
            TestLog.ConsoleLogWarn("value not found, default -1: " + key, new Object[0]);
            return -1.0;
        }
        return Double.valueOf(value);
    }

    public static List<String> getValueList(String key) {
        return Config.getValueList(key, true);
    }

    public static List<String> getValueList(String key, boolean isFailable) {
        String value = (String)TestObject.getTestInfo().config.get(key);
        List<String> items = new ArrayList<String>();
        if (value == null) {
            if (isFailable) {
                Helper.assertFalse("value not found in config files: " + key);
            }
            TestLog.ConsoleLogWarn("value not found in config files: " + key, false);
        }
        if (!value.isEmpty()) {
            items = Arrays.asList(value.split("\\s*,\\s*"));
        }
        return items;
    }

    public static void putValue(String key, Object value) {
        TestLog.logPass("storing in key: " + key + " value: " + value, new Object[0]);
        TestObject.getTestInfo().config.put(key, value);
    }

    public static void putValue(String key, Object value, String info) {
        TestLog.logPass("storing in key: " + key + " value: " + info, new Object[0]);
        TestObject.getTestInfo().config.put(key, value);
    }
}

