/*
 * Decompiled with CFR 0.152.
 */
package core.support.annotation.template.dataObject;

import core.support.annotation.helper.DataObjectHelper;
import core.support.annotation.helper.FileCreatorHelper;
import core.support.annotation.helper.Logger;
import core.support.annotation.helper.PackageHelper;
import core.support.annotation.helper.annotationMap.DataMapHelper;
import java.io.BufferedWriter;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.tools.JavaFileObject;

public class ModuleClass {
    public static JavaFileObject CSV_File_Object = null;
    public static String MODULE_ROOT = "module";
    public static String DATA_ROOT = "data";

    public static void writeModuleClass(Map<String, List<Element>> panelMap) {
        try {
            ModuleClass.writeModuleClassImplementation(panelMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void writeModuleClassImplementation(Map<String, List<Element>> dataObjectMap) throws Exception {
        Logger.debug("<<<< start generating data objects module classes >>>>");
        List<File> files = DataObjectHelper.getAllCsvDataFiles();
        ModuleClass.writeModuleClasses(files, dataObjectMap);
        Logger.debug("<<<< completed generating data objects module classes >>>>");
    }

    private static void writeModuleClasses(List<File> files, Map<String, List<Element>> dataObjectMap) throws Exception {
        Map<String, List<File>> moduleMap = DataMapHelper.getDataModuleMap(files);
        Map<String, List<String>> simpleModuleMap = ModuleClass.convertCsvModuleMap(moduleMap);
        Map<String, List<String>> simpleDataObjectMap = ModuleClass.convertDataObjectModuleMap(dataObjectMap);
        Map<String, List<String>> combinedMap = DataMapHelper.mergeMaps(simpleModuleMap, simpleDataObjectMap);
        Logger.debug("writeModuleClasses: data objects: " + simpleDataObjectMap.size());
        Logger.debug("writeModuleClasses: csv objects: " + simpleModuleMap.size());
        Logger.debug("writeModuleClasses: combined data objects: " + combinedMap.size());
        for (Map.Entry<String, List<String>> entry : combinedMap.entrySet()) {
            ModuleClass.writeModuleClass(entry);
        }
    }

    private static void writeModuleClass(Map.Entry<String, List<String>> entry) throws Exception {
        String module = entry.getKey();
        Logger.debug("writing module class: " + module);
        String filePath = PackageHelper.DATA_PATH + "." + module + "." + module;
        JavaFileObject fileObject = FileCreatorHelper.createFileAbsolutePath(filePath);
        BufferedWriter bw = new BufferedWriter(fileObject.openWriter());
        Date currentDate = new Date();
        bw.append("/**Auto generated code,don't modify it.\n");
        bw.append("* Author             ---- > Auto Generated.\n");
        bw.append("* Date  And Time     ---- > " + currentDate.toString() + "\n");
        bw.append("*");
        bw.append("**/\n\n\n\n");
        bw.append("package " + DATA_ROOT + "." + module + ";\n");
        bw.newLine();
        bw.newLine();
        for (String filename : entry.getValue()) {
            if (!PackageHelper.hasPackagePath(filename)) continue;
            bw.append("import " + filename + ";\n");
        }
        bw.newLine();
        bw.newLine();
        bw.append("public class " + module + " {\n");
        bw.newLine();
        bw.newLine();
        for (String filename : entry.getValue()) {
            filename = PackageHelper.getClassName(filename);
            bw.append("public " + filename + " " + filename.toLowerCase() + "() {\n");
            bw.append("    return new " + filename + "();\n");
            bw.append("}");
            bw.newLine();
            bw.newLine();
        }
        bw.newLine();
        bw.newLine();
        bw.append("}\n");
        bw.flush();
        bw.close();
    }

    private static Map<String, List<String>> convertCsvModuleMap(Map<String, List<File>> moduleMap) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        ArrayList<String> classes = new ArrayList<String>();
        for (Map.Entry<String, List<File>> entry : moduleMap.entrySet()) {
            classes = new ArrayList();
            for (File file : entry.getValue()) {
                String csvName = file.getName().replaceFirst("[.][^.]+$", "");
                classes.add(csvName);
            }
            map.put(entry.getKey(), classes);
        }
        return map;
    }

    private static Map<String, List<String>> convertDataObjectModuleMap(Map<String, List<Element>> moduleMap) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        ArrayList<String> classes = new ArrayList<String>();
        for (Map.Entry<String, List<Element>> entry : moduleMap.entrySet()) {
            classes = new ArrayList();
            for (Element element : entry.getValue()) {
                String classname = element.asType().toString();
                classes.add(classname);
            }
            map.put(entry.getKey(), classes);
        }
        return map;
    }
}

