/*
 * Decompiled with CFR 0.152.
 */
package core.support.annotation.template.config;

import core.support.annotation.helper.FileCreatorHelper;
import core.support.annotation.helper.Logger;
import core.support.annotation.helper.PackageHelper;
import core.support.annotation.processor.MainGenerator;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Date;
import javax.lang.model.element.Element;
import javax.tools.JavaFileObject;

public class ConfigManager {
    public static void writeConfigManagerClass() {
        try {
            ConfigManager.writeConfigModuleClassImplementation();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void writeConfigModuleClassImplementation() throws IOException {
        JavaFileObject fileObject;
        Logger.debug("start generating config module class");
        if (FileCreatorHelper.CONFIG_MODULE_FILE_OBJECT != null) {
            return;
        }
        FileCreatorHelper.CONFIG_MODULE_FILE_OBJECT = fileObject = MainGenerator.PROCESS_ENV.getFiler().createSourceFile(PackageHelper.CONFIG_MANAGER_PATH + "." + PackageHelper.CONFIG_MANAGER_CLASS, new Element[0]);
        BufferedWriter bw = new BufferedWriter(fileObject.openWriter());
        Date currentDate = new Date();
        bw.append("/**Auto generated code,don't modify it.\n");
        bw.append("* Author             ---- > Auto Generated.\n");
        bw.append("* Date  And Time     ---- > " + currentDate.toString() + "\n");
        bw.append("*");
        bw.append("**/\n\n\n\n");
        bw.append("package " + PackageHelper.CONFIG_MANAGER_PATH + ";\n");
        bw.newLine();
        bw.newLine();
        bw.append("import core.helpers.Helper;\n");
        bw.append("import core.support.configReader.Config;\n");
        bw.newLine();
        bw.newLine();
        bw.append("public class ConfigManager {\n");
        bw.newLine();
        bw.append("\tString key;\n");
        bw.append("\tString value;\n");
        bw.newLine();
        bw.append("\tpublic ConfigManager(String key, String val) {\n");
        bw.append("\t\tthis.key = key;\n");
        bw.append("\t\tthis.value = val;\n");
        bw.append("\t}\n");
        bw.newLine();
        bw.append("\tpublic String toString() {\n");
        bw.append("\t\treturn this.value;\n");
        bw.append("\t}\n");
        bw.newLine();
        bw.append("\tpublic boolean toBoolean() {\n");
        bw.append("\t\tif(!Helper.isBoolean(this.value))\n");
        bw.append("\t\t\tHelper.assertFalse(this.value + \" is not a Boolean value\" );\n");
        bw.append("\t\treturn Boolean.valueOf(this.value);\n");
        bw.append("\t}\n");
        bw.newLine();
        bw.append("\tpublic int toInt() {\n");
        bw.append("\t\tif(!Helper.isNumeric(this.value))\n");
        bw.append("\t\t\tHelper.assertFalse(this.value + \" is not a number\" );\n");
        bw.append("\t\treturn Integer.valueOf(this.value);\n");
        bw.append("\t}\n");
        bw.newLine();
        bw.append("\tpublic double toDouble() {\n");
        bw.append("\t\tif(!Helper.isNumeric(this.value))\n");
        bw.append("\t\t\tHelper.assertFalse(this.value + \" is not a number\" );\n");
        bw.append("\t\treturn Double.valueOf(this.value);\n");
        bw.append("\t}\n");
        bw.newLine();
        bw.append("\tpublic void setValue(Object value) {\n");
        bw.append("\t\tConfig.putValue(key, value.toString());\n");
        bw.append("\t}\n");
        bw.append("}\n");
        bw.flush();
        bw.close();
        Logger.debug("complete generating config manager class");
    }
}

