/*
 * Decompiled with CFR 0.152.
 */
package core.support.annotation.helper;

import core.support.annotation.helper.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;

public class PackageHelper {
    public static String CONFIG_MANAGER_CLASS = "ConfigManager";
    public static String MODULE_MANAGER_CLASS = "ModuleManager";
    public static String PANEL_MANAGER_CLASS = "PanelManager";
    public static String MODULE_CLASS = "ModuleBase";
    public static String DATA_PATH = "data";
    public static String SERVICE_PATH = "serviceManager";
    public static String MODULE_MANAGER_PATH = "moduleManager";
    public static String CONFIG_MANAGER_PATH = "configManager";

    public static String getModuleName(Element element) {
        String sourceClass = element.asType().toString();
        String module = sourceClass.split("\\.")[1];
        return module;
    }

    public static String getPackagePath(Element element) {
        String sourceClass = element.asType().toString();
        String packagePath = MODULE_MANAGER_PATH + "." + sourceClass.split("\\.")[0] + "." + sourceClass.split("\\.")[1];
        return packagePath;
    }

    public static String getPackagePath(String sourceClass) {
        int lastIndxDot = sourceClass.lastIndexOf(46);
        return sourceClass.substring(0, lastIndxDot);
    }

    public static String getRootPath(String path) {
        return path.split("\\.")[0];
    }

    public static String getAppName(Element element) {
        String sourceClass = element.asType().toString();
        String appName = sourceClass.split("\\.")[1];
        return appName;
    }

    public static String getFirstModuleFullPath(Map<String, List<Element>> panelMap) {
        String sourceClass;
        block0: {
            sourceClass = "";
            Iterator<Map.Entry<String, List<Element>>> iterator = panelMap.entrySet().iterator();
            if (!iterator.hasNext()) break block0;
            Map.Entry<String, List<Element>> entry = iterator.next();
            Element firstElement = entry.getValue().get(0);
            sourceClass = firstElement.asType().toString();
        }
        return sourceClass;
    }

    public static String getModuleFromFullPath(File file) {
        String pattern = Pattern.quote(File.separator);
        String[] directories = file.getAbsolutePath().split(pattern);
        Logger.debug("getModuleFromFullPath: " + file.getAbsolutePath());
        for (int i = 0; i < directories.length; ++i) {
            if (!directories[i].equals("module")) continue;
            return directories[i + 1];
        }
        return "data";
    }

    public static Set<String> getModuleList(List<File> files) {
        TreeSet<String> modules = new TreeSet<String>();
        for (File file : files) {
            String module = PackageHelper.getModuleFromFullPath(file);
            modules.add(module);
        }
        return modules;
    }

    public static boolean hasPackagePath(String value) {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(value.split("\\.")));
        return list.size() > 1;
    }

    public static String getClassName(String classPath) {
        return classPath.substring(classPath.lastIndexOf(46) + 1).trim();
    }
}

