/*
 * Decompiled with CFR 0.152.
 */
package core.helpers;

import core.helpers.AssertHelper;
import core.helpers.Element;
import core.helpers.Helper;
import core.helpers.StopWatchHelper;
import core.helpers.UtilityHelper;
import core.support.logger.TestLog;
import core.uiCore.drivers.AbstractDriver;
import core.uiCore.webElement.EnhancedBy;
import core.uiCore.webElement.EnhancedWebElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ListHelper {
    public void selectElementInList(EnhancedBy list, int index) {
        EnhancedWebElement listElement = Element.findElements(list);
        listElement.click(index);
    }

    public void selectElementInList(EnhancedBy list, int index, EnhancedBy expected) {
        Helper.click.clickAndExpect(list, index, expected, true);
    }

    public void searchAndWaitForResults(String searchQuery, EnhancedBy byTarget, EnhancedBy spinner) {
        Helper.form.setFieldAndEnter(byTarget, searchQuery);
        Helper.wait.waitForElementToBeRemoved(spinner);
    }

    public void selectListItemEqualsByName(EnhancedBy list, String option) {
        Helper.wait.waitForElementToLoad(list);
        int index = this.getElementIndexEqualsByText(list, option);
        AssertHelper.assertTrue("option not found in list: " + list.name, index > -1);
        this.selectElementInList(list, index);
        TestLog.logPass("I select list option '" + option + "' from list '" + list.name + "'", new Object[0]);
    }

    public void selectListItemEqualsByName(EnhancedBy list, String option, EnhancedBy target) {
        Helper.wait.waitForElementToLoad(list);
        int index = this.getElementIndexEqualsByText(list, option);
        AssertHelper.assertTrue("option not found in list: " + list.name, index > -1);
        this.selectElementInList(target, index);
        TestLog.logPass("I select list option '" + option + "' from list '" + list.name + "'", new Object[0]);
    }

    public void selectListItemContainsByName(EnhancedBy list, String option, EnhancedBy target) {
        Helper.wait.waitForElementToLoad(list);
        int index = this.getElementIndexContainByText(list, option);
        AssertHelper.assertTrue("option not found in list: " + list.name, index > -1);
        this.selectElementInList(target, index);
        TestLog.logPass("I select list option '" + option + "' from list '" + list.name + "'", new Object[0]);
    }

    public void selectElementContainedInList(EnhancedBy list, String option, EnhancedBy target) {
        Helper.wait.waitForElementToLoad(list);
        int index = this.getElementIndexContainByText(list, option);
        AssertHelper.assertTrue("option not found in list: " + list.name, index > -1);
        EnhancedWebElement targetElement = Element.findElements(list, index, target);
        targetElement.click();
        TestLog.logPass("I select list option '" + option + "' from list '" + list.name + "'", new Object[0]);
    }

    public int getElementIndexInList(EnhancedBy list, EnhancedBy target) {
        Helper.waitForElementToLoad(list);
        EnhancedWebElement listElements = Element.findElements(list);
        int count = listElements.count();
        for (int index = 0; index < count; ++index) {
            EnhancedWebElement targetElement = Element.findElements(list, index, target);
            if (!targetElement.isExist(new int[0])) continue;
            return index;
        }
        return -1;
    }

    public List<String> getRowValuesFromList(EnhancedBy list, int index, EnhancedBy cells) {
        Helper.waitForElementToLoad(list);
        EnhancedWebElement targetElement = Element.findElements(list, index, cells);
        return targetElement.getTextList();
    }

    public HashMap<String, List<String>> getTableMap(EnhancedBy columns, EnhancedBy dataRows, EnhancedBy dataCells) {
        return this.getTableMap(columns, 0, dataRows, 0, dataCells, -1);
    }

    public HashMap<String, List<String>> getTableMap(EnhancedBy columns, EnhancedBy dataRows, EnhancedBy dataCells, int maxRows) {
        return this.getTableMap(columns, 0, dataRows, 0, dataCells, maxRows);
    }

    public HashMap<String, List<String>> getTableMap(EnhancedBy columns, int columnInitialIndex, EnhancedBy dataRows, int rowInitialIndex, EnhancedBy dataCells, int maxRows) {
        Helper.waitForElementToLoad(columns);
        HashMap<String, List<String>> table = new HashMap<String, List<String>>();
        int columnCount = Helper.getListCount(columns);
        HashMap<Integer, List<String>> rowValues = this.getTableRowValues(dataRows, dataCells);
        List<String> columnList = Helper.getListValues(columns);
        for (int i = columnInitialIndex; i < columnCount; ++i) {
            String column = columnList.get(i);
            ArrayList<String> columnValues = new ArrayList<String>();
            for (Map.Entry<Integer, List<String>> entry : rowValues.entrySet()) {
                if (maxRows != -1 && entry.getKey() >= maxRows) break;
                if (entry.getValue().size() != columnCount) {
                    TestLog.ConsoleLogWarn("number of columns and row data mismatch at row: " + entry.getKey(), new Object[0]);
                }
                String rowValue = entry.getValue().get(i);
                columnValues.add(rowValue);
            }
            table.put(column, columnValues);
        }
        return table;
    }

    public HashMap<Integer, List<String>> getTableRowValues(EnhancedBy dataRows, EnhancedBy dataCells) {
        return this.getTableRowValues(dataRows, dataCells, -1);
    }

    public HashMap<Integer, List<String>> getTableRowValues(EnhancedBy dataRows, EnhancedBy dataCells, int maxRows) {
        HashMap<Integer, List<String>> table = new HashMap<Integer, List<String>>();
        int rowCount = Helper.getListCount(dataRows);
        if (maxRows > rowCount) {
            maxRows = rowCount;
        }
        if (maxRows == -1) {
            maxRows = rowCount;
        }
        for (int j = 0; j < maxRows; ++j) {
            EnhancedWebElement targetElement = Element.findElements(dataRows, j, dataCells);
            List<String> rowValues = targetElement.getTextList();
            table.put(j, rowValues);
        }
        return table;
    }

    public void selectListItemContainsByName(EnhancedBy list, String option) {
        Helper.wait.waitForElementToLoad(list);
        int index = this.getElementIndexContainByText(list, option);
        AssertHelper.assertTrue("option not found in list: " + list.name, index > -1);
        this.selectElementInList(list, index);
        TestLog.logPass("I select list option '" + option + "' from list '" + list.name + "'", new Object[0]);
    }

    public void selectListItemByIndex(EnhancedBy list, int index) {
        AssertHelper.assertTrue("option not found in list: " + list.name, index > -1);
        this.selectElementInList(list, index);
    }

    public int getListCount(EnhancedBy list) {
        EnhancedWebElement listElements = Element.findElements(list);
        return listElements.count();
    }

    public int getElementIndexEqualsByText(EnhancedBy list, String option) {
        int index = -1;
        StopWatchHelper watch = StopWatchHelper.start();
        long passedTimeInSeconds = 0L;
        do {
            EnhancedWebElement listElements = Element.findElements(list);
            List<String> stringList = listElements.getTextList();
            index = this.getStringIndexEqualsByText(list, stringList, option);
            passedTimeInSeconds = watch.time(TimeUnit.SECONDS);
        } while (index == -1 && passedTimeInSeconds < (long)AbstractDriver.TIMEOUT_SECONDS);
        return index;
    }

    public int getElementIndexContainByText(EnhancedBy list, String option) {
        int index = -1;
        StopWatchHelper watch = StopWatchHelper.start();
        long passedTimeInSeconds = 0L;
        do {
            EnhancedWebElement listElements = Element.findElements(list);
            List<String> stringList = listElements.getTextList();
            index = this.getStringIndexContainByText(list, stringList, option);
            passedTimeInSeconds = watch.time(TimeUnit.SECONDS);
        } while (index == -1 && passedTimeInSeconds < (long)AbstractDriver.TIMEOUT_SECONDS);
        return index;
    }

    public int getVisibleElementIndex(EnhancedBy list, List<Integer> indexValues) {
        EnhancedWebElement listElements = Element.findElements(list);
        for (Integer index : indexValues) {
            if (!listElements.isExist(index)) continue;
            return index;
        }
        return -1;
    }

    public int getStringIndexContainByText(EnhancedBy list, List<String> stringList, String option) {
        EnhancedWebElement listElements = Element.findElements(list);
        String value = null;
        int listCount = stringList.size();
        for (int i = 0; i < listCount; ++i) {
            value = Helper.stringNormalize(stringList.get(i));
            if (!value.contains(option = UtilityHelper.stringNormalize(option))) continue;
            listElements.scrollToView(i);
            if (!listElements.isExist(i)) continue;
            return i;
        }
        return -1;
    }

    public int getStringIndexContainByText(List<String> stringList, String option) {
        String value = null;
        int listCount = stringList.size();
        for (int i = 0; i < listCount; ++i) {
            value = Helper.stringNormalize(stringList.get(i));
            if (!value.contains(option = UtilityHelper.stringNormalize(option))) continue;
            return i;
        }
        return -1;
    }

    public int getStringIndexEqualsByText(EnhancedBy list, List<String> stringList, String option) {
        EnhancedWebElement listElements = Element.findElements(list);
        int listCount = stringList.size();
        for (int i = 0; i < listCount; ++i) {
            String listValue = UtilityHelper.stringNormalize(stringList.get(i));
            if (!listValue.equalsIgnoreCase(option = UtilityHelper.stringNormalize(option))) continue;
            listElements.scrollToView(i);
            if (!listElements.isExist(i)) continue;
            return i;
        }
        return -1;
    }

    public int getStringIndexEqualsByText(List<String> stringList, String option) {
        int listCount = stringList.size();
        for (int i = 0; i < listCount; ++i) {
            String listValue = UtilityHelper.stringNormalize(stringList.get(i));
            if (!listValue.equalsIgnoreCase(option = UtilityHelper.stringNormalize(option))) continue;
            return i;
        }
        return -1;
    }

    public void verifyContainsIsInList(EnhancedBy list, String option) {
        Helper.wait.waitForElementToLoad(list);
        int index = this.getElementIndexContainByText(list, option);
        AssertHelper.assertTrue("option not found in list: " + list.name, index > -1);
    }

    public void verifyIsInList(EnhancedBy list, String option) {
        Helper.wait.waitForElementToLoad(list);
        int index = this.getElementIndexEqualsByText(list, option);
        AssertHelper.assertTrue("option not found in list: " + list.name, index > -1);
    }

    public void verifyIsInList(EnhancedBy list, String indicator, String option) {
        int index = this.getElementIndexEqualsByText(list, option);
        EnhancedWebElement listElements = Element.findElements(list);
        boolean isInList = listElements.getText(index).contains(option);
        AssertHelper.assertTrue("option not found in list: " + list.name, isInList);
    }

    public boolean isContainedInList(EnhancedBy list, String option) {
        EnhancedWebElement listElements = Element.findElements(list);
        List<String> stringList = listElements.getTextList();
        int index = this.getStringIndexContainByText(stringList, option);
        if (index == -1) {
            return false;
        }
        return index != -1;
    }

    public boolean isExactMatchInList(EnhancedBy list, String option) {
        int index = this.getElementIndexEqualsByText(list, option);
        return index != -1;
    }

    public List<String> getListValues(EnhancedBy list) {
        EnhancedWebElement listElements = Element.findElements(list);
        return listElements.getTextList();
    }

    public List<String> getTextList(EnhancedBy list) {
        EnhancedWebElement listElements = Element.findElements(list);
        List<String> stringList = listElements.getTextList();
        return stringList;
    }
}

