/*
 * Decompiled with CFR 0.152.
 */
package core.apiCore.interfaces;

import core.apiCore.helpers.DataHelper;
import core.apiCore.helpers.JsonHelper;
import core.helpers.Helper;
import core.helpers.StopWatchHelper;
import core.support.configReader.Config;
import core.support.logger.TestLog;
import core.support.objects.KeyValue;
import core.support.objects.ServiceObject;
import io.restassured.RestAssured;
import io.restassured.authentication.AuthenticationScheme;
import io.restassured.config.EncoderConfig;
import io.restassured.config.HttpClientConfig;
import io.restassured.config.RestAssuredConfig;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;

public class RestApiInterface {
    private static final String AUTHORIZATION_HEADER = "Authorization";

    public static Response RestfullApiInterface(ServiceObject apiObject) {
        if (apiObject == null) {
            Helper.assertFalse("apiobject is null");
        }
        RestApiInterface.setTimeout();
        RestApiInterface.setProxy();
        apiObject.withRequestBody(DataHelper.replaceParameters(apiObject.getRequestBody()));
        RestApiInterface.setURI(apiObject);
        Response response = RestApiInterface.evaluateRequestAndValidateResponse(apiObject);
        return response;
    }

    public static Response evaluateRequestAndValidateResponse(ServiceObject apiObject) {
        List<Object> errorMessages = new ArrayList();
        Response response = null;
        StopWatchHelper watch = StopWatchHelper.start();
        long passedTimeInSeconds = 0L;
        boolean isValidationTimeout = Config.getBooleanValue("api.timeout.validation.isEnabled");
        int maxRetrySeconds = Config.getIntValue("api.timeout.validation.seconds");
        int currentRetryCount = 0;
        do {
            response = RestApiInterface.evaluateRequest(apiObject);
            errorMessages = RestApiInterface.validateResponse(response, apiObject);
            if (!isValidationTimeout) break;
            if (currentRetryCount > 0) {
                Helper.waitForSeconds(1.0);
                String errors = StringUtils.join(errorMessages, (String)"\n error: ");
                TestLog.ConsoleLog("attempt 1 failed with message: " + errors, new Object[0]);
                TestLog.ConsoleLog("attempt #" + (currentRetryCount + 1), new Object[0]);
            }
            ++currentRetryCount;
            passedTimeInSeconds = watch.time(TimeUnit.SECONDS);
        } while (!errorMessages.isEmpty() && passedTimeInSeconds < (long)maxRetrySeconds);
        if (!errorMessages.isEmpty()) {
            Helper.assertFalse(StringUtils.join(errorMessages, (String)"\n error: "));
        }
        return response;
    }

    public static void setURI(ServiceObject apiObject) {
        apiObject.withUriPath(DataHelper.replaceParameters(apiObject.getUriPath()));
        apiObject.withUriPath(Helper.stringRemoveLines(apiObject.getUriPath()));
        if (apiObject.getUriPath().startsWith("http")) {
            RestAssured.baseURI = apiObject.getUriPath();
            apiObject.withUriPath("");
        } else {
            RestAssured.baseURI = Helper.stringRemoveLines(Config.getValue("api.uriPath"));
            TestLog.logPass("request URI: " + RestAssured.baseURI + apiObject.getUriPath(), new Object[0]);
        }
    }

    public static void setTimeout() {
        int connectTimeout = Config.getIntValue("api.timeout.connect.seconds");
        RestAssured.config = RestAssuredConfig.config().httpClient(HttpClientConfig.httpClientConfig().setParam("http.connection.timeout", (Object)(connectTimeout * 1000)).setParam("http.socket.timeout", (Object)(connectTimeout * 1000)).setParam("http.connection-manager.timeout", (Object)(connectTimeout * 1000)));
    }

    public static void setProxy() {
        String host = Config.getValue("api.proxy.host");
        String port = Config.getValue("api.proxy.port");
        if (host.isEmpty()) {
            return;
        }
        RestAssured.proxy((String)host);
        if (!port.isEmpty()) {
            RestAssured.proxy((String)port);
        }
    }

    public static List<String> validateResponse(Response response, ServiceObject apiObject) {
        List<String> errorMessages = new ArrayList<String>();
        if (response == null) {
            errorMessages.add("no response returned");
            return errorMessages;
        }
        JsonHelper.saveOutboundJsonParameters(response, apiObject.getOutputParams());
        if (!apiObject.getRespCodeExp().isEmpty()) {
            String message = "expected status code: " + apiObject.getRespCodeExp() + " response status code: " + response.getStatusCode();
            TestLog.logPass(message, new Object[0]);
            if (response.getStatusCode() != Integer.valueOf(apiObject.getRespCodeExp()).intValue()) {
                errorMessages.add(message);
                return errorMessages;
            }
        }
        errorMessages = RestApiInterface.validateExpectedValues(response, apiObject);
        errorMessages.removeAll(Collections.singleton(""));
        return errorMessages;
    }

    public static List<String> validateExpectedValues(Response response, ServiceObject apiObject) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        String body = response.getBody().asString();
        TestLog.logPass("response: " + body, new Object[0]);
        if (!apiObject.getExpectedResponse().isEmpty()) {
            String[] criteria;
            apiObject.withExpectedResponse(DataHelper.replaceParameters(apiObject.getExpectedResponse()));
            for (String criterion : criteria = apiObject.getExpectedResponse().split("&&")) {
                Helper.assertTrue("expected is not valid format: " + criterion, JsonHelper.isValidExpectation(criterion));
                errorMessages.add(JsonHelper.validateByJsonBody(criterion, response.getBody().asString()));
                errorMessages.addAll(JsonHelper.validateByKeywords(criterion, response));
                errorMessages.add(JsonHelper.validateResponseBody(criterion, response));
            }
        }
        return errorMessages;
    }

    public static RequestSpecification evaluateRequestHeaders(ServiceObject apiObject) {
        RequestSpecification request = RestAssured.given();
        if (apiObject.getRequestHeaders().isEmpty()) {
            return request;
        }
        apiObject.withRequestHeaders(DataHelper.replaceParameters(apiObject.getRequestHeaders()));
        List<KeyValue> keywords = DataHelper.getValidationMap(apiObject.getRequestHeaders());
        block10: for (KeyValue keyword : keywords) {
            switch (keyword.key) {
                case "auth": {
                    String value = (String)keyword.value;
                    value = value.replace("$", "").replace("<", "").replace(">", "").trim();
                    RestAssured.authentication = (AuthenticationScheme)Config.getObjectValue(value.replace("@", ""));
                    continue block10;
                }
                case "INVALID_TOKEN": {
                    String authValue = Config.getValue(AUTHORIZATION_HEADER);
                    if (!authValue.isEmpty() && authValue.length() > 4) {
                        authValue = authValue.substring(0, authValue.length() - 4) + "invalid";
                        request = RestAssured.given().header(AUTHORIZATION_HEADER, (Object)authValue, new Object[0]);
                        continue block10;
                    }
                    request = RestAssured.given().header(AUTHORIZATION_HEADER, (Object)"invalid", new Object[0]);
                    continue block10;
                }
                case "NO_TOKEN": {
                    request = RestAssured.given().header(AUTHORIZATION_HEADER, (Object)"", new Object[0]);
                    continue block10;
                }
            }
            request = RestAssured.given().header(keyword.key, keyword.value, new Object[0]);
            if (!keyword.key.equals(AUTHORIZATION_HEADER)) continue;
            Config.putValue(AUTHORIZATION_HEADER, (String)keyword.value);
        }
        return request;
    }

    public static RequestSpecification evaluateRequestBody(ServiceObject apiObject, RequestSpecification request) {
        if (apiObject.getRequestBody().isEmpty()) {
            return request;
        }
        request = request.contentType(apiObject.getContentType());
        if (apiObject.getContentType().contains("form")) {
            String[] formData;
            request = request.config(RestAssured.config().encoderConfig(EncoderConfig.encoderConfig().encodeContentTypeAs("multipart/form-data", ContentType.TEXT)));
            for (String data : formData = apiObject.getRequestBody().split(",")) {
                String[] keyValue = data.split(":");
                if (keyValue.length == 3) {
                    switch (keyValue[1]) {
                        case "FILE": {
                            File file = DataHelper.getFile(keyValue[2]);
                            request.multiPart(file);
                            break;
                        }
                    }
                    continue;
                }
                request = request.formParam(keyValue[0].trim(), new Object[]{keyValue[1].trim()});
            }
            return request;
        }
        return request.body(apiObject.getRequestBody());
    }

    public static RequestSpecification evaluateOption(ServiceObject apiObject, RequestSpecification request) {
        if (apiObject.getOption().isEmpty()) {
            return request;
        }
        apiObject.withOption(DataHelper.replaceParameters(apiObject.getOption()));
        switch (apiObject.getOption()) {
            default: 
        }
        return request;
    }

    public static Response evaluateRequest(ServiceObject apiObject) {
        Response response = null;
        RequestSpecification request = RestApiInterface.evaluateRequestHeaders(apiObject);
        request = RestApiInterface.evaluateRequestBody(apiObject, request);
        request = RestApiInterface.evaluateOption(apiObject, request);
        TestLog.logPass("request body: " + Helper.stringRemoveLines(apiObject.getRequestBody()), new Object[0]);
        TestLog.logPass("request type: " + apiObject.getMethod(), new Object[0]);
        switch (apiObject.getMethod()) {
            case "POST": {
                response = (Response)request.when().post(apiObject.getUriPath(), new Object[0]);
                break;
            }
            case "PUT": {
                response = (Response)request.when().put(apiObject.getUriPath(), new Object[0]);
                break;
            }
            case "PATCH": {
                response = (Response)request.when().patch(apiObject.getUriPath(), new Object[0]);
                break;
            }
            case "DELETE": {
                response = (Response)request.when().delete(apiObject.getUriPath(), new Object[0]);
                break;
            }
            case "GET": {
                response = (Response)request.when().get(apiObject.getUriPath(), new Object[0]);
                break;
            }
            case "OPTIONS": {
                response = (Response)request.when().options(apiObject.getUriPath(), new Object[0]);
                break;
            }
            case "HEAD": {
                response = (Response)request.when().head(apiObject.getUriPath(), new Object[0]);
                break;
            }
            default: {
                Helper.assertTrue("request type not found", false);
            }
        }
        TestLog.logPass("response: " + response.getBody().asString(), new Object[0]);
        return (Response)((ValidatableResponse)response.then()).extract().response();
    }
}

