/*
 * Decompiled with CFR 0.152.
 */
package core.apiCore.helpers;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import core.apiCore.helpers.DataHelper;
import core.helpers.Helper;
import core.support.configReader.Config;
import core.support.logger.TestLog;
import core.support.objects.KeyValue;
import io.restassured.response.Response;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XML;
import org.skyscreamer.jsonassert.JSONCompare;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.skyscreamer.jsonassert.JSONCompareResult;

public class JsonHelper {
    public static void saveOutboundJsonParameters(Response response, String outputParam) {
        if (response == null || outputParam.isEmpty()) {
            return;
        }
        JsonHelper.configMapJsonKeyValues(response, outputParam);
    }

    public static void configMapJsonKeyValues(Response response, String keyValue) {
        if (keyValue.isEmpty()) {
            return;
        }
        keyValue = DataHelper.replaceParameters(keyValue);
        List<KeyValue> keywords = DataHelper.getValidationMap(keyValue);
        for (KeyValue keyword : keywords) {
            if (!(keyword.value.toString().startsWith("<") && keyword.value.toString().contains("$") && keyword.value.toString().endsWith(">"))) {
                Helper.assertFalse("variable placement must of format <$variable>: " + keyword.value.toString());
            }
            String key = (String)keyword.value;
            key = key.replace("$", "").replace("<", "").replace(">", "").trim();
            String value = JsonHelper.getJsonValue(response, keyword.key);
            if (!keyword.position.isEmpty()) {
                value = value.split(",")[Integer.valueOf(keyword.position) - 1];
            }
            Config.putValue(key, value);
            TestLog.logPass("replacing value " + key + " with: " + value, new Object[0]);
        }
    }

    public static String getJsonValue(Response response, String path) {
        String value = "";
        List<String> values = JsonHelper.getJsonListValueResponse(response, path);
        if (values == null || values.isEmpty()) {
            value = JsonHelper.getJsonStringResponse(response, path);
        }
        if (values != null && !values.isEmpty()) {
            value = DataHelper.listToString(values);
        }
        return value;
    }

    public static String getJsonValue(String json, String path) {
        String value = "";
        List<String> values = new ArrayList();
        DocumentContext ctx = JsonPath.parse((String)json);
        try {
            values = (List)ctx.read("$." + path, new Predicate[0]);
        }
        catch (Exception e) {
            value = (String)ctx.read("$." + path, new Predicate[0]);
        }
        if (values != null && !values.isEmpty()) {
            value = DataHelper.listToString(values);
        }
        return value;
    }

    public static String getJsonValueFromXml(String xml, String path) {
        String value = "";
        String json = JsonHelper.XMLToJson(xml);
        DocumentContext ctx = JsonPath.parse((String)json);
        List values = (List)ctx.read("$." + path, new Predicate[0]);
        if (values != null && !values.isEmpty()) {
            value = DataHelper.listToString(values);
        }
        return value;
    }

    public static String XMLToJson(String xml) {
        int printIndentFactor = 4;
        String jsonString = "";
        try {
            JSONObject xmlJSONObj = XML.toJSONObject((String)xml);
            jsonString = xmlJSONObj.toString(printIndentFactor);
        }
        catch (JSONException je) {
            je.toString();
        }
        return jsonString;
    }

    public static String getResponseValue(Response response) {
        return response.getBody().asString();
    }

    private static List<String> getJsonListValueResponse(Response response, String path) {
        List<String> values = new ArrayList();
        try {
            values = response.jsonPath().getList(path);
        }
        catch (Exception e) {
            e.getMessage();
        }
        if (values == null || values.isEmpty()) {
            TestLog.ConsoleLog("path: <" + path + "> returned empty results", new Object[0]);
        }
        return values;
    }

    private static String getJsonStringResponse(Response response, String path) {
        String value = "";
        if (response.path(path, new String[0]) instanceof String) {
            value = (String)response.path(path, new String[0]);
        }
        if (response.path(path, new String[0]) instanceof Integer) {
            value = Integer.toString((Integer)response.path(path, new String[0]));
        }
        if (response.path(path, new String[0]) instanceof Boolean) {
            value = Boolean.toString((Boolean)response.path(path, new String[0]));
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    public static List<String> validateJsonKeywords(List<KeyValue> keywords, Response response) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        for (KeyValue keyword : keywords) {
            String jsonPath = Helper.stringNormalize(keyword.key);
            String expectedValue = Helper.stringNormalize((String)keyword.value);
            String command = "";
            String[] expected = expectedValue.split("[\\(\\)]");
            if (expected.length > 1) {
                command = expected[0];
                expectedValue = expected[1];
            } else if (expected.length == 1) {
                command = expectedValue;
                expectedValue = "";
            }
            String responseString = JsonHelper.getJsonValue(response, jsonPath);
            String errorMessage = DataHelper.validateCommand(command, responseString, expectedValue, keyword.position);
            errorMessages.add(errorMessage);
        }
        return errorMessages;
    }

    public static boolean isJSONValid(String test, boolean printError) {
        String error = "";
        try {
            new JSONObject(test);
        }
        catch (JSONException ex) {
            try {
                error = ex.getMessage();
                new JSONArray(test);
            }
            catch (JSONException ex1) {
                if (error.isEmpty()) {
                    error = ex1.getMessage();
                }
                if (printError) {
                    TestLog.ConsoleLog("Invalid Json error: " + error, new Object[0]);
                }
                return false;
            }
        }
        return true;
    }

    public static String validateByJsonBody(String expectedJson, String response) {
        if (JsonHelper.isJSONValid(expectedJson = Helper.stringRemoveLines(expectedJson), true)) {
            TestLog.logPass("expected: " + Helper.stringRemoveLines(expectedJson), new Object[0]);
            try {
                JSONCompareResult result = JSONCompare.compareJSON((String)expectedJson, (String)response, (JSONCompareMode)JSONCompareMode.LENIENT);
                if (result.failed()) {
                    return result.getMessage();
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public static boolean isValidExpectation(String expectedJson) {
        if (JsonHelper.isJSONValid(expectedJson, false)) {
            return true;
        }
        return (expectedJson = Helper.stringNormalize(expectedJson)).startsWith("_VERIFY.JSON.PART_") || expectedJson.startsWith("_NOT_EMPTY_") || expectedJson.startsWith("_VERIFY.RESPONSE.BODY_");
    }

    public static List<String> validateByKeywords(String expectedJson, Response response) {
        List<String> errorMessages = new ArrayList<String>();
        if (!JsonHelper.isJSONValid(expectedJson = Helper.stringNormalize(expectedJson), false)) {
            if (expectedJson.startsWith("_VERIFY.JSON.PART_")) {
                List<KeyValue> keywords = DataHelper.getValidationMap(expectedJson);
                errorMessages = JsonHelper.validateJsonKeywords(keywords, response);
            } else if (expectedJson.startsWith("_NOT_EMPTY_")) {
                String resonseBody = response.getBody().asString();
                if (response == null || resonseBody.isEmpty()) {
                    errorMessages.add("response is empty");
                }
            }
        }
        return errorMessages;
    }

    public static String validateResponseBody(String expected, Response response) {
        if (!expected.startsWith("_VERIFY.RESPONSE.BODY_")) {
            return "";
        }
        expected = JsonHelper.removeResponseIndicator(expected);
        String actual = JsonHelper.getResponseValue(response);
        String[] expectedArr = expected.split("[\\(\\)]");
        String command = expectedArr[0].trim();
        String expectedValue = expectedArr[1].trim();
        return DataHelper.validateCommand(command, actual, expectedValue, "1");
    }

    public static String removeResponseIndicator(String expected) {
        ArrayList<String> indicator = new ArrayList<String>();
        indicator.add("_VERIFY.RESPONSE.BODY_");
        indicator.add("_VERIFY.JSON.PART_");
        for (String value : indicator) {
            expected = expected.replace(value, "");
        }
        return expected;
    }
}

