/*
 * Decompiled with CFR 0.152.
 */
package core.apiCore.helpers;

import core.apiCore.helpers.JsonHelper;
import core.helpers.Helper;
import core.support.configReader.Config;
import core.support.configReader.PropertiesReader;
import core.support.logger.TestLog;
import core.support.objects.KeyValue;
import core.support.objects.ServiceObject;
import core.support.objects.TestObject;
import io.netty.util.internal.StringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class DataHelper {
    public static final String VERIFY_JSON_PART_INDICATOR = "_VERIFY.JSON.PART_";
    public static final String VERIFY_RESPONSE_BODY_INDICATOR = "_VERIFY.RESPONSE.BODY_";

    public static String replaceParameters(String source) {
        if (source.isEmpty()) {
            return source;
        }
        List<String> parameters = Helper.getValuesFromPattern(source, "<@(.+?)>");
        String valueStr = null;
        Object val = null;
        int length = 0;
        for (String parameter : parameters) {
            if (parameter.contains("_TIME")) {
                length = DataHelper.getIntFromString(parameter);
                if (length > 19) {
                    length = 19;
                }
                valueStr = TestObject.getTestInfo().startTime.substring(0, length);
            } else if (parameter.contains("_RAND")) {
                length = DataHelper.getIntFromString(parameter);
                valueStr = TestObject.getTestInfo().randStringIdentifier.substring(0, length);
            } else {
                val = Config.getObjectValue(parameter);
                if (val instanceof String) {
                    valueStr = (String)val;
                }
            }
            if (StringUtil.isNullOrEmpty((String)valueStr)) {
                TestLog.logWarning("parameter value not found: " + parameter, new Object[0]);
            }
            if (!(valueStr instanceof String)) continue;
            source = source.replace("<@" + parameter + ">", Matcher.quoteReplacement(valueStr));
        }
        return source;
    }

    public static int getIntFromString(String value) {
        return Integer.parseInt(value.replaceAll("[\\D]", ""));
    }

    public static List<KeyValue> getValidationMap(String expected) {
        ArrayList<KeyValue> keywords = new ArrayList<KeyValue>();
        expected = JsonHelper.removeResponseIndicator(expected);
        String[] keyVals = expected.split(";");
        String key = "";
        String position = "";
        String value = "";
        for (String keyVal : keyVals) {
            List<String> parts = DataHelper.splitRight(keyVal, ":", 3);
            if (parts.size() == 1) {
                key = Helper.stringRemoveLines(parts.get(0));
            }
            if (parts.size() == 2) {
                key = Helper.stringRemoveLines(parts.get(0));
                position = "";
                value = Helper.stringRemoveLines(parts.get(1));
            } else if (parts.size() == 3) {
                key = Helper.stringRemoveLines(parts.get(0));
                position = Helper.stringRemoveLines(parts.get(1));
                value = Helper.stringRemoveLines(parts.get(2));
            }
            if (key.isEmpty()) continue;
            KeyValue keyword = new KeyValue(key, position, value);
            keywords.add(keyword);
        }
        return keywords;
    }

    public static String getTagValue(String requestBody, String tag) {
        String value = "";
        try {
            String patternString = ":" + tag + ">(.+?)</";
            Pattern pattern = Pattern.compile(patternString);
            Matcher matcher = pattern.matcher(requestBody);
            matcher.find();
            value = matcher.group(1);
        }
        catch (Exception e) {
            e.getMessage();
        }
        return value;
    }

    public static String getTemplateFileLocation(String file) {
        String templatePath = Config.getValue("api.templatePath");
        String templateTestPath = PropertiesReader.getLocalRootPath() + templatePath;
        return templateTestPath + file;
    }

    public static Path getTemplateFilePath(String file) {
        String templatePath = Config.getValue("api.templatePath");
        String templateTestPath = PropertiesReader.getLocalRootPath() + templatePath;
        String fullLocation = templateTestPath + file;
        return new File(fullLocation).toPath();
    }

    public static File getFile(String filename) {
        String templatePath = Config.getValue("api.templatePath");
        String templateTestPath = PropertiesReader.getLocalRootPath() + templatePath;
        File file = new File(templateTestPath + filename);
        return file;
    }

    public static String convertTemplateToString(String templateFilePath) {
        String xml = "";
        try {
            xml = new String(Files.readAllBytes(new File(templateFilePath).toPath()), StandardCharsets.UTF_8);
            System.out.println(xml.length());
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return xml;
    }

    public static String getServiceObjectTemplateString(ServiceObject serviceObject) {
        String path = DataHelper.getTemplateFileLocation(serviceObject.getTemplateFile());
        File file = new File(path);
        return DataHelper.convertTemplateToString(file.getAbsolutePath());
    }

    public static void validateCommand(String command, String responseString, String expectedString) {
        DataHelper.validateCommand(command, responseString, expectedString, "");
    }

    public static String validateCommand(String command, String responseString, String expectedString, String position) {
        Object[] expectedArray = expectedString.split(",");
        Object[] actualArray = responseString.split(",");
        Object actualString = "";
        if (!position.isEmpty()) {
            boolean inBounds;
            int positionInt = Integer.valueOf(position);
            expectedString = expectedArray[0];
            boolean bl = inBounds = positionInt > 0 && positionInt <= actualArray.length;
            if (!inBounds) {
                Helper.assertFalse("items returned are less than specified. returned: " + actualArray.length + " specified: " + positionInt);
            }
            actualString = actualArray[positionInt - 1];
        }
        switch (command) {
            case "hasItems": {
                boolean val = false;
                if (!position.isEmpty()) {
                    TestLog.logPass("verifying: " + (String)actualString + " has item " + expectedString, new Object[0]);
                    val = ((String)actualString).contains(expectedString);
                    if (val) break;
                    return (String)actualString + " does not have item " + expectedString;
                }
                TestLog.logPass("verifying: " + Arrays.toString(actualArray) + " has items " + Arrays.toString(expectedArray), new Object[0]);
                val = Arrays.asList(actualArray).containsAll(Arrays.asList(expectedArray));
                if (val) break;
                return Arrays.toString(actualArray) + " does not have items " + Arrays.toString(expectedArray);
            }
            case "equalTo": {
                if (!position.isEmpty()) {
                    TestLog.logPass("verifying: " + (String)actualString + " equals " + expectedString, new Object[0]);
                    boolean val = ((String)actualString).equals(expectedString);
                    if (val) break;
                    return (String)actualString + " does not equal " + expectedString;
                }
                TestLog.logPass("verifying: " + Arrays.toString(actualArray) + " equals " + Arrays.toString(expectedArray), new Object[0]);
                boolean val = Arrays.equals(expectedArray, actualArray);
                if (val) break;
                return Arrays.toString(actualArray) + " does not equal " + Arrays.toString(expectedArray);
            }
            case "contains": {
                if (!position.isEmpty()) {
                    TestLog.logPass("verifying: " + (String)actualString + " contains " + expectedString, new Object[0]);
                    boolean val = ((String)actualString).contains(expectedString);
                    if (val) break;
                    return (String)actualString + " does not contain " + expectedString;
                }
                TestLog.logPass("verifying: " + Arrays.toString(actualArray) + " contains " + Arrays.toString(expectedArray), new Object[0]);
                boolean val = Arrays.asList(actualArray).containsAll(Arrays.asList(expectedArray));
                if (val) break;
                return Arrays.toString(actualArray) + " does not contain " + Arrays.toString(expectedArray);
            }
            case "containsInAnyOrder": {
                TestLog.logPass("verifying: " + Arrays.toString(actualArray) + " contains any order " + Arrays.toString(expectedArray), new Object[0]);
                boolean val = Arrays.asList(actualArray).containsAll(Arrays.asList(expectedArray));
                if (val) break;
                return Arrays.toString(actualArray) + " does not contain in any order " + Arrays.toString(expectedArray);
            }
            case "nodeSizeGreaterThan": {
                int intValue = Integer.valueOf(expectedString);
                TestLog.logPass("verifying node with size " + actualArray.length + " greater than " + intValue, new Object[0]);
                if (intValue < actualArray.length) break;
                return "response node size is: " + actualArray.length + " expected it to be greated than: " + intValue;
            }
            case "nodeSizeExact": {
                int intValue = Integer.valueOf(expectedString);
                TestLog.logPass("verifying node with size " + actualArray.length + " equals " + intValue, new Object[0]);
                if (actualArray.length == intValue) break;
                return "response node size is: " + actualArray.length + " expected: " + intValue;
            }
            case "sequence": {
                TestLog.logPass("verifying: " + Arrays.toString(actualArray) + " with sequence " + Arrays.toString(expectedArray), new Object[0]);
                boolean val = Arrays.equals(expectedArray, actualArray);
                if (val) break;
                return Arrays.toString(actualArray) + " does not equal " + Arrays.toString(expectedArray);
            }
            case "isNotEmpty": {
                TestLog.logPass("verifying response for path is not empty", new Object[0]);
                if (!responseString.isEmpty()) break;
                return "value is empty";
            }
            case "isEmpty": {
                TestLog.logPass("verifying response for path is empty ", new Object[0]);
                if (responseString.isEmpty()) break;
                return "value is not empty";
            }
            default: {
                Helper.assertFalse("Command not set. Options: hasItems, equalTo, contains, containsInAnyOrder, nodeSizeGreaterThan, nodeSizeExact, sequence, isNotEmpty, isEmpty. See examples for usage.");
            }
        }
        return "";
    }

    public static String listToString(List<String> values) {
        return StringUtils.join(values, (String)",");
    }

    public static List<String> splitRight(String value, String regex, int limit) {
        String string = value;
        ArrayList<String> result = new ArrayList<String>();
        String[] temp = new String[]{};
        for (int i = 1; i < limit; ++i) {
            if (!string.matches(".*" + regex + ".*")) continue;
            temp = string.split(DataHelper.modifyRegex(regex));
            result.add(temp[1]);
            string = temp[0];
        }
        if (temp.length > 0) {
            result.add(temp[0]);
        }
        if (value.split(":").length == 1) {
            result.add(string);
        }
        Collections.reverse(result);
        return result;
    }

    private static String modifyRegex(String regex) {
        return regex + "(?!.*" + regex + ".*$)";
    }
}

