/*
 * Decompiled with CFR 0.152.
 */
package core.apiCore.driver;

import core.apiCore.helpers.CsvReader;
import core.support.logger.TestLog;
import core.support.objects.ServiceObject;
import core.support.objects.TestObject;
import core.uiCore.drivers.AbstractDriverTestNG;

public class ApiTestDriver {
    public static void setTestId(ServiceObject apiObject) {
        String csvFileName = ApiTestDriver.getTestClass(apiObject);
        TestObject.setTestName(apiObject.getTestCaseID());
        TestObject.setTestId(csvFileName + "-" + apiObject.getTestCaseID());
    }

    public static String getTestClass(ServiceObject apiObject) {
        String testClass = apiObject.getTcName();
        return ApiTestDriver.getTestClass(testClass);
    }

    public static String getTestClass(String csvFilename) {
        String testClass = csvFilename.split("\\.")[0];
        testClass = testClass.replace(CsvReader.SERVICE_CSV_FILE_PREFIX, "");
        return testClass;
    }

    public void initTest(ServiceObject apiObject) {
        String APP = "ServiceManager";
        ApiTestDriver.setTestId(apiObject);
        String testId = TestObject.currentTestId.get();
        TestLog.removeLogUtilHandler();
        String classname = ApiTestDriver.getTestClass(apiObject);
        classname = apiObject.getParentClass() + "-" + classname + TestObject.BEFORE_METHOD_PREFIX;
        TestObject.initializeTest(classname);
        TestObject.initializeTest(testId);
        TestObject.getTestInfo().config = TestObject.getTestInfo((String)classname).config;
        TestObject.getTestInfo().testLog = TestObject.getTestInfo((String)classname).testLog;
        TestObject.getTestInfo().type = TestObject.testType.service;
        TestObject.getTestInfo().app = APP;
        TestObject.getTestInfo().testCsvFileName = apiObject.getTcName();
        TestObject.getTestInfo().className = ApiTestDriver.getTestClass(apiObject);
        TestObject.getTestInfo().testName = apiObject.getTestCaseID();
        TestObject.getTestInfo().currentTestIndex = Integer.valueOf(apiObject.getTcIndex());
        if (TestObject.getTestInfo().testCountInCsvFile == 0) {
            TestObject.getTestInfo().testCountInCsvFile = CsvReader.getCsvTestListForTestRunner(apiObject.getTcName()).size();
        }
    }

    public static boolean isTestComplete() {
        if (TestObject.getTestInfo().currentTestIndex == CsvReader.getCsvTestcount()) {
            TestObject.getTestInfo().isTestComplete = true;
            return true;
        }
        return false;
    }

    public String getClassName() {
        String className = this.getClass().toString().substring(this.getClass().toString().lastIndexOf(".") + 1);
        return className;
    }

    public static boolean isRunningServiceTest() {
        return TestObject.getTestInfo().type.equals((Object)TestObject.testType.service);
    }

    public static boolean isRunningServiceTest(Object[] testData) {
        if (testData.length != CsvReader.SERVICE_CSV_COLUMN_COUNT) {
            return false;
        }
        if (testData[testData.length - 1] == null) {
            return false;
        }
        return testData[testData.length - 1].equals(TestObject.testType.service.name());
    }

    public static void setServiceTestName(Object[] testData) {
        if (ApiTestDriver.isRunningServiceTest(testData)) {
            ServiceObject apiObject = CsvReader.mapToApiObject(testData);
            String testClass = ApiTestDriver.getTestClass(apiObject.getTcName());
            AbstractDriverTestNG.testName.set(testClass + "-" + apiObject.getTestCaseID());
        }
    }
}

