/*
 * Decompiled with CFR 0.152.
 */
package core.apiCore;

import core.apiCore.interfaces.Authentication;
import core.apiCore.interfaces.AzureInterface;
import core.apiCore.interfaces.RestApiInterface;
import core.apiCore.interfaces.SqlInterface;
import core.apiCore.interfaces.TestPrepare;
import core.helpers.Helper;
import core.support.objects.ServiceObject;
import core.uiCore.drivers.AbstractDriverTestNG;

public class ServiceManager {
    private static final String TOKEN_GENERATOR = "Authentication";
    public static final String SERVICE_TEST_RUNNER_ID = "ServiceTestRunner";
    private static final String RESTFULL_API_INTERFACE = "RESTfulAPI";
    private static final String SQL_DB_INTERFACE = "SQLDB";
    private static final String AZURE_INTERFACE = "AZURE";
    private static final String TEST_PREPARE_INTERFACE = "TestPrepare";

    public static void TestRunner(ServiceObject apiObject) throws Exception {
        new AbstractDriverTestNG().setupApiDriver(apiObject);
        ServiceManager.runInterface(apiObject);
    }

    public static void runInterface(ServiceObject apiObject) throws Exception {
        switch (apiObject.getInterfaceType()) {
            case "Authentication": {
                Authentication.tokenGenerator(apiObject);
                break;
            }
            case "RESTfulAPI": {
                RestApiInterface.RestfullApiInterface(apiObject);
                break;
            }
            case "SQLDB": {
                SqlInterface.DataBaseInterface(apiObject);
                break;
            }
            case "AZURE": {
                AzureInterface.AzureClientInterface(apiObject);
                break;
            }
            case "TestPrepare": {
                TestPrepare.TestPrepareInterface(apiObject);
                break;
            }
            default: {
                Helper.assertFalse("no interface found: " + apiObject.getInterfaceType());
            }
        }
    }
}

