/*
 * Decompiled with CFR 0.152.
 */
package core.uiCore.drivers;

import com.aventstack.extentreports.ExtentReports;
import com.aventstack.extentreports.ExtentTest;
import core.apiCore.driver.ApiTestDriver;
import core.apiCore.helpers.CsvReader;
import core.helpers.Helper;
import core.support.configReader.Config;
import core.support.listeners.RetryTest;
import core.support.listeners.TestListener;
import core.support.logger.ExtentManager;
import core.support.logger.TestLog;
import core.support.objects.DriverObject;
import core.support.objects.ServiceObject;
import core.support.objects.TestObject;
import core.uiCore.WebDriverSetup;
import core.uiCore.driverProperties.capabilities.AndroidCapability;
import core.uiCore.driverProperties.driverType;
import core.uiCore.driverProperties.globalProperties.CrossPlatformProperties;
import core.uiCore.drivers.AbstractDriver;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.openqa.selenium.WebDriver;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Listeners;

@Listeners(value={TestListener.class})
public class AbstractDriverTestNG {
    public static ExtentReports extent;
    public static ThreadLocal<ExtentTest> step;
    public static Map<String, ExtentTest> classList;
    private static ThreadLocal<WebDriver> webDriver;
    public RetryTest retry = new RetryTest();

    public synchronized void setupApiDriver(ServiceObject apiObject) throws Exception {
        Logger log;
        new ApiTestDriver().initTest(apiObject);
        TestObject.getTestInfo().log = log = Logger.getLogger((String)"");
        ExtentManager.reportSetup();
    }

    public static synchronized WebDriver setupWebDriver(DriverObject driverObject) throws Exception {
        boolean condition3;
        AbstractDriverTestNG.initTest(driverObject);
        ExtentManager.reportSetup();
        TestLog.ConsoleLogDebug("driverObject.driverType: " + (Object)((Object)driverObject.driverType), new Object[0]);
        if (driverObject.driverType != null && driverObject.driverType.equals((Object)driverType.DriverType.API)) {
            return null;
        }
        AbstractDriverTestNG.setWebDriver(DriverObject.getFirstAvailableDriver());
        TestLog.ConsoleLogDebug("isForcedRestart: " + TestObject.getTestInfo().isForcedRestart + " isSingleSignIn(): " + CrossPlatformProperties.isSingleSignIn() + " webDriver: " + AbstractDriver.getWebDriver(), new Object[0]);
        boolean condition1 = TestObject.getTestInfo().isForcedRestart != false && CrossPlatformProperties.isSingleSignIn() != false;
        boolean condition2 = CrossPlatformProperties.isSingleSignIn() == false;
        boolean bl = condition3 = AbstractDriver.getWebDriver() == null;
        if (condition1 || condition2 || condition3) {
            AbstractDriverTestNG.setWebDriver(AbstractDriverTestNG.createDriver(driverObject));
            driverObject.withIsAvailable(false);
            DriverObject.initializeDriverList(driverObject, TestObject.getTestInfo().testId);
            TestObject.getTestInfo().withIsFirstRun(true);
        }
        TestObject.getTestInfo().withWebDriver(AbstractDriver.getWebDriver());
        AbstractDriverTestNG.getURL(driverObject.initialURL);
        AbstractDriverTestNG.setFullScreen();
        return AbstractDriver.getWebDriver();
    }

    public void setupWebDriver(String testId, DriverObject driver) {
        TestObject.setTestId(testId);
        try {
            AbstractDriverTestNG.setupWebDriver(driver);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void setFullScreen() {
        if (!Helper.mobile.isMobile() && Config.getValue("web.maximizeBrowser").equals("true")) {
            Helper.page.maximizePage();
        }
    }

    public static void initTest(DriverObject driverObject) {
        String testId = TestObject.getTestId();
        TestLog.removeLogUtilHandler();
        TestObject.initializeTest(driverObject, testId);
        TestObject.setLogging();
        TestObject.getTestInfo().withCurrentDriver(driverObject);
        DriverObject.initializeDriverList(driverObject, testId);
    }

    public static void setWebDriver(WebDriver webDriver) {
        AbstractDriverTestNG.webDriver.set(webDriver);
    }

    @BeforeMethod(alwaysRun=true)
    public void handleTestMethodName(Method method) {
        TestObject.setTestName(method.getName());
        TestObject.setTestId(this.getClassName(), TestObject.currentTestName.get());
        this.setAndIncremenetDataProviderTestExtention(method);
        DriverObject driver = new DriverObject().withDriverType(driverType.DriverType.API);
        new AbstractDriverTestNG().setupWebDriver(TestObject.getTestId(), driver);
    }

    private void setAndIncremenetDataProviderTestExtention(Method method) {
        if (this.isDataProviderRunning(method)) {
            int invocationCount = TestObject.getTestInvocationCount(TestObject.getTestId());
            TestObject.setTestName(method.getName() + TestObject.DATAPROVIDER_TEST_SUFFIX + ++invocationCount);
            TestObject.setTestId(this.getClassName(), TestObject.currentTestName.get());
        }
    }

    private void setDataProviderTestExtention(Method method) {
        if (this.isDataProviderRunning(method)) {
            int invocationCount = TestObject.getTestInvocationCount(TestObject.getTestId());
            TestObject.setTestName(method.getName() + TestObject.DATAPROVIDER_TEST_SUFFIX + invocationCount);
            TestObject.setTestId(this.getClassName(), TestObject.currentTestName.get());
        }
    }

    private boolean isDataProviderRunning(Method method) {
        return method.getParameterCount() > 0;
    }

    @AfterMethod(alwaysRun=true)
    public void afterMethod(Method method) {
        if (!CsvReader.isRunningServiceTest()) {
            TestObject.setTestName(method.getName());
            TestObject.setTestId(this.getClassName(), TestObject.currentTestName.get());
            this.setDataProviderTestExtention(method);
        }
        DriverObject driver = new DriverObject().withDriverType(driverType.DriverType.API);
        new AbstractDriverTestNG().setupWebDriver(TestObject.getTestId(), driver);
    }

    private String getClassName() {
        String className = this.getClass().toString().substring(this.getClass().toString().lastIndexOf(".") + 1);
        return className;
    }

    private static WebDriver createDriver(DriverObject driverObject) throws Exception {
        int retry = 3;
        WebDriver driver = null;
        do {
            try {
                --retry;
                driver = new WebDriverSetup().getWebDriverByType(driverObject);
            }
            catch (Exception e) {
                if (retry > 0) {
                    TestLog.ConsoleLog("driver failed to start. retrying " + retry + " more time(s) ...", new Object[0]);
                }
                Helper.wait.waitForSeconds(3.0);
                if (retry != 0) continue;
                if (driverObject.driverType.equals((Object)driverType.DriverType.ANDROID_DRIVER)) {
                    AndroidCapability.printAndroidHelp(e);
                }
                throw e;
            }
        } while (driver == null && retry > 0);
        TestLog.ConsoleLog("driver created successfully", new Object[0]);
        Helper.assertTrue("driver was not created", driver != null);
        return driver;
    }

    private static void getURL(String url) {
        if (!url.isEmpty()) {
            TestLog.logPass("I am the site '" + url + "'", new Object[0]);
            AbstractDriverTestNG.getWebDriver().get(url);
        }
    }

    public static WebDriver getWebDriver() {
        return webDriver.get();
    }

    @AfterMethod
    public void shutdown() {
        this.letRetryKnowAboutReports();
    }

    private void letRetryKnowAboutReports() {
        this.retry.setExtendReport(TestObject.getTestInfo().testScenerio, step.get());
    }

    static {
        step = new ThreadLocal();
        classList = new HashMap<String, ExtentTest>();
        webDriver = new ThreadLocal();
    }
}

