/*
 * Decompiled with CFR 0.152.
 */
package core.support.objects;

import com.aventstack.extentreports.ExtentTest;
import core.apiCore.helpers.CsvReader;
import core.helpers.Helper;
import core.support.configReader.Config;
import core.support.logger.LogObject;
import core.support.objects.DriverObject;
import core.support.objects.ServiceObject;
import core.uiCore.drivers.AbstractDriver;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.junit.runner.Description;
import org.monte.screenrecorder.ScreenRecorder;
import org.openqa.selenium.WebDriver;

public class TestObject {
    public static String BEFORE_SUITE_PREFIX = "-Beforesuite";
    public static String AFTER_SUITE_PREFIX = "-Aftersuite";
    public static String BEFORE_CLASS_PREFIX = "-Beforeclass";
    public static String AFTER_CLASS_PREFIX = "-Afterclass";
    public static String DATAPROVIDER_TEST_SUFFIX = "-test";
    public static final String DEFAULT_TEST = "core";
    public static final String DEFAULT_APP = "auto";
    public static String SUITE_NAME = "";
    public static String APP_IDENTIFIER = "";
    public static final String TEST_APP_API = "api";
    public List<WebDriver> webDriverList = new ArrayList<WebDriver>();
    public String app = "";
    public testType type;
    public String testId = "";
    public String testName = "";
    public String className = "";
    public String deviceName = "";
    public String testFileClassName;
    public DriverObject currentDriver;
    public Boolean isFirstRun = false;
    public Boolean isForcedRestart = false;
    public boolean isLoggedIn = true;
    public String loggedInUser = "";
    public String loggedInPassword;
    public int runCount = 0;
    public Boolean isTestPass = false;
    public Boolean isTestComplete = false;
    public Logger log;
    public int currentTestIndex = 0;
    public int testCountInCsvFile = 0;
    public String testCsvFileName;
    public Description description;
    public Throwable caughtThrowable = null;
    public ArrayList<String> failTrace = new ArrayList();
    public ExtentTest testFeature;
    public ExtentTest testScenerio;
    public List<ExtentTest> testSteps = new ArrayList<ExtentTest>();
    public List<String> testSubSteps = new ArrayList<String>();
    public ScreenRecorder screenRecorder = null;
    public String startTime;
    public String randStringIdentifier;
    public List<LogObject> testLog = new ArrayList<LogObject>();
    public Map<String, String> languageMap = new ConcurrentHashMap<String, String>();
    public Map<String, ServiceObject> apiMap = new ConcurrentHashMap<String, ServiceObject>();
    public Map<String, Object> config = new ConcurrentHashMap<String, Object>();
    public static ThreadLocal<String> currentTestName = new ThreadLocal();
    public static ThreadLocal<String> currentTestId = new ThreadLocal();
    public String language;
    public static Map<String, TestObject> testInfo = new ConcurrentHashMap<String, TestObject>();

    public TestObject withWebDriver(WebDriver webdriver) {
        this.webDriverList.add(webdriver);
        return this;
    }

    public static void initializeTest(String testId) {
        DriverObject driver = new DriverObject().withApp(TEST_APP_API);
        TestObject.initializeTest(driver, testId);
    }

    public static void initializeTest(DriverObject driver, String testId) {
        if (TestObject.isBeforeTest(testId)) {
            TestObject test = new TestObject();
            test = TestObject.inheritParent(driver, testId);
            test.withTestId(testId).withTestName(test.getTestName()).withTestStartTime(Helper.date.getTimestampMiliseconds()).withApp(driver.app).withRandomStringIdentifier();
            testInfo.put(testId, test);
            Config.loadConfig(testId);
            CsvReader.getAllKeywords();
            TestObject.getTestInfo().type = testType.uiTest;
        }
    }

    public static TestObject inheritParent(DriverObject driver, String testId) {
        TestObject test = new TestObject();
        test.config.putAll(TestObject.getTestObjectInheritence((DriverObject)driver, (String)testId).config);
        return test;
    }

    public static TestObject getTestObjectInheritence(DriverObject driver, String testId) {
        testState testObjectState = TestObject.getTestState(testId);
        String[] testValues = testId.split("-");
        String testName = testValues[0];
        if (driver.app.equals(TEST_APP_API)) {
            return new TestObject();
        }
        if (testName.equals(DEFAULT_TEST)) {
            return new TestObject();
        }
        if (testId.contains(BEFORE_CLASS_PREFIX)) {
            return TestObject.getTestInfo(SUITE_NAME + BEFORE_SUITE_PREFIX);
        }
        if (testObjectState == testState.testMethod) {
            return TestObject.getTestInfo(testName + BEFORE_CLASS_PREFIX);
        }
        if (testId.contains(AFTER_CLASS_PREFIX)) {
            return TestObject.getTestInfo(testName + BEFORE_CLASS_PREFIX);
        }
        if (testId.contains(AFTER_SUITE_PREFIX)) {
            return TestObject.getTestInfo(SUITE_NAME + BEFORE_SUITE_PREFIX);
        }
        return new TestObject();
    }

    public static boolean isFirstRun() {
        if (AbstractDriver.getWebDriver() == null) {
            return true;
        }
        return TestObject.getTestInfo().isFirstRun != false;
    }

    public static TestObject getTestInfo() {
        String testId = TestObject.getTestId();
        if (testInfo.get(testId) == null) {
            TestObject.initializeTest(new DriverObject(), DEFAULT_TEST);
            testId = DEFAULT_TEST;
        }
        return testInfo.get(testId);
    }

    public static void updateAppName(DriverObject driver) {
        if (TestObject.getTestInfo((String)DEFAULT_TEST).app.equals(DEFAULT_APP)) {
            TestObject.getTestInfo(DEFAULT_TEST).withApp(driver.app);
        }
    }

    public static testState getTestState(String testName) {
        if (testName.contains(BEFORE_SUITE_PREFIX) || testName.contains(AFTER_SUITE_PREFIX)) {
            return testState.suite;
        }
        if (testName.contains(BEFORE_CLASS_PREFIX) || testName.contains(AFTER_CLASS_PREFIX)) {
            return testState.testClass;
        }
        if (testName.equals(DEFAULT_TEST)) {
            return testState.defaultState;
        }
        return testState.testMethod;
    }

    public static void setTestName(String testName) {
        currentTestName.set(testName);
    }

    public static void setTestId(String testId) {
        currentTestId.set(testId);
    }

    public static void setTestId(String testclass, String testname) {
        currentTestId.set(testclass + "-" + testname);
    }

    public static String getTestId() {
        String testId = currentTestId.get();
        if (testId == null || testId.isEmpty()) {
            testId = DEFAULT_TEST;
        }
        return testId;
    }

    public static boolean isTestObjectSet(String testId) {
        return testInfo.get(testId) != null;
    }

    public static boolean isTestObjectSet() {
        String testId = currentTestId.get();
        if (testInfo.isEmpty()) {
            return false;
        }
        return testId != null && testInfo.get(testId) != null;
    }

    public static boolean hasTestStarted() {
        String testId = TestObject.getTestId();
        if (testId != null && testId.contains("-")) {
            return true;
        }
        if (testId == null || testInfo.get(testId) == null) {
            return false;
        }
        return TestObject.getTestInfo().testCountInCsvFile > 0;
    }

    public static void setLogging() {
        Logger log;
        TestObject.getTestInfo().log = log = Logger.getLogger((String)"");
    }

    public static TestObject getTestInfo(String testId) {
        TestObject test = testInfo.get(testId);
        Helper.assertTrue("test id not found. testId: " + testId + " testInfo: " + testInfo.toString(), test != null);
        return test;
    }

    public static boolean isBeforeTest(String testId) {
        TestObject test = testInfo.get(testId);
        return test == null;
    }

    public void resetTestObject() {
        if (this.isTestComplete.booleanValue()) {
            if (this.testId.equals(DEFAULT_TEST)) {
                return;
            }
            String testname = TestObject.getTestInfo((String)this.testId).testName;
            String testFileClass = TestObject.getTestInfo((String)this.testId).testFileClassName;
            List<WebDriver> webDrivers = TestObject.getTestInfo((String)this.testId).webDriverList;
            int runCount = TestObject.getTestInfo((String)this.testId).runCount;
            testInfo.put(this.testId, new TestObject().withTestId(this.testId).withTestName(testname).withTestFileClassName(testFileClass).withWebDriverList(webDrivers).withRunCount(runCount));
            TestObject.getTestInfo((String)this.testId).config.putAll(TestObject.getTestInfo((String)DEFAULT_TEST).config);
        }
    }

    public static int getTestInvocationCount(String testname) {
        String tempTestname = testname;
        int invocationCount = 0;
        while (TestObject.isTestObjectSet(tempTestname = testname + DATAPROVIDER_TEST_SUFFIX + ++invocationCount)) {
        }
        return --invocationCount;
    }

    public static boolean isTestcomplete() {
        int currentTestIndex = TestObject.getTestInfo().currentTestIndex;
        int testCountInCsv = TestObject.getTestInfo().testCountInCsvFile;
        if (testCountInCsv == 0) {
            return true;
        }
        return currentTestIndex == testCountInCsv - 1;
    }

    public static ServiceObject getApiDef(String key) {
        CsvReader.getAllKeywords();
        return TestObject.getTestInfo().apiMap.get(key);
    }

    public TestObject withIsFirstRun(Boolean isFirstRun) {
        this.isFirstRun = isFirstRun;
        return this;
    }

    public TestObject withIsForcedRestart(Boolean isForcedRestart) {
        this.isForcedRestart = isForcedRestart;
        return this;
    }

    public TestObject withCurrentDriver(DriverObject currentDriver) {
        this.currentDriver = currentDriver;
        return this;
    }

    public TestObject withTestId(String testId) {
        this.testId = testId;
        this.className = testId.contains("-") ? testId.split("-")[0] : testId;
        return this;
    }

    public TestObject withTestStartTime(String time) {
        this.startTime = String.valueOf(time);
        return this;
    }

    public TestObject withRandomStringIdentifier() {
        String rand;
        this.randStringIdentifier = rand = Helper.generateRandomString(30);
        return this;
    }

    public TestObject withTestName(String testName) {
        this.testName = testName;
        return this;
    }

    public TestObject withClassName(String className) {
        this.className = className;
        return this;
    }

    public TestObject withTestFileClassName(String testFileClassName) {
        this.testFileClassName = testFileClassName;
        return this;
    }

    public TestObject withWebDriverList(List<WebDriver> webDriverList) {
        this.webDriverList = webDriverList;
        return this;
    }

    public String getTestName() {
        String testName = this.testId.substring(this.testId.indexOf("-") + 1);
        return testName;
    }

    public String getClassName() {
        String className = this.testId.split("-")[0];
        return className;
    }

    public TestObject withLoggedInUser(String loggedInUser) {
        this.loggedInUser = loggedInUser;
        return this;
    }

    public TestObject withLoggedInPassword(String loggedInPassword) {
        this.loggedInPassword = loggedInPassword;
        return this;
    }

    public TestObject withIsLoggedIn(boolean isLoggedIn) {
        this.isLoggedIn = isLoggedIn;
        return this;
    }

    public boolean isUserLoggedIn() {
        return this.isLoggedIn;
    }

    public TestObject withRunCount(int rerunCount) {
        this.runCount = rerunCount;
        return this;
    }

    public TestObject incremenetRunCount() {
        ++this.runCount;
        return this;
    }

    public TestObject withIsTestPass(Boolean isTestPass) {
        this.isTestPass = isTestPass;
        return this;
    }

    public TestObject withDescription(Description description) {
        this.description = description;
        return this;
    }

    public TestObject withCaughtThrowable(Throwable caughtThrowable) {
        this.caughtThrowable = caughtThrowable;
        return this;
    }

    public TestObject withFailTrace(ArrayList<String> failTrace) {
        this.failTrace = failTrace;
        return this;
    }

    public TestObject withTestScenario(ExtentTest testScenerio) {
        this.testScenerio = testScenerio;
        return this;
    }

    public TestObject withApp(String app) {
        this.app = app;
        return this;
    }

    public static enum testState {
        suite,
        testClass,
        testMethod,
        apiTestMethod,
        defaultState;

    }

    public static enum testType {
        apiTest,
        uiTest;

    }
}

