/*
 * Decompiled with CFR 0.152.
 */
package core.support.logger;

import com.aventstack.extentreports.ExtentTest;
import com.aventstack.extentreports.gherkin.model.And;
import com.aventstack.extentreports.gherkin.model.Background;
import com.aventstack.extentreports.gherkin.model.But;
import com.aventstack.extentreports.gherkin.model.Given;
import com.aventstack.extentreports.gherkin.model.Then;
import com.aventstack.extentreports.gherkin.model.When;
import com.aventstack.extentreports.markuputils.Markup;
import com.aventstack.extentreports.markuputils.MarkupHelper;
import com.ibm.watson.developer_cloud.text_to_speech.v1.TextToSpeech;
import com.ibm.watson.developer_cloud.text_to_speech.v1.model.SynthesizeOptions;
import com.ibm.watson.developer_cloud.text_to_speech.v1.util.WaveUtils;
import core.helpers.Helper;
import core.support.configReader.Config;
import core.support.logger.ExtentManager;
import core.support.logger.LogObject;
import core.support.objects.TestObject;
import core.uiCore.driverProperties.globalProperties.CrossPlatformProperties;
import core.uiCore.drivers.AbstractDriver;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import marytts.LocalMaryInterface;
import marytts.util.data.audio.AudioPlayer;
import org.apache.log4j.Priority;
import org.apache.log4j.xml.DOMConfigurator;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class TestLog {
    public static final String ENABLE_EXTENT_SUBSTEPS = "report.enableDetailedReport";
    public static int MAX_LENGTH = 400;
    public static String WATSON = "WATSON";
    public static String MARY = "MARY";
    static AudioPlayer player;
    public static final String LOG4JPATH;

    public static void ConsoleLog(String value, Object ... args) {
        TestLog.logConsoleMessage(Priority.INFO, TestLog.formatMessage(value, args));
    }

    public static void ConsoleLogWarn(String value, Object ... args) {
        TestLog.logConsoleMessage(Priority.WARN, TestLog.formatMessage(value, args));
    }

    public static void ConsoleLogDebug(String value, Object ... args) {
        TestLog.logConsoleMessage(Priority.DEBUG, TestLog.formatMessage(value, args));
    }

    public static void ConsoleLogError(String value, Object ... args) {
        TestLog.logConsoleMessage(Priority.ERROR, TestLog.formatMessage(value, args));
    }

    public static void Background(String value, Object ... args) {
        TestLog.setTestStep(gherkins.Background, value, args);
    }

    public static void But(String value, Object ... args) {
        TestLog.logConsoleMessage(Priority.INFO, "But " + TestLog.formatMessage(value, args));
        TestLog.setTestStep(gherkins.But, value, args);
    }

    public static void Given(String value, Object ... args) {
        TestLog.logConsoleMessage(Priority.INFO, "Given " + TestLog.formatMessage(value, args));
        TestLog.setTestStep(gherkins.Given, value, args);
    }

    public static void When(String value, Object ... args) {
        TestLog.logConsoleMessage(Priority.INFO, "When " + TestLog.formatMessage(value, args));
        TestLog.setTestStep(gherkins.When, value, args);
        TestLog.playAudio(gherkins.When.name() + " " + TestLog.formatMessage(value, args));
    }

    public static void And(String value, Object ... args) {
        TestLog.logConsoleMessage(Priority.INFO, "And " + TestLog.formatMessage(value, args));
        TestLog.setTestStep(gherkins.And, value, args);
        TestLog.playAudio(gherkins.And.name() + " " + TestLog.formatMessage(value, args));
    }

    public static void Then(String value, Object ... args) {
        TestLog.logConsoleMessage(Priority.INFO, "Then " + TestLog.formatMessage(value, args));
        TestLog.setTestStep(gherkins.Then, value, args);
        TestLog.playAudio(gherkins.Then.name() + " " + TestLog.formatMessage(value, args));
    }

    public static void setTestStep1(ExtentTest testStep) {
        if (TestObject.getTestInfo().testSteps == null) {
            return;
        }
        TestObject.getTestInfo().testSteps.add(testStep);
        AbstractDriver.getStep().set(testStep);
    }

    public static void setTestStep(gherkins gherkinState, String value, Object ... args) {
        ExtentTest testStep = null;
        TestObject.testState state = TestObject.getTestState(TestObject.getTestInfo().testId);
        if (!state.equals((Object)TestObject.testState.testMethod)) {
            return;
        }
        switch (gherkinState) {
            case Given: {
                testStep = TestLog.getTestScenario().createNode(Given.class, "Given " + TestLog.formatMessage(value, args)).pass("");
                break;
            }
            case When: {
                testStep = TestLog.getTestScenario().createNode(When.class, "When " + TestLog.formatMessage(value, args)).pass("");
                break;
            }
            case Then: {
                testStep = TestLog.getTestScenario().createNode(Then.class, "Then " + TestLog.formatMessage(value, args)).pass("");
                break;
            }
            case And: {
                testStep = TestLog.getTestScenario().createNode(And.class, "And " + TestLog.formatMessage(value, args)).pass("");
                break;
            }
            case But: {
                testStep = TestLog.getTestScenario().createNode(But.class, "But " + TestLog.formatMessage(value, args)).pass("");
                break;
            }
            case Background: {
                testStep = TestLog.getTestScenario().createNode(Background.class, TestLog.formatMessage(value, args)).pass("");
                break;
            }
            default: {
                Helper.assertFalse("incorrect state " + gherkinState.name());
            }
        }
        if (TestObject.getTestInfo().testSteps == null) {
            return;
        }
        TestObject.getTestInfo().testSteps.add(testStep);
        AbstractDriver.getStep().set(testStep);
    }

    public static void setPassSubTestStep(String subStep) {
        TestObject.testState state = TestObject.getTestState(TestObject.getTestInfo().testId);
        if (!state.equals((Object)TestObject.testState.testMethod)) {
            return;
        }
        TestObject.getTestInfo().testSubSteps.add(subStep);
        Markup m = MarkupHelper.createCodeBlock((String)subStep);
        AbstractDriver.getStep().get().pass(m);
    }

    public static void attachVideoLog(String path, boolean isVideoAttached) {
        TestObject.testState state = TestObject.getTestState(TestObject.getTestInfo().testId);
        if (!state.equals((Object)TestObject.testState.testMethod)) {
            return;
        }
        if (!Config.getValue("report.reporterType").equals("html")) {
            path = ExtentManager.getReportRootFullPath() + path;
        }
        String videoLog = "<video width=\"320\" height=\"240\" controls>\r\n  <source src=" + path + " type=\"video/mp4\">\r\n  Your browser does not support the video tag.\r\n</video>";
        if (isVideoAttached) {
            AbstractDriver.getStep().get().pass(videoLog);
        }
        AbstractDriver.getStep().get().pass("<a href='" + path + "'>screen recording Link</a>");
        TestObject.getTestInfo().testSubSteps.add("screen recording relative path: " + path);
    }

    public static void logPass(String value, Object ... args) {
        TestLog.logConsoleMessage(Priority.INFO, TestLog.formatMessage(value, args));
        if (Config.getValue(ENABLE_EXTENT_SUBSTEPS).equals("true")) {
            TestLog.setPassSubTestStep(TestLog.formatMessage(value, args));
        }
    }

    public static void logFail(String value, Object ... args) {
        TestLog.logConsoleMessage(Priority.ERROR, TestLog.formatMessage(value, args));
    }

    public static void logWarning(String value, Object ... args) {
        TestLog.logConsoleMessage(Priority.WARN, TestLog.formatMessage(value, args));
        AbstractDriver.getStep().get().warning(TestLog.formatMessage(value, args));
    }

    public static ExtentTest getTestScenario() {
        return TestObject.getTestInfo().testScenerio;
    }

    public static String formatMessage(String value, Object ... args) {
        if (args == null || args.length == 0) {
            return value;
        }
        try {
            return new MessageFormat(value).format(args);
        }
        catch (Exception e) {
            return value;
        }
    }

    public static String setMaxLength(String value) {
        return TestLog.setMaxLength(value, MAX_LENGTH);
    }

    public static String setMaxLength(String value, int length) {
        int maxLength;
        int n = maxLength = value.length() < length ? value.length() : length;
        if (maxLength == length) {
            return value.substring(0, maxLength) + " ...";
        }
        return value.substring(0, maxLength);
    }

    public static void removeLogUtilHandler() {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
    }

    public static void setupLog4j() {
        DOMConfigurator.configure((String)LOG4JPATH);
    }

    public static void playAudio(String value) {
        Boolean isAudioCommentaryEnabled = CrossPlatformProperties.getAudioCommentary();
        String type = CrossPlatformProperties.getAudioCommentaryType();
        if (isAudioCommentaryEnabled.booleanValue()) {
            if (type.equals(WATSON)) {
                TestLog.playWatsonAudio(value);
            } else if (type.equals(MARY)) {
                TestLog.playMaryAudio(value);
            }
        }
    }

    public static void playMaryAudio(String value) {
        try {
            LocalMaryInterface marytts = new LocalMaryInterface();
            Set voices = marytts.getAvailableVoices();
            String[] voiceList = voices.toArray(new String[voices.size()]);
            marytts.setVoice(voiceList[0]);
            AudioInputStream audio = marytts.generateAudio(value);
            player = new AudioPlayer(audio);
            player.start();
            player.join();
        }
        catch (Exception e) {
            e.getMessage();
        }
    }

    public static synchronized void playWatsonAudio(String value) {
        TextToSpeech textToSpeech = new TextToSpeech();
        textToSpeech.setUsernameAndPassword("55fffe86-bf08-4e28-82d3-c934fc8dff38", "0PQpBf8XIWCj");
        textToSpeech.setEndPoint("https://stream.watsonplatform.net/text-to-speech/api");
        try {
            SynthesizeOptions synthesizeOptions = new SynthesizeOptions.Builder().text(value).accept("audio/wav").voice("en-US_AllisonVoice").build();
            InputStream inputStream = (InputStream)textToSpeech.synthesize(synthesizeOptions).execute();
            InputStream in = WaveUtils.reWriteWaveHeader((InputStream)inputStream);
            AudioInputStream audio = AudioSystem.getAudioInputStream(new BufferedInputStream(in));
            player = new AudioPlayer(audio);
            player.start();
            player.join();
            in.close();
            inputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void logConsoleMessage(Priority priority, String value) {
        if (TestObject.getTestInfo().log == null) {
            return;
        }
        Boolean enableBatchLogging = CrossPlatformProperties.getEnableBatchLogging();
        value = Helper.date.getTimestampSeconds() + " : " + TestLog.getTestLogPrefix() + value;
        if (!enableBatchLogging.booleanValue()) {
            TestObject.getTestInfo().log.log(priority, (Object)value);
        }
        if (!TestObject.getTestInfo().isTestComplete.booleanValue() && enableBatchLogging.booleanValue()) {
            LogObject log = new LogObject(value, priority);
            TestObject.getTestInfo().testLog.add(log);
        }
    }

    private static String getTestLogPrefix() {
        return TestObject.getTestInfo().className + "-" + TestObject.getTestInfo().testName + " - ";
    }

    public static synchronized void printLogsToConsole() {
        Boolean enableBatchLogging = CrossPlatformProperties.getEnableBatchLogging();
        if (TestObject.getTestInfo().isTestComplete.booleanValue() && enableBatchLogging.booleanValue()) {
            TestLog.printClassLevelLogsToConsole("Beforeclass");
            TestLog.printLogs(TestObject.getTestInfo().testLog);
        }
    }

    public static void printClassLevelLogsToConsole(String classType) {
        String testId = TestObject.getTestInfo().testFileClassName + "-" + classType;
        if (TestObject.testInfo.get(testId) == null) {
            return;
        }
        List<LogObject> logs = TestObject.getTestInfo((String)testId).testLog;
        TestLog.printLogs(logs, testId);
    }

    public static void printLogs(List<LogObject> logs) {
        TestLog.printLogs(logs, "");
    }

    public static void printLogs(List<LogObject> testLog, String testId) {
        if (testLog.isEmpty()) {
            return;
        }
        for (LogObject log : testLog) {
            if (testId.isEmpty()) {
                TestObject.getTestInfo().log.log(log.priority, (Object)log.value);
                continue;
            }
            TestObject.getTestInfo((String)testId).log.log(log.priority, (Object)log.value);
        }
        if (testId.isEmpty()) {
            TestObject.getTestInfo().testLog = new ArrayList<LogObject>();
        } else {
            TestObject.getTestInfo((String)testId).testLog = new ArrayList<LogObject>();
        }
    }

    static {
        LOG4JPATH = Config.RESOURCE_PATH + "/log4j.xml";
    }

    static enum gherkins {
        Given,
        When,
        Then,
        And,
        But,
        Background;

    }
}

