/*
 * Decompiled with CFR 0.152.
 */
package core.support.listeners;

import com.google.common.base.Joiner;
import core.helpers.Helper;
import core.helpers.ScreenRecorderHelper;
import core.support.configReader.Config;
import core.support.listeners.RetryTest;
import core.support.logger.ExtentManager;
import core.support.logger.TestLog;
import core.support.objects.DeviceManager;
import core.support.objects.DriverObject;
import core.support.objects.TestObject;
import core.uiCore.driverProperties.driverType;
import core.uiCore.driverProperties.globalProperties.CrossPlatformProperties;
import core.uiCore.drivers.AbstractDriverTestNG;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.xml.DOMConfigurator;
import org.testng.IClassListener;
import org.testng.IConfigurationListener;
import org.testng.IRetryAnalyzer;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.xml.XmlSuite;

public class TestListener
implements ITestListener,
IClassListener,
ISuiteListener,
IConfigurationListener {
    public static boolean isTestNG = false;

    public void onStart(ITestContext iTestContext) {
        isTestNG = true;
        iTestContext.setAttribute("WebDriver", (Object)AbstractDriverTestNG.getWebDriver());
        TestLog.setupLog4j();
        TestObject.setLogging();
        DOMConfigurator.configure((String)TestLog.LOG4JPATH);
        this.cleanupProcessess();
        iTestContext.setAttribute("platform", (Object)"");
        for (ITestNGMethod method : iTestContext.getAllTestMethods()) {
            method.setRetryAnalyzer((IRetryAnalyzer)new RetryTest(CrossPlatformProperties.getRetryCount()));
        }
        this.setParallelRun(iTestContext);
        ExtentManager.clearTestReport();
        ExtentManager.clearOldTestReports();
    }

    private void initializeDefaultTest(ISuite suite) {
        DriverObject driver = new DriverObject().withDriverType(driverType.DriverType.API).withApp("core");
        if (!suite.getName().contains("Default")) {
            driver.app = suite.getName();
        }
        TestObject.initializeTest(driver, "core");
        TestObject.getTestInfo().withApp(driver.app);
    }

    private void setParallelRun(ITestContext iTestContext) {
        iTestContext.getCurrentXmlTest().setParallel(XmlSuite.ParallelMode.METHODS);
        int threadCount = CrossPlatformProperties.getParallelTests();
        iTestContext.getCurrentXmlTest().setThreadCount(threadCount);
    }

    public void onFinish(ITestContext iTestContext) {
        ExtentManager.writeTestReport();
        DriverObject.quitAllDrivers();
        ExtentManager.launchReportAfterTest();
        ExtentManager.printReportLink();
        this.sendReport(iTestContext);
    }

    private void sendReport(ITestContext iTestContext) {
        String message = this.generateTestMessage(iTestContext);
        boolean hasErrors = iTestContext.getFailedTests().size() > 0;
        boolean slackNotifyOnFailOnly = Config.getBooleanValue("slack.notifyOnFailureOnly");
        boolean emailNotifyOnFailOnly = Config.getBooleanValue("email.notifyOnFailureOnly");
        if (slackNotifyOnFailOnly && hasErrors) {
            ExtentManager.slackNotification(message);
        } else if (!slackNotifyOnFailOnly) {
            ExtentManager.slackNotification(message);
        }
        if (emailNotifyOnFailOnly && hasErrors) {
            ExtentManager.emailTestReport(message);
        } else if (!emailNotifyOnFailOnly) {
            ExtentManager.emailTestReport(message);
        }
    }

    public void onTestStart(ITestResult iTestResult) {
        this.setTestClassName(iTestResult);
        ScreenRecorderHelper.startRecording();
    }

    public void onTestSuccess(ITestResult iTestResult) {
        TestObject.getTestInfo().isTestComplete = TestObject.isTestcomplete();
        this.setTestClassName(iTestResult);
        TestObject.getTestInfo().withIsTestPass(true);
        TestLog.Then("Test is finished successfully", new Object[0]);
        TestLog.printLogsToConsole();
        ScreenRecorderHelper.stopRecording();
        if (CrossPlatformProperties.isSingleSignIn().booleanValue() && AbstractDriverTestNG.getWebDriver() != null) {
            DriverObject.setDriverAvailabiltity(AbstractDriverTestNG.getWebDriver(), true);
        }
        DeviceManager.setDeviceAvailability(true);
        if (!CrossPlatformProperties.isSingleSignIn().booleanValue()) {
            DriverObject.quitTestDrivers();
        }
        TestObject.getTestInfo().resetTestObject();
    }

    public void onTestFailure(ITestResult iTestResult) {
        TestObject.getTestInfo().isTestComplete = TestObject.isTestcomplete();
        this.setTestClassName(iTestResult);
        TestLog.printLogsToConsole();
        TestObject.getTestInfo().withIsForcedRestart(true);
        TestObject.getTestInfo().isFirstRun = true;
        TestObject.getTestInfo().withIsTestPass(false);
        DeviceManager.setDeviceAvailability(true);
        ScreenRecorderHelper.stopRecording();
        DriverObject.quitTestDrivers();
        TestObject.getTestInfo().resetTestObject();
    }

    public void onTestSkipped(ITestResult iTestResult) {
        TestObject.getTestInfo().withIsForcedRestart(true);
        TestObject.getTestInfo().isFirstRun = true;
        TestObject.getTestInfo().withIsTestPass(false);
        iTestResult.setStatus(3);
        DeviceManager.setDeviceAvailability(true);
        ScreenRecorderHelper.stopRecording();
        DriverObject.quitTestDrivers();
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult iTestResult) {
        TestLog.ConsoleLog("Test failed But it is in defined success ratio " + TestObject.getTestInfo().testName, new Object[0]);
    }

    public void cleanupProcessess() {
        if (Helper.mobile.isMobile()) {
            Helper.killWindowsProcess("node.exe");
        }
        Helper.killWindowsProcess("IEDriverServer.exe");
        Helper.killWindowsProcess("chromedriver.exe");
        Helper.killWindowsProcess("MicrosoftWebDriver.exe");
    }

    public String generateTestMessage(ITestContext iTestContext) {
        int testCount = iTestContext.getPassedTests().size() + iTestContext.getFailedTests().size();
        String message = iTestContext.getPassedTests().size() + " of " + testCount + " tests passed.";
        if (iTestContext.getFailedTests().size() > 0) {
            ArrayList<String> failedMessage = this.getAllResults(iTestContext.getFailedTests().getAllResults());
            message = message + " Failed test(s): " + Joiner.on((String)",").join(failedMessage);
        }
        return message;
    }

    private ArrayList<String> getAllResults(Collection<ITestResult> results) {
        ArrayList<String> tests = new ArrayList<String>();
        for (ITestResult result : results) {
            String className = result.getInstanceName().substring(result.getInstanceName().lastIndexOf(".") + 1);
            tests.add(className + "." + result.getMethod().getMethodName());
        }
        return tests;
    }

    public void onBeforeClass(ITestClass testClass) {
        String classname = testClass.getName();
        classname = classname.substring(classname.lastIndexOf(".") + 1);
        DriverObject driver = new DriverObject().withDriverType(driverType.DriverType.API);
        new AbstractDriverTestNG().setupWebDriver(classname + TestObject.BEFORE_CLASS_PREFIX, driver);
    }

    public void onAfterClass(ITestClass testClass) {
        String classname = testClass.getName();
        classname = classname.substring(classname.lastIndexOf(".") + 1);
        DriverObject driver = new DriverObject().withDriverType(driverType.DriverType.API);
        new AbstractDriverTestNG().setupWebDriver(classname + TestObject.AFTER_CLASS_PREFIX, driver);
    }

    public void onConfigurationSuccess(ITestResult itr) {
    }

    public void onConfigurationFailure(ITestResult itr) {
    }

    public void onConfigurationSkip(ITestResult itr) {
    }

    public void setTestClassName(ITestResult iTestResult) {
        String classname = iTestResult.getMethod().getTestClass().getName();
        TestObject.getTestInfo().testFileClassName = classname = classname.substring(classname.lastIndexOf(".") + 1);
    }

    public void onStart(ISuite suite) {
        this.initializeDefaultTest(suite);
        String suitename = suite.getName();
        suitename = suitename.replaceAll("\\s", "");
        TestObject.APP_IDENTIFIER = this.getTestPackage(suite);
        TestObject.SUITE_NAME = suitename;
        DriverObject driver = new DriverObject().withDriverType(driverType.DriverType.API);
        new AbstractDriverTestNG().setupWebDriver(TestObject.SUITE_NAME + TestObject.BEFORE_SUITE_PREFIX, driver);
    }

    private String getTestPackage(ISuite suite) {
        String testPackageName = "";
        try {
            testPackageName = ((ITestNGMethod)suite.getAllMethods().get(0)).getInstance().toString();
            testPackageName = testPackageName.substring(testPackageName.indexOf(".") + 1);
            int lastIndex = testPackageName.lastIndexOf(46);
            testPackageName = testPackageName.substring(0, lastIndex);
        }
        catch (Exception e) {
            e.getMessage();
        }
        return testPackageName;
    }

    public void onFinish(ISuite suite) {
        String suitename = suite.getName();
        suitename = suitename.replaceAll("\\s", "");
        DriverObject driver = new DriverObject().withDriverType(driverType.DriverType.API);
        new AbstractDriverTestNG().setupWebDriver(suitename + TestObject.AFTER_SUITE_PREFIX, driver);
    }
}

