/*
 * Decompiled with CFR 0.152.
 */
package core.helpers.csvHelper;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import core.helpers.csvHelper.CsvObject;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class CsvHelper {
    public static final String Path_TestData = "testData/";

    public static String getCellData(CsvObject csv) throws Exception {
        String cellValue = "";
        CSVReader readcsv = new CSVReader((Reader)new FileReader(Path_TestData + csv.csvFile));
        List myData = readcsv.readAll();
        cellValue = ((String[])myData.get(csv.row))[csv.column];
        readcsv.close();
        return cellValue;
    }

    public static List<String[]> getAllCsvData(String filePath, CsvObject csv) {
        List<Object> csvList = new ArrayList<String[]>();
        try {
            CSVReader readcsv = new CSVReader((Reader)new FileReader(filePath + csv.csvFile));
            csvList = readcsv.readAll();
            readcsv.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return csvList;
    }

    public static List<String[]> getAllCsvData(String filePath) {
        List<Object> csvList = new ArrayList<String[]>();
        try {
            CSVReader readcsv = new CSVReader((Reader)new FileReader(filePath));
            csvList = readcsv.readAll();
            readcsv.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return csvList;
    }

    public static List<String[]> getAllCsvDataFirstRowAsHeader(String filePath) {
        List<Object> csvList = new ArrayList<String[]>();
        try {
            CSVReader readcsv = new CSVReader((Reader)new FileReader(filePath), ',', '\"', 1);
            csvList = readcsv.readAll();
            readcsv.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return csvList;
    }

    public static void writeNewCsv(CsvObject csv) throws Exception {
        String csvPath = Path_TestData + csv.csvFile;
        CSVWriter writer = new CSVWriter((Writer)new FileWriter(csvPath));
        writer.writeNext(csv.value);
        writer.close();
    }

    public static void appendCsv(CsvObject csv) throws Exception {
        String csvPath = Path_TestData + csv.csvFile;
        CSVWriter writer = new CSVWriter((Writer)new FileWriter(csvPath, true));
        writer.writeNext(csv.value);
        writer.close();
    }
}

