/*
 * Decompiled with CFR 0.152.
 */
package core.helpers.click;

import core.helpers.Element;
import core.helpers.Helper;
import core.support.logger.TestLog;
import core.uiCore.drivers.AbstractDriver;
import core.uiCore.webElement.EnhancedBy;
import core.uiCore.webElement.EnhancedWebElement;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebElement;

public class ClickHelperJs
extends Element {
    public void clickAndExpect(EnhancedBy target, EnhancedBy expected) {
        this.clickAndExpect(target, 0, expected, true);
    }

    public void clickAndExpect(EnhancedBy target, EnhancedBy expected, boolean mobileRefresh) {
        this.clickAndExpect(target, 0, expected, mobileRefresh);
    }

    public void clickAndExpectByText(EnhancedBy target, String text, EnhancedBy expected) {
        TestLog.logPass("I click " + target.name, new Object[0]);
        Helper.wait.waitForElementToBeClickable(target);
        boolean isExpectedFound = false;
        int targetWaitTimeInSeconds = 5;
        int retry = AbstractDriver.TIMEOUT_SECONDS / targetWaitTimeInSeconds;
        do {
            --retry;
            if (!Helper.isPresent(target)) continue;
            Helper.list.selectListItemEqualsByName(target, text);
        } while (!(isExpectedFound = Helper.wait.waitForElementToLoad(expected, targetWaitTimeInSeconds)) && retry > 0);
        Helper.assertTrue("expected element not found: " + expected.name, isExpectedFound);
    }

    public void clickAndExpect(EnhancedBy target, int index, EnhancedBy expected, boolean mobileRefresh) {
        TestLog.logPass("I click " + target.name, new Object[0]);
        Helper.wait.waitForElementToBeClickable(target);
        boolean isExpectedFound = false;
        int targetWaitTimeInSeconds = 5;
        int retry = AbstractDriver.TIMEOUT_SECONDS / targetWaitTimeInSeconds;
        do {
            --retry;
            if (Helper.isPresent(target)) {
                this.clickJs(target, index);
            }
            if (!(isExpectedFound = Helper.wait.waitForElementToLoad(expected, targetWaitTimeInSeconds)) && mobileRefresh) {
                Helper.mobile.refreshMobileApp();
            }
            TestLog.ConsoleLog("clickAndExpect: expected: " + expected.name + " : " + isExpectedFound, new Object[0]);
        } while (!isExpectedFound && retry > 0);
        Helper.assertTrue("expected element not found: " + expected.name, isExpectedFound);
    }

    public void clickJs(EnhancedBy target, int index) {
        EnhancedWebElement targetElement = Element.findElements(target);
        WebElement element = targetElement.get(index);
        ((JavascriptExecutor)AbstractDriver.getWebDriver()).executeScript("arguments[0].click()= true;", new Object[]{element});
    }

    public void clickAndExpect(EnhancedBy target, int index, EnhancedBy expected) {
        this.clickAndExpect(target, index, expected, true);
    }

    public void clickAndExpect(EnhancedBy target, int index, EnhancedBy expected1, EnhancedBy expected2) {
        TestLog.logPass("I click " + target.name, new Object[0]);
        Helper.wait.waitForElementToBeClickable(target);
        boolean isExpectedFound = false;
        int targetWaitTimeInSeconds = 5;
        int retry = AbstractDriver.TIMEOUT_SECONDS / targetWaitTimeInSeconds;
        do {
            --retry;
            if (Helper.isPresent(target)) {
                this.clickJs(target, index);
            }
            if (!(isExpectedFound = Helper.wait.waitForFirstElementToLoad(expected1, expected2, targetWaitTimeInSeconds))) {
                Helper.mobile.refreshMobileApp();
            }
            TestLog.ConsoleLog("clickAndExpect: expected: " + expected1.name + " : or: " + expected2.name + " : " + isExpectedFound, new Object[0]);
        } while (!isExpectedFound && retry > 0);
        Helper.assertTrue("expected element not found: " + expected1.name, isExpectedFound);
    }

    public void clickAndExpect(EnhancedBy target, EnhancedBy expected, EnhancedBy spinner) {
        TestLog.logPass("I click " + target.name, new Object[0]);
        Helper.wait.waitForElementToBeClickable(target);
        boolean isExpectedFound = false;
        int targetWaitTimeInSeconds = 5;
        int retry = AbstractDriver.TIMEOUT_SECONDS / targetWaitTimeInSeconds;
        do {
            --retry;
            if (Helper.isPresent(target)) {
                this.clickJs(target, 0);
            }
            Helper.wait.waitForSeconds(0.5);
            Helper.wait.waitForElementToBeRemoved(spinner);
        } while (!(isExpectedFound = Helper.wait.waitForElementToLoad(expected, targetWaitTimeInSeconds)) && retry > 0);
        Helper.assertTrue("expected element not found: " + expected.name, isExpectedFound);
    }

    public void clickAndNotExpect(EnhancedBy target, EnhancedBy expected) {
        this.clickAndNotExpect(target, 0, expected);
    }

    public void clickAndNotExpect(EnhancedBy target, int index, EnhancedBy expected) {
        TestLog.logPass("I click " + target.name, new Object[0]);
        Helper.wait.waitForElementToBeClickable(target);
        EnhancedWebElement expectedElement = null;
        int targetWaitTimeInSeconds = 5;
        int retry = AbstractDriver.TIMEOUT_SECONDS / targetWaitTimeInSeconds;
        do {
            --retry;
            if (Helper.isPresent(target)) {
                this.clickJs(target, index);
            }
            Helper.wait.waitForSeconds(0.5);
            Helper.wait.waitForElementToBeRemoved(expected, targetWaitTimeInSeconds);
        } while ((expectedElement = Element.findElements(expected)).isExist(new int[0]) && retry > 0);
        Helper.assertTrue("expected element found", !expectedElement.isExist(new int[0]));
    }

    public void clickAndWait(EnhancedBy target, double timeInSeconds) {
        this.clickAndWait(target, 0, timeInSeconds);
    }

    public void clickAndWait(EnhancedBy target, int index, double timeInSeconds) {
        TestLog.logPass("I click " + target.name, new Object[0]);
        Helper.wait.waitForElementToBeClickable(target);
        this.clickJs(target, index);
        Helper.wait.waitForSeconds(timeInSeconds);
    }

    public void clickElementContinsByText(EnhancedBy by, String text) {
        TestLog.ConsoleLog("I click element " + by.name + " with text containing: " + text, new Object[0]);
        Helper.list.selectListItemContainsByName(by, text);
    }
}

