/*
 * Decompiled with CFR 0.152.
 */
package core.helpers;

import allbegray.slack.SlackClientFactory;
import allbegray.slack.webapi.SlackWebApiClient;
import core.helpers.Element;
import core.helpers.Helper;
import core.support.configReader.Config;
import core.support.logger.ExtentManager;
import core.support.logger.TestLog;
import core.support.objects.TestObject;
import core.uiCore.drivers.AbstractDriver;
import core.uiCore.drivers.AbstractDriverTestNG;
import core.uiCore.webElement.EnhancedBy;
import core.uiCore.webElement.EnhancedWebElement;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import java8.util.concurrent.ThreadLocalRandom;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.TakesScreenshot;
import org.zeroturnaround.zip.ZipUtil;

public class UtilityHelper {
    protected static String generateRandomString(int len) {
        String AB = "0123456789abcdefghijklmnopqrstuvwxyz";
        SecureRandom rnd = new SecureRandom();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            sb.append(AB.charAt(rnd.nextInt(AB.length())));
        }
        return sb.toString();
    }

    protected static String generateRandomInteger(int len) {
        String AB = "0123456789";
        SecureRandom rnd = new SecureRandom();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            sb.append(AB.charAt(rnd.nextInt(AB.length())));
        }
        return sb.toString();
    }

    protected static int generateRandomNumber(int min, int max) {
        int random = ThreadLocalRandom.current().nextInt(min, max + 1);
        return random;
    }

    protected static String stringNormalize(String value) {
        value = value.trim().replace("\n", "").replace("\r", "").replace("\"", "");
        return value;
    }

    protected static String stringRemoveLines(String value) {
        value = value.trim().replace("\n", "").replace("\r", "");
        return value;
    }

    protected static boolean isProcessRunning(String serviceName) throws Exception {
        String line;
        String TASKLIST = "tasklist";
        Process p = Runtime.getRuntime().exec(TASKLIST);
        BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
        while ((line = reader.readLine()) != null) {
            if (!line.contains(serviceName)) continue;
            return true;
        }
        return false;
    }

    protected static void killWindowsProcess(String serviceName) {
        String KILL = "taskkill /F /IM ";
        try {
            if (UtilityHelper.isProcessRunning(serviceName)) {
                Runtime.getRuntime().exec(KILL + serviceName);
            }
        }
        catch (IOException e) {
            e.getMessage();
        }
        catch (Exception e) {
            e.getMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ArrayList<String> runShellCommand(String cmd) {
        ArrayList<String> results = new ArrayList<String>();
        Process pr = null;
        boolean success = false;
        int retry = 3;
        do {
            --retry;
            try {
                String line;
                Runtime run = Runtime.getRuntime();
                pr = run.exec(cmd);
                pr.waitFor();
                BufferedReader buf = new BufferedReader(new InputStreamReader(pr.getInputStream()));
                while ((line = buf.readLine()) != null) {
                    results.add(line);
                }
                success = true;
            }
            catch (Exception e) {
                TestLog.ConsoleLogDebug("shell command:  '" + cmd + "' output: " + e.getMessage(), new Object[0]);
            }
            finally {
                if (pr != null) {
                    pr.destroy();
                }
            }
        } while (!success && retry > 0);
        return results;
    }

    protected static void copyDirectory(String dirFrom, String dirTo) {
        File srcDir = new File(dirFrom);
        File destDir = new File(dirTo);
        try {
            FileUtils.copyDirectory((File)srcDir, (File)destDir);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected static void executeJavascript(String script) {
        JavascriptExecutor js = (JavascriptExecutor)AbstractDriver.getWebDriver();
        js.executeScript(script, new Object[0]);
    }

    protected static ZipOutputStream zipFolder(String srcFolder, String destZipFile) throws Exception {
        ZipOutputStream zip = UtilityHelper.createZip(destZipFile);
        zip.flush();
        zip.close();
        return zip;
    }

    protected static ZipOutputStream createZip(String destZipFile) throws FileNotFoundException {
        ZipOutputStream zip = null;
        FileOutputStream fileWriter = null;
        fileWriter = new FileOutputStream(destZipFile);
        zip = new ZipOutputStream(fileWriter);
        return zip;
    }

    protected static void addFileToZip(String path, String srcFile, ZipOutputStream zip) throws Exception {
        File folder = new File(srcFile);
        if (folder.isDirectory()) {
            UtilityHelper.addFolderToZip(path, srcFile, zip);
        } else {
            int len;
            byte[] buf = new byte[1024];
            FileInputStream in = new FileInputStream(srcFile);
            zip.putNextEntry(new ZipEntry(path + File.separator + folder.getName()));
            while ((len = in.read(buf)) > 0) {
                zip.write(buf, 0, len);
            }
            in.close();
        }
    }

    private static void addFolderToZip(String path, String srcFolder, ZipOutputStream zip) throws Exception {
        File folder = new File(srcFolder);
        for (String fileName : folder.list()) {
            if (path.equals("")) {
                UtilityHelper.addFileToZip(folder.getName(), srcFolder + File.separator + fileName, zip);
                continue;
            }
            UtilityHelper.addFileToZip(path + File.separator + folder.getName(), srcFolder + File.separator + fileName, zip);
        }
    }

    protected static List<String> getAllValuesStartringWith(String source, String value) {
        ArrayList<String> values = new ArrayList<String>();
        Pattern pattern = Pattern.compile(value + "\\w+");
        Matcher matcher = pattern.matcher(source);
        while (matcher.find()) {
            values.add(matcher.group());
        }
        return values;
    }

    protected static String getValueFromPattern(String str, String pattern) {
        return UtilityHelper.getValuesFromPattern(str, pattern).get(0);
    }

    protected static List<String> getValuesFromPattern(String str, String pattern) {
        Pattern TAG_REGEX = Pattern.compile(pattern);
        ArrayList<String> tagValues = new ArrayList<String>();
        Matcher matcher = TAG_REGEX.matcher(str);
        while (matcher.find()) {
            tagValues.add(matcher.group(1));
        }
        return tagValues;
    }

    protected static String getCurrentDir() {
        Path currentWorkingDir = Paths.get("", new String[0]).toAbsolutePath();
        return currentWorkingDir.normalize().toString() + File.separator;
    }

    public static void slackNotificationWithFile(String title, String comment, String filePath) {
        String token = Config.getValue("slack.slackToken");
        String channelId = Config.getValue("slack.channelId");
        SlackWebApiClient webApiClient = SlackClientFactory.createWebApiClient((String)token);
        File testfile = new File(filePath);
        webApiClient.auth();
        if (testfile != null && testfile.exists()) {
            webApiClient.uploadFile(testfile, title, comment, channelId);
        }
    }

    public static String zipDir(String sourceDir, String destFilePath) {
        String destFile = destFilePath + ".zip";
        ZipUtil.pack((File)new File(sourceDir), (File)new File(destFile));
        Helper.wait.waitForSeconds(3.0);
        return destFile;
    }

    protected static ArrayList<File> getFileList(String directoryPath, String type) {
        File folder = new File(directoryPath);
        File[] listOfFiles = folder.listFiles();
        ArrayList<File> testFiles = new ArrayList<File>();
        if (listOfFiles == null) {
            Helper.softAssertTrue("test files not found at: " + directoryPath + " type: " + type, false);
            return testFiles;
        }
        for (int i = 0; i < listOfFiles.length; ++i) {
            if (!listOfFiles[i].isFile() || !listOfFiles[i].getName().endsWith(type)) continue;
            testFiles.add(listOfFiles[i]);
        }
        return testFiles;
    }

    protected static List<File> getFileListWithSubfolders(String directoryName, String type, List<File> files) {
        File directory = new File(directoryName);
        File[] fList = directory.listFiles();
        if (fList != null) {
            for (File file : fList) {
                if (file.isFile() && file.getName().endsWith(type)) {
                    files.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                UtilityHelper.getFileListWithSubfolders(file.getAbsolutePath(), type, files);
            }
        }
        return files;
    }

    protected static void createFileFromPath(String absolutePath) {
        File media = new File(absolutePath);
        Path pathToFile = Paths.get(absolutePath, new String[0]);
        try {
            Files.createDirectories(pathToFile.getParent(), new FileAttribute[0]);
            media.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected static void captureExtentReportScreenshot() {
        Date now = new Date();
        String format1 = new SimpleDateFormat("yyyy-MM-dd'T'HH-mm-ss", Locale.ENGLISH).format(now);
        String extentReportImageFullPath = ExtentManager.getScreenshotsFolderFullPath() + TestObject.getTestInfo().testName + "-" + format1 + ".png";
        String extentReportImageRelativePath = ExtentManager.getScreenshotsFolderRelativePath() + TestObject.getTestInfo().testName + "-" + format1 + ".png";
        try {
            File scrFile = (File)((TakesScreenshot)AbstractDriverTestNG.getWebDriver()).getScreenshotAs(OutputType.FILE);
            FileUtils.copyFile((File)scrFile, (File)new File(extentReportImageFullPath));
            if (Config.getValue("report.reporterType").equals("html")) {
                AbstractDriver.getStep().get().info("").addScreenCaptureFromPath(extentReportImageRelativePath);
            } else {
                AbstractDriver.getStep().get().info("").addScreenCaptureFromPath(extentReportImageFullPath);
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
    }

    public static File captureElementPicture(EnhancedBy element) {
        return UtilityHelper.captureElementPicture(element, 0);
    }

    public static File captureElementPicture(EnhancedBy element, int index) {
        File screen = null;
        try {
            EnhancedWebElement targetElement = Element.findElements(element);
            screen = (File)((TakesScreenshot)AbstractDriverTestNG.getWebDriver()).getScreenshotAs(OutputType.FILE);
            BufferedImage img = ImageIO.read(screen);
            int originalImageWidth = img.getWidth();
            int originalImageHeight = img.getHeight();
            int actualTestWidth = AbstractDriverTestNG.getWebDriver().findElement((By)By.tagName((String)"body")).getRect().width;
            int actualTestHeight = AbstractDriverTestNG.getWebDriver().findElement((By)By.tagName((String)"body")).getRect().height;
            if (Helper.mobile.isMobile()) {
                actualTestWidth = AbstractDriverTestNG.getWebDriver().manage().window().getSize().width;
                actualTestHeight = AbstractDriverTestNG.getWebDriver().manage().window().getSize().height;
            }
            double widthRatio = (double)originalImageWidth / (double)actualTestWidth;
            double heightRatio = (double)originalImageHeight / (double)actualTestHeight;
            int elementWidth = targetElement.get(index).getSize().getWidth();
            int elementHeight = targetElement.get(index).getSize().getHeight();
            Rectangle rect = new Rectangle(elementWidth, elementHeight);
            Point p = targetElement.get(index).getLocation();
            int xValue = (int)((double)p.getX() * widthRatio);
            int yValue = (int)((double)p.getY() * heightRatio);
            int widthValue = (int)((double)rect.width * widthRatio);
            int heightValue = (int)((double)rect.height * heightRatio);
            BufferedImage dest = img.getSubimage(xValue, yValue, widthValue, heightValue);
            ImageIO.write((RenderedImage)dest, "png", screen);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return screen;
    }

    protected static void highLightWebElement(EnhancedBy by, int index) {
        if (!Helper.isWebDriver()) {
            return;
        }
        if (!Config.getBooleanValue("web.element.highlight.enable").booleanValue()) {
            return;
        }
        double duration = Config.getDoubleValue("web.element.highlight.waitDurationInSeconds");
        JavascriptExecutor jsEx = (JavascriptExecutor)AbstractDriver.getWebDriver();
        EnhancedWebElement targetElement = Element.findElements(by);
        jsEx.executeScript("arguments[0].setAttribute('style', 'background: yellow; border: 2px solid red;');", new Object[]{targetElement.get(index)});
        Helper.waitForSeconds(duration);
        jsEx.executeScript("arguments[0].setAttribute('style','border: solid 2px white');", new Object[]{targetElement.get(index)});
    }

    protected static boolean isMac() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.contains("mac");
    }

    protected static boolean isWindows() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.contains("win");
    }

    protected static boolean isUnix() {
        String osName = System.getProperty("os.name");
        return osName.indexOf("nix") >= 0 || osName.indexOf("nux") >= 0 || osName.indexOf("aix") > 0;
    }

    protected static boolean isUUID(String value) {
        try {
            UUID.fromString(value);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

