/*
 * Decompiled with CFR 0.152.
 */
package core.helpers;

import core.helpers.Element;
import core.helpers.Helper;
import core.support.logger.TestLog;
import core.uiCore.drivers.AbstractDriver;
import core.uiCore.webElement.EnhancedBy;
import core.uiCore.webElement.EnhancedWebElement;
import java.io.File;
import java.util.List;

public class FileUploadHelper {
    protected static void uploadFile(String location, EnhancedBy fileButton) {
        File file = new File("");
        String path = file.getAbsolutePath() + location;
        Helper.form.setField(fileButton, path);
        TestLog.logPass("I upload file at location '" + location + "'", new Object[0]);
    }

    protected static void uploadAndAcceptFile(String location, EnhancedBy fileButton, EnhancedBy accept) {
        File file = new File("");
        String path = file.getAbsolutePath() + location;
        EnhancedWebElement fieldElement = Element.findElements(fileButton);
        fieldElement.click();
        AbstractDriver.getWebDriver().switchTo().activeElement().sendKeys(new CharSequence[]{path});
        EnhancedWebElement acceptElement = Element.findElements(accept);
        acceptElement.click();
        TestLog.logPass("I upload file at location '" + location + "'", new Object[0]);
    }

    protected static void uploadImages(List<String> locations, EnhancedBy imageButton, EnhancedBy images) {
        for (String location : locations) {
            FileUploadHelper.uploadImage(location, imageButton, images);
        }
    }

    protected static void uploadImage(String location, EnhancedBy imageButton, EnhancedBy images) {
        int imageCount = Helper.list.getListCount(images);
        File file = new File("");
        String path = file.getAbsolutePath() + location;
        Helper.form.setField(imageButton, path);
        Helper.wait.waitForAdditionalElementsToLoad(images, imageCount);
        TestLog.logPass("I upload image at location '" + location + "'", new Object[0]);
    }
}

