/*
 * Decompiled with CFR 0.152.
 */
package core.helpers;

import core.support.logger.TestLog;
import org.junit.Assert;
import org.testng.asserts.SoftAssert;

public class AssertHelper {
    protected static void assertTrue(String message, boolean value) {
        Assert.assertTrue((String)message, (boolean)value);
    }

    protected static void assertFalse(String message) {
        Assert.assertTrue((String)message, (boolean)false);
    }

    protected static void assertEquals(String expected, String actual) {
        TestLog.logPass("validating if expected: " + expected + " equals to actual: " + actual, new Object[0]);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    protected static void assertEquals(int expected, int actual) {
        TestLog.logPass("validating if expected: " + expected + " equals to actual: " + actual, new Object[0]);
        Assert.assertEquals((long)expected, (long)actual);
    }

    protected static void softAssertTrue(String message, boolean value) {
        SoftAssert softAssertion = new SoftAssert();
        softAssertion.assertTrue(value, message);
        TestLog.ConsoleLogWarn("soft assert failed: " + message, new Object[0]);
    }

    protected static void softAssertEqual(String expected, String actual) {
        SoftAssert softAssertion = new SoftAssert();
        softAssertion.assertEquals(actual, expected);
        TestLog.ConsoleLogWarn("soft assert failed: expected: " + expected + " but actual was: " + actual, new Object[0]);
    }

    protected static void softAssertEqual(int expected, int actual) {
        SoftAssert softAssertion = new SoftAssert();
        softAssertion.assertEquals(actual, expected);
        TestLog.ConsoleLogWarn("soft assert failed: expected: " + expected + " but actual was: " + actual, new Object[0]);
    }

    protected static void assertContains(String actual, String expected) {
        TestLog.logPass("validating if expected: " + expected + " contains actual: " + actual, new Object[0]);
        AssertHelper.assertTrue("actual: " + actual + " does not contain expected: " + expected, actual.contains(expected));
    }
}

