/*
 * Decompiled with CFR 0.152.
 */
package core.apiCore.interfaces;

import core.apiCore.helpers.ConnectionHelper;
import core.apiCore.helpers.DataHelper;
import core.apiCore.helpers.SqlHelper;
import core.helpers.Helper;
import core.helpers.StopWatchHelper;
import core.support.configReader.Config;
import core.support.logger.TestLog;
import core.support.objects.KeyValue;
import core.support.objects.ServiceObject;
import core.uiCore.driverProperties.globalProperties.CrossPlatformProperties;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SqlInterface {
    private static final String SQL_JDBC_DRIVER = "db.url";
    private static final String SQL_DB_URL = "db.name";
    private static final String SQL_DB_NAME = "db.username";
    private static final String SQL_DB_USERNAME = "DBUsername";
    private static final String SQL_DB_PASSWORD = "db.password";
    public static Connection conn = null;

    public static void DataBaseInterface(ServiceObject apiObject) throws Exception {
        SqlInterface.connectDb();
        ResultSet resSet = SqlInterface.evaluateDbQuery(apiObject);
        SqlInterface.evaluateReponse(apiObject, resSet);
    }

    public static synchronized void connectDb() {
        if (conn == null) {
            try {
                ConnectionHelper.sshConnect();
                String SQLDriver = Config.getValue(SQL_JDBC_DRIVER);
                Class.forName(SQLDriver);
                String dbURL = Config.getValue(SQL_DB_URL);
                String dbName = Config.getValue(SQL_DB_NAME);
                String connectionString = dbURL + "/" + dbName;
                String dbUserName = Config.getValue(SQL_DB_USERNAME);
                String dbPassword = Config.getValue(SQL_DB_PASSWORD);
                TestLog.logPass("db connection: " + connectionString, new Object[0]);
                TestLog.logPass("db username: " + dbUserName, new Object[0]);
                TestLog.logPass("db password: " + dbPassword, new Object[0]);
                conn = DriverManager.getConnection(connectionString, dbUserName, dbPassword);
                Helper.wait.waitForSeconds(1.0);
            }
            catch (Exception e) {
                TestLog.logPass("sql connection failed: " + e.getMessage(), new Object[0]);
                Helper.assertTrue("sql connection failed", false);
            }
        }
    }

    public static ResultSet evaluateDbQuery(ServiceObject apiObject) throws Exception {
        apiObject.withRequestBody(DataHelper.replaceParameters(apiObject.getRequestBody()));
        String sql = apiObject.getRequestBody();
        TestLog.logPass("sql statement: " + sql, new Object[0]);
        PreparedStatement sqlStmt = conn.prepareStatement(sql, 1004, 1008);
        ResultSet resSet = SqlInterface.executeAndWaitForDbResponse(sqlStmt, apiObject);
        return resSet;
    }

    public static void evaluateReponse(ServiceObject apiObject, ResultSet resSet) throws Exception {
        if (apiObject.getExpectedResponse().isEmpty() && apiObject.getOutputParams().isEmpty()) {
            return;
        }
        if (!resSet.isBeforeFirst()) {
            Helper.assertTrue("no results returned from db query", false);
        }
        resSet.next();
        SqlHelper.saveOutboundSQLParameters(resSet, apiObject.getOutputParams());
        SqlInterface.validateExpectedResponse(apiObject.getExpectedResponse(), resSet);
        resSet.close();
    }

    public static ResultSet executeAndWaitForDbResponse(PreparedStatement sqlStmt, ServiceObject apiObject) throws SQLException {
        ResultSet resSet;
        int timeout = CrossPlatformProperties.getGlobalTimeout();
        StopWatchHelper watch = StopWatchHelper.start();
        boolean messageReceived = false;
        long passedTimeInSeconds = 0L;
        do {
            sqlStmt.execute();
            resSet = sqlStmt.getResultSet();
            if (apiObject.getExpectedResponse().isEmpty()) {
                return resSet;
            }
            if (resSet.isBeforeFirst()) {
                messageReceived = true;
                return resSet;
            }
            Helper.wait.waitForSeconds(1.0);
            passedTimeInSeconds = watch.time(TimeUnit.SECONDS);
        } while (!messageReceived && passedTimeInSeconds < (long)timeout);
        return resSet;
    }

    public static void validateExpectedResponse(String expected, ResultSet resSet) throws SQLException {
        String[] criteria;
        if (expected.isEmpty()) {
            return;
        }
        expected = DataHelper.replaceParameters(expected);
        TestLog.logPass("expected result: " + Helper.stringRemoveLines(expected), new Object[0]);
        for (String criterion : criteria = expected.split("&&")) {
            if (SqlHelper.isValidJson(criterion)) {
                SqlHelper.validateByJsonBody(criterion, resSet);
                continue;
            }
            List<KeyValue> keywords = DataHelper.getValidationMap(expected);
            SqlHelper.validateSqlKeywords(keywords, resSet);
        }
    }
}

