/*
 * Decompiled with CFR 0.152.
 */
package core.apiCore.interfaces;

import core.apiCore.helpers.DataHelper;
import core.apiCore.helpers.JsonHelper;
import core.helpers.Helper;
import core.support.configReader.Config;
import core.support.logger.TestLog;
import core.support.objects.KeyValue;
import core.support.objects.ServiceObject;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Authentication {
    public static final String AUTHENTICATION_SCHEME = "auth";

    public static Response tokenGenerator(ServiceObject apiObject) {
        if (apiObject == null) {
            Helper.assertFalse("apiobject is null");
        }
        apiObject.withRequestBody(DataHelper.replaceParameters(apiObject.getRequestBody()));
        Authentication.setURI(apiObject);
        Response response = Authentication.evaluateRequest(apiObject);
        Authentication.validateResponse(response, apiObject);
        return response;
    }

    private static void setURI(ServiceObject apiObject) {
        apiObject.withUriPath(DataHelper.replaceParameters(apiObject.getUriPath()));
        apiObject.withUriPath(Helper.stringRemoveLines(apiObject.getUriPath()));
        if (apiObject.getUriPath().startsWith("http")) {
            RestAssured.baseURI = apiObject.getUriPath();
            apiObject.withUriPath("");
        } else {
            RestAssured.baseURI = Helper.stringRemoveLines(Config.getValue("api.uriPath"));
            TestLog.logPass("request URI: " + RestAssured.baseURI + apiObject.getUriPath(), new Object[0]);
        }
    }

    private static void validateResponse(Response response, ServiceObject apiObject) {
        List<KeyValue> keyword = DataHelper.getValidationMap(apiObject.getOutputParams());
        if (keyword.get((int)0).key.equals(AUTHENTICATION_SCHEME)) {
            String key = (String)keyword.get((int)0).value;
            key = key.replace("$", "").replace("<", "").replace(">", "").trim();
            Config.putValue(key, RestAssured.authentication, "<authentication scheme>");
            return;
        }
        if (response == null) {
            Helper.assertTrue("no response returned", false);
        }
        Authentication.saveOutboundTokens(response, apiObject.getOutputParams());
        if (!apiObject.getRespCodeExp().isEmpty()) {
            TestLog.logPass("expected status code: " + apiObject.getRespCodeExp() + " response status code: " + response.getStatusCode(), new Object[0]);
            ((ValidatableResponse)response.then()).statusCode(Integer.valueOf(apiObject.getRespCodeExp()).intValue());
        }
        Authentication.validateExpectedValues(response, apiObject);
    }

    private static void saveOutboundTokens(Response response, String outputParam) {
        if (response == null || outputParam.isEmpty()) {
            return;
        }
        JsonHelper.configMapJsonKeyValues(response, outputParam);
    }

    private static void validateExpectedValues(Response response, ServiceObject apiObject) {
        String body = response.getBody().asString();
        TestLog.logPass("response: " + body, new Object[0]);
        if (!apiObject.getExpectedResponse().isEmpty()) {
            String[] criteria;
            apiObject.withExpectedResponse(DataHelper.replaceParameters(apiObject.getExpectedResponse()));
            for (String criterion : criteria = apiObject.getExpectedResponse().split("&&")) {
                Helper.assertTrue("expected is not valid format: " + criterion, JsonHelper.isValidExpectation(criterion));
                JsonHelper.validateByJsonBody(criterion, response);
                JsonHelper.validateByKeywords(criterion, response);
            }
        }
    }

    private static RequestSpecification evaluateRequestBody(ServiceObject apiObject) {
        RequestSpecification request = null;
        if (apiObject.getRequestBody().isEmpty()) {
            Helper.assertFalse("no request set");
        }
        Map<String, String> parameterMap = Authentication.getParameters(apiObject);
        TestLog.logPass("authentication type: " + Helper.stringRemoveLines(apiObject.getOption()), new Object[0]);
        switch (apiObject.getOption()) {
            case "BASIC": {
                String username = parameterMap.get("username");
                String password = parameterMap.get("password");
                RestAssured.authentication = RestAssured.basic((String)username, (String)password);
                break;
            }
            case "OAUTH2": {
                String username = parameterMap.get("username");
                String password = parameterMap.get("password");
                String clientId = parameterMap.get("cliendId");
                String clientSecret = parameterMap.get("clientSecret");
                String grantType = parameterMap.get("grantType");
                String scope = parameterMap.get("scope");
                String redirectUri = parameterMap.get("redirectUri");
                request = RestAssured.given().auth().preemptive().basic(clientId, clientSecret).formParam("grant_type", new Object[]{grantType}).formParam("username", new Object[]{username}).formParam("password", new Object[]{password}).formParam("redirect_uri", new Object[]{redirectUri}).formParam("scope", new Object[]{scope});
                break;
            }
            default: {
                Helper.assertFalse("Correct authentication type not set. selected: <" + apiObject.getMethod() + "> Available options: BASIC");
            }
        }
        return request;
    }

    private static Map<String, String> getParameters(ServiceObject apiObject) {
        String[] formData;
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        for (String data : formData = apiObject.getRequestBody().split(",")) {
            String[] keyValue = data.split(":");
            parameterMap.put(keyValue[0].trim(), keyValue[1].trim());
        }
        return parameterMap;
    }

    private static RequestSpecification evaluateOption(ServiceObject apiObject, RequestSpecification request) {
        if (apiObject.getOption().isEmpty()) {
            return request;
        }
        apiObject.withOption(DataHelper.replaceParameters(apiObject.getOption()));
        switch (apiObject.getOption()) {
            default: 
        }
        return request;
    }

    private static Response evaluateRequest(ServiceObject apiObject) {
        Response response = null;
        RequestSpecification request = Authentication.evaluateRequestBody(apiObject);
        request = Authentication.evaluateOption(apiObject, request);
        TestLog.logPass("request body: " + Helper.stringRemoveLines(apiObject.getRequestBody()), new Object[0]);
        TestLog.logPass("request type: " + apiObject.getMethod(), new Object[0]);
        if (request == null) {
            return response;
        }
        switch (apiObject.getMethod()) {
            case "POST": {
                response = (Response)request.when().post(apiObject.getUriPath(), new Object[0]);
                break;
            }
            case "PUT": {
                response = (Response)request.when().put(apiObject.getUriPath(), new Object[0]);
                break;
            }
            case "PATCH": {
                response = (Response)request.when().patch(apiObject.getUriPath(), new Object[0]);
                break;
            }
            case "DELETE": {
                response = (Response)request.when().delete(apiObject.getUriPath(), new Object[0]);
                break;
            }
            case "GET": {
                response = (Response)request.when().get(apiObject.getUriPath(), new Object[0]);
                break;
            }
            case "OPTIONS": {
                response = (Response)request.when().options(apiObject.getUriPath(), new Object[0]);
                break;
            }
            case "HEAD": {
                response = (Response)request.when().head(apiObject.getUriPath(), new Object[0]);
                break;
            }
            default: {
                Helper.assertTrue("request type not found", false);
            }
        }
        TestLog.logPass("response: " + response.getBody().asString(), new Object[0]);
        return (Response)((ValidatableResponse)response.then()).extract().response();
    }
}

