/*
 * Decompiled with CFR 0.152.
 */
package core.apiCore.helpers;

import core.apiCore.helpers.DataHelper;
import core.helpers.Helper;
import core.support.configReader.Config;
import core.support.logger.TestLog;
import core.support.objects.KeyValue;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.hamcrest.Matchers;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.skyscreamer.jsonassert.JSONAssert;
import org.skyscreamer.jsonassert.JSONCompareMode;

public class JsonHelper {
    public static void saveOutboundJsonParameters(Response response, String outputParam) {
        if (response == null || outputParam.isEmpty()) {
            return;
        }
        JsonHelper.configMapJsonKeyValues(response, outputParam);
    }

    public static void configMapJsonKeyValues(Response response, String keyValue) {
        if (keyValue.isEmpty()) {
            return;
        }
        keyValue = DataHelper.replaceParameters(keyValue);
        List<KeyValue> keywords = DataHelper.getValidationMap(keyValue);
        for (KeyValue keyword : keywords) {
            String key = (String)keyword.value;
            key = key.replace("$", "").replace("<", "").replace(">", "").trim();
            String value = JsonHelper.getJsonValue(response, keyword.key);
            if (!keyword.position.isEmpty()) {
                value = value.split(",")[Integer.valueOf(keyword.position) - 1];
            }
            Config.putValue(key, value);
            TestLog.logPass("replacing value " + key + " with: " + value, new Object[0]);
        }
    }

    public static String getJsonValue(Response response, String path) {
        String value = "";
        List<String> values = JsonHelper.getJsonListValueResponse(response, path);
        if (values == null || values.isEmpty()) {
            value = JsonHelper.getJsonStringResponse(response, path);
        }
        if (values != null && !values.isEmpty()) {
            value = JsonHelper.listToString(values);
        }
        return value;
    }

    public static String getResponseValue(Response response) {
        return response.getBody().asString();
    }

    public static String listToString(List<String> values) {
        String result = "";
        for (String val : values) {
            String value = Objects.toString(val, "");
            result = result + value;
            if (values.size() <= 1) continue;
            result = result + ",";
        }
        return result;
    }

    private static List<String> getJsonListValueResponse(Response response, String path) {
        List<String> values = new ArrayList();
        try {
            values = response.jsonPath().getList(path);
        }
        catch (Exception e) {
            e.getMessage();
        }
        if (values == null || values.isEmpty()) {
            TestLog.ConsoleLog("path: <" + path + "> returned empty results", new Object[0]);
        }
        return values;
    }

    private static String getJsonStringResponse(Response response, String path) {
        String value = "";
        if (response.path(path, new String[0]) instanceof String) {
            value = (String)response.path(path, new String[0]);
        }
        if (response.path(path, new String[0]) instanceof Integer) {
            value = Integer.toString((Integer)response.path(path, new String[0]));
        }
        if (response.path(path, new String[0]) instanceof Boolean) {
            value = Boolean.toString((Boolean)response.path(path, new String[0]));
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    public static void validateJsonKeywords(List<KeyValue> keywords, Response response) {
        for (KeyValue keyword : keywords) {
            String jsonPath = Helper.stringNormalize(keyword.key);
            String expectedValue = Helper.stringNormalize((String)keyword.value);
            String command = "";
            String[] expected = expectedValue.split("[\\(\\)]");
            if (expected.length > 1) {
                command = expected[0];
                expectedValue = expected[1];
            } else if (expected.length == 1) {
                command = expectedValue;
                expectedValue = "";
            }
            String responseString = JsonHelper.getJsonValue(response, jsonPath);
            DataHelper.validateCommand(command, responseString, expectedValue, keyword.position);
        }
    }

    public static boolean isJSONValid(String test) {
        try {
            new JSONObject(test);
        }
        catch (JSONException ex) {
            try {
                new JSONArray(test);
            }
            catch (JSONException ex1) {
                return false;
            }
        }
        return true;
    }

    public static void validateByJsonBody(String expectedJson, Response response) {
        if (JsonHelper.isJSONValid(expectedJson = Helper.stringNormalize(expectedJson))) {
            TestLog.logPass("expected: " + Helper.stringRemoveLines(expectedJson), new Object[0]);
            String body = response.getBody().asString();
            try {
                JSONAssert.assertEquals((String)expectedJson, (String)body, (JSONCompareMode)JSONCompareMode.LENIENT);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isValidExpectation(String expectedJson) {
        if (JsonHelper.isJSONValid(expectedJson)) {
            return true;
        }
        return (expectedJson = Helper.stringNormalize(expectedJson)).startsWith("_VERIFY.JSON.PART_") || expectedJson.startsWith("_NOT_EMPTY_") || expectedJson.startsWith("_VERIFY.RESPONSE.BODY_");
    }

    public static void validateByKeywords(String expectedJson, Response response) {
        if (!JsonHelper.isJSONValid(expectedJson = Helper.stringNormalize(expectedJson))) {
            if (expectedJson.startsWith("_VERIFY.JSON.PART_")) {
                List<KeyValue> keywords = DataHelper.getValidationMap(expectedJson);
                JsonHelper.validateJsonKeywords(keywords, response);
            } else if (expectedJson.startsWith("_NOT_EMPTY_")) {
                Helper.assertTrue("response is empty", response != null);
                ((ValidatableResponse)response.then()).body("isEmpty()", Matchers.is((Object)false), new Object[0]);
            }
        }
    }

    public static void validateResponseBody(String expected, Response response) {
        if (!expected.startsWith("_VERIFY.RESPONSE.BODY_")) {
            return;
        }
        expected = expected.replaceFirst("_[^_]*_", "");
        String actual = JsonHelper.getResponseValue(response);
        String[] expectedArr = expected.split("[\\(\\)]");
        String command = expectedArr[0].trim();
        String expectedValue = expectedArr[1].trim();
        DataHelper.validateCommand(command, actual, expectedValue, "1");
    }
}

