/*
 * Decompiled with CFR 0.152.
 */
package core.apiCore.helpers;

import au.com.bytecode.opencsv.CSVReader;
import core.apiCore.TestDataProvider;
import core.helpers.Helper;
import core.support.configReader.Config;
import core.support.configReader.PropertiesReader;
import core.support.objects.ServiceObject;
import core.support.objects.TestObject;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.IntStream;
import org.apache.commons.lang3.ArrayUtils;

public class CsvReader {
    public static synchronized List<Object[]> getTestCasesFromCsvFile() {
        ArrayList<Object[]> testCases = new ArrayList<Object[]>();
        int index = CsvReader.getCurrentTestInvocation();
        String testCaseFile = Config.getValue("api.testCaseFile");
        if (!testCaseFile.isEmpty()) {
            index = CsvReader.getCsvFileIndex(testCaseFile);
        }
        String csvFileName = CsvReader.getCsvFileFromIndex(index);
        List<String[]> csvList = CsvReader.getCsvTestListForTestRunner(csvFileName);
        for (int i = 0; i < csvList.size(); ++i) {
            Object[] obj = new String[]{csvFileName, String.valueOf(i)};
            String[] csvRow = (String[])ArrayUtils.addAll((Object[])csvList.get(i), (Object[])obj);
            String testCase = Config.getValue("api.testCase");
            if (testCaseFile.isEmpty() || testCase.isEmpty()) {
                testCases.add(csvRow);
                continue;
            }
            if (!csvRow[1].equals(testCase)) continue;
            testCases.add(csvRow);
            return testCases;
        }
        return testCases;
    }

    public static Map<String, ServiceObject> mapToApiObject(List<String[]> testCases) {
        ConcurrentHashMap<String, ServiceObject> apiMap = new ConcurrentHashMap<String, ServiceObject>();
        for (String[] testCase : testCases) {
            ServiceObject apiObject = new ServiceObject().setApiObject(testCase[0], testCase[1], testCase[2], testCase[3], testCase[4], testCase[5], testCase[6], testCase[7], testCase[8], testCase[9], testCase[10], testCase[11], testCase[12], testCase[13], testCase[14], testCase[15], "", "");
            apiMap.put(apiObject.getTestCaseID(), apiObject);
        }
        return apiMap;
    }

    public static void getAllTestCases(String testPath, String prefix) {
        ArrayList<File> csvFiles = Helper.getFileList(testPath, prefix);
        for (int i = 0; i < csvFiles.size(); ++i) {
            List<String[]> testCases = CsvReader.getCsvTestList(csvFiles.get(i));
            Map<String, ServiceObject> apiMap = CsvReader.mapToApiObject(testCases);
            TestObject.getTestInfo().apiMap.putAll(apiMap);
        }
    }

    public static synchronized void getAllKeywords() {
        String testFolderPath = Config.getValue("api.keywordPath");
        String csvTestPath = PropertiesReader.getLocalRootPath() + testFolderPath;
        CsvReader.getAllTestCases(csvTestPath, ".csv");
    }

    public static int getCurrentTestInvocation() {
        if (CsvReader.isRunningServiceTest()) {
            String activeTest = TestObject.getTestInfo().testCsvFileName;
            return CsvReader.getCsvFileIndex(activeTest);
        }
        return TestDataProvider.csvFileIndex.getAndIncrement();
    }

    public static boolean isRunningServiceTest() {
        return TestObject.getTestInfo().testCsvFileName != null;
    }

    public static String getCsvFileFromIndex(int index) {
        ArrayList<File> testCsvList = CsvReader.getCsvFileList();
        return testCsvList.get(index).getName();
    }

    public static int getCsvFileCount() {
        return CsvReader.getCsvFileList().size();
    }

    public static ArrayList<File> getCsvFileList() {
        String csvTestPath = PropertiesReader.getLocalRootPath() + Config.getValue("api.parallelTestcasePath");
        ArrayList<File> csvFiles = Helper.getFileList(csvTestPath, ".csv");
        return csvFiles;
    }

    public static int getCsvFileIndex(String fileName) {
        Helper.assertTrue("csv file is null", fileName != null);
        ArrayList<File> csvFiles = CsvReader.getCsvFileList();
        OptionalInt indexOpt = IntStream.range(0, csvFiles.size()).filter(i -> fileName.contains(((File)csvFiles.get(i)).getName())).findFirst();
        Helper.assertTrue("csv file: " + fileName + " not found", indexOpt.isPresent());
        return indexOpt.getAsInt();
    }

    public static List<String[]> getCsvTestListForTestRunner(String csvFile) {
        ArrayList<String[]> csvList = new ArrayList();
        ArrayList<File> testCsvFileList = CsvReader.getCsvFileList();
        int fileIndex = CsvReader.getFileIndex(testCsvFileList, csvFile);
        csvList = CsvReader.getCsvTestList(testCsvFileList.get(fileIndex));
        return csvList;
    }

    public static List<String[]> getCsvTestList(File file) {
        ArrayList<String[]> csvList = new ArrayList<String[]>();
        try {
            String[] line;
            CSVReader reader = new CSVReader((Reader)new FileReader(file.getPath()));
            String[] header = reader.readNext();
            int runFlag = CsvReader.getColumnIndexByName("RunFlag", header);
            int testCaseID = CsvReader.getColumnIndexByName("TestCaseID", header);
            while ((line = reader.readNext()) != null) {
                if (!line[runFlag].equals("Y") || line[testCaseID].isEmpty()) continue;
                csvList.add(line);
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return csvList;
    }

    public static int getFileIndex(ArrayList<File> testCsvFileList, String csvFile) {
        for (int i = 0; i < testCsvFileList.size(); ++i) {
            if (!testCsvFileList.get(i).getName().equals(csvFile)) continue;
            return i;
        }
        return -1;
    }

    public static int getColumnIndexByName(String column, String[] row) {
        for (int i = 0; i < row.length; ++i) {
            if (!row[i].equals(column)) continue;
            return i;
        }
        Helper.assertTrue("column not found", false);
        return -1;
    }

    public static int getCsvTestcount() {
        return CsvReader.getCsvTestListForTestRunner(TestObject.getTestInfo().testCsvFileName).size();
    }
}

