/*
 * Decompiled with CFR 0.152.
 */
package core.uiCore.driverProperties.capabilities;

import core.helpers.Helper;
import core.support.configReader.Config;
import core.support.configReader.PropertiesReader;
import core.support.logger.TestLog;
import core.support.objects.DeviceManager;
import core.support.objects.DeviceObject;
import core.support.objects.TestObject;
import core.uiCore.driverProperties.globalProperties.CrossPlatformProperties;
import core.uiCore.drivers.AbstractDriver;
import io.github.bonigarcia.wdm.WebDriverManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.remote.DesiredCapabilities;

public class IosCapability {
    public DesiredCapabilities capabilities;
    public static String APP_DIR_PATH = "ios.appDir";
    public static String APP_NAME = "ios.app";
    public static String DEVICE_VERSION = "ios.deviceVersion";
    public static String CHROME_VERSION = "appium.chromeVersion";
    public List<String> simulatorList = new ArrayList<String>();
    private static final String CAPABILITIES_PREFIX = "ios.capabilties.";
    public static int WDA_LOCAL_PORT = 8100;

    public IosCapability() {
        this.capabilities = new DesiredCapabilities();
    }

    public String getDriverVersion() {
        String value = Config.getValue(CHROME_VERSION);
        return value;
    }

    public IosCapability withCapability(DesiredCapabilities Capabilities) {
        this.capabilities = Capabilities;
        return this;
    }

    public DesiredCapabilities getCapability() {
        return this.capabilities;
    }

    public IosCapability withDevice(String device) {
        this.simulatorList = Config.getValueList(device);
        return this;
    }

    public String getAppPath() {
        String appRootPath = PropertiesReader.getLocalRootPath() + Config.getValue(APP_DIR_PATH);
        File appPath = new File(appRootPath, Config.getValue(APP_NAME));
        if (!appPath.exists()) {
            TestLog.ConsoleLogWarn("app not found at: " + appPath.getAbsolutePath(), new Object[0]);
        }
        return appPath.getAbsolutePath();
    }

    public IosCapability withIosCapability() {
        this.capabilities = this.setiOSCapabilties();
        this.capabilities.setCapability("app", this.getAppPath());
        if (!this.getDriverVersion().equals("DEFAULT")) {
            WebDriverManager.chromedriver().version(this.getDriverVersion()).setup();
            String chromePath = WebDriverManager.chromedriver().getBinaryPath();
            this.capabilities.setCapability("chromedriverExecutable", chromePath);
        }
        this.setIosDevice();
        this.setPort(TestObject.getTestInfo().deviceName);
        this.setSingleSignIn();
        return this;
    }

    public DesiredCapabilities setiOSCapabilties() {
        Map<String, Object> propertiesMap = TestObject.getTestInfo().config;
        for (Map.Entry<String, Object> entry : propertiesMap.entrySet()) {
            boolean isAndroidCapability = entry.getKey().toString().startsWith(CAPABILITIES_PREFIX);
            if (!isAndroidCapability) continue;
            String fullKey = entry.getKey().toString();
            String key = fullKey.substring(fullKey.lastIndexOf(".") + 1).trim();
            String value = entry.getValue().toString().trim();
            this.capabilities.setCapability(key, value);
        }
        return this.capabilities;
    }

    public void setSingleSignIn() {
        if (CrossPlatformProperties.isSingleSignIn().booleanValue()) {
            if (AbstractDriver.isFirstRun().booleanValue()) {
                this.capabilities.setCapability("noReset", false);
            } else {
                this.capabilities.setCapability("noReset", true);
            }
        }
    }

    public boolean isRealDeviceConnected() {
        List<String> devices = IosCapability.getIosDeviceList();
        return devices.size() > 0;
    }

    public static List<String> getIosDeviceList() {
        String cmd = "idevice_id -l";
        List<Object> results = new ArrayList();
        results = Config.getValueList("ios.UDID");
        if (results.isEmpty() && !(results = Helper.runShellCommand(cmd)).isEmpty() && ((String)results.get(0)).contains("command not found")) {
            Helper.assertFalse("idevice not installed. install: brew install ideviceinstaller");
        }
        if (!results.isEmpty()) {
            TestLog.ConsoleLog("ios device list: " + Arrays.toString(results.toArray()), new Object[0]);
        }
        return results;
    }

    public void setSimulator() {
        int threads;
        List<String> devices = this.simulatorList;
        if (devices == null || devices.size() == 0) {
            Helper.assertFalse("set device first");
        }
        if ((threads = CrossPlatformProperties.getParallelTests()) > devices.size()) {
            Helper.assertFalse("there are more threads than devices. thread count: " + threads + " devices: " + devices.size());
        }
        DeviceManager.loadDevices(devices, DeviceObject.DeviceType.iOS);
        this.capabilities.setCapability("deviceName", DeviceManager.getFirstAvailableDevice(DeviceObject.DeviceType.iOS));
    }

    public void setRealDevices() {
        int threads;
        List<String> devices = IosCapability.getIosDeviceList();
        List<String> deviceNames = this.simulatorList;
        if (deviceNames.size() == 0) {
            Helper.assertFalse("device name is empty. set ios.mobile  or ios.tablet");
        }
        if ((threads = CrossPlatformProperties.getParallelTests()) > devices.size()) {
            Helper.assertFalse("there are more threads than devices. thread count: " + threads + " devices: " + devices.size());
        }
        DeviceManager.loadDevices(devices, DeviceObject.DeviceType.iOS);
        this.capabilities.setCapability("udid", DeviceManager.getFirstAvailableDevice(DeviceObject.DeviceType.iOS));
        this.capabilities.setCapability("deviceName", deviceNames.get(0));
    }

    public void setIosDevice() {
        if (!PropertiesReader.isUsingCloud()) {
            if (this.isRealDeviceConnected()) {
                this.setRealDevices();
            } else {
                this.setSimulator();
            }
        }
    }

    public void setPort(String deviceName) {
        if (DeviceManager.devices.get(deviceName) != null && DeviceManager.devices.get((Object)deviceName).devicePort != -1) {
            this.capabilities.setCapability("wdaLocalPort", (Object)DeviceManager.devices.get((Object)deviceName).devicePort);
        } else {
            int wdaLocalPort = ++WDA_LOCAL_PORT;
            this.capabilities.setCapability("wdaLocalPort", (Object)wdaLocalPort);
            DeviceManager.devices.get(deviceName).withDevicePort(wdaLocalPort);
        }
        TestLog.ConsoleLog("deviceName " + deviceName + " wdaLocalPort: " + DeviceManager.devices.get((Object)deviceName).devicePort, new Object[0]);
    }
}

